/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.apps.gdt;

import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.GestureCategory;
import edu.berkeley.guir.lib.gesture.GestureContainer;
import edu.berkeley.guir.lib.gesture.GestureGroup;
import edu.berkeley.guir.lib.gesture.GestureObject;
import edu.berkeley.guir.lib.gesture.GestureSet;
import edu.berkeley.guir.lib.gesture.apps.gdt.GestureCategoryPanel;
import edu.berkeley.guir.lib.gesture.apps.gdt.GestureCategoryThumbnailPanel;
import edu.berkeley.guir.lib.gesture.apps.gdt.GestureContainerPanel;
import edu.berkeley.guir.lib.gesture.apps.gdt.GestureGroupPanel;
import edu.berkeley.guir.lib.gesture.apps.gdt.GestureGroupThumbnailPanel;
import edu.berkeley.guir.lib.gesture.apps.gdt.GestureObjectDisplay;
import edu.berkeley.guir.lib.gesture.apps.gdt.GestureObjectPanel;
import edu.berkeley.guir.lib.gesture.apps.gdt.GestureSetPanel;
import edu.berkeley.guir.lib.gesture.apps.gdt.SimpleGestureObjectPanel;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DisplayFactory {
    private DisplayFactory() {
    }

    public static JComponent create(GestureObject gestureObject) {
        return DisplayFactory.create(gestureObject, null);
    }

    public static JComponent create(GestureObject gestureObject, JScrollPane scrollPane) {
        JPanel result = gestureObject instanceof Gesture ? new GestureObjectPanel(gestureObject) : (gestureObject instanceof GestureSet ? new GestureSetPanel((GestureSet)gestureObject, scrollPane) : (gestureObject instanceof GestureGroup ? new GestureGroupPanel((GestureGroup)gestureObject, scrollPane) : (gestureObject instanceof GestureCategory ? new GestureCategoryPanel((GestureCategory)gestureObject, scrollPane) : new GestureContainerPanel((GestureContainer)gestureObject, scrollPane))));
        DisplayFactory.initDisplay(result);
        return result;
    }

    public static JComponent createThumbnail(GestureObject gestureObject, JScrollPane scrollPane) {
        JPanel result = gestureObject instanceof Gesture ? new SimpleGestureObjectPanel(gestureObject) : (gestureObject instanceof GestureCategory ? new GestureCategoryThumbnailPanel((GestureCategory)gestureObject, scrollPane) : (gestureObject instanceof GestureGroup ? new GestureGroupThumbnailPanel((GestureGroup)gestureObject, scrollPane) : new GestureContainerPanel((GestureContainer)gestureObject, scrollPane)));
        DisplayFactory.initThumbnailDisplay(result);
        return result;
    }

    protected static void initDisplay(GestureObjectDisplay display) {
        GestureObject gestureObj = display.getDisplayedObject();
        ((JComponent)((Object)display)).setBackground(gestureObj.isEnabled() ? GestureObjectDisplay.ENABLED_BACKGROUND : GestureObjectDisplay.DISABLED_BACKGROUND);
    }

    protected static void initThumbnailDisplay(GestureObjectDisplay display) {
        DisplayFactory.initDisplay(display);
        JComponent jc = (JComponent)((Object)display);
        if (jc.getBorder() == null) {
            jc.setBorder(BorderFactory.createEtchedBorder());
        }
    }
}

