/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.apps.gdt;

import edu.berkeley.guir.lib.gesture.apps.gdt.HowToManager;
import edu.berkeley.guir.lib.gesture.apps.gdt.HowToPanel;
import edu.berkeley.guir.lib.gesture.apps.gdt.MainFrame;
import edu.berkeley.guir.lib.gesture.apps.gdt.Notice;
import edu.berkeley.guir.lib.gesture.apps.gdt.ReferenceManager;
import edu.berkeley.guir.lib.gesture.apps.gdt.SummaryLog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JInternalFrame;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public abstract class DefaultNotice
implements Notice {
    protected long lastDisplayTime;
    protected Position position = null;
    protected ActionListener howToListener;
    protected ActionListener referenceListener;
    protected ActionListener moreInfoListener;
    protected static MutableAttributeSet NAME_STYLE = new SimpleAttributeSet();
    private static final List EMPTY_LIST;

    static {
        StyleConstants.setBold(NAME_STYLE, true);
        EMPTY_LIST = new ArrayList();
    }

    public long getLastDisplayTime() {
        return this.lastDisplayTime;
    }

    public void setLastDisplayTime(long time) {
        this.lastDisplayTime = time;
    }

    public boolean hasExpired() {
        return false;
    }

    protected void makeListeners(MainFrame mf) {
        if (this.referenceListener == null) {
            this.referenceListener = new ReferenceListener(mf);
        }
        if (this.howToListener == null) {
            this.howToListener = new HowToListener(mf);
        }
    }

    public void display(SummaryLog log) {
        this.makeListeners(log.getMainFrame());
        this.displayImpl(log);
        if (this.getHowToPanel() != null) {
            log.append(" ");
            log.appendLink("How do I do this?", this.howToListener);
        }
        if (this.getReferenceTag() != null) {
            log.append(" ");
            log.appendLink("Reference manual", this.referenceListener, "See related information in the reference manual");
        }
        log.append("\n");
    }

    public void displaySummary(SummaryLog log) {
        MainFrame mf = log.getMainFrame();
        this.makeListeners(mf);
        log.appendStartIcon();
        log.append(String.valueOf(this.getName()) + ": ", NAME_STYLE);
        this.displaySummaryImpl(log);
        log.append(" ");
        if (this.moreInfoListener == null) {
            this.moreInfoListener = new MoreInfoListener(mf);
        }
        log.appendLink("[ More info ]", this.moreInfoListener);
        log.append("\n");
        this.setLastDisplayTime(System.currentTimeMillis());
    }

    protected abstract void displayImpl(SummaryLog var1);

    protected abstract void displaySummaryImpl(SummaryLog var1);

    public List getObjectList() {
        return EMPTY_LIST;
    }

    public abstract String getName();

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position p) {
        this.position = p;
    }

    public HowToPanel getHowToPanel() {
        return null;
    }

    public String getReferenceTag() {
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return obj.getClass() == this.getClass() && ((Notice)obj).getObjectList().equals(this.getObjectList());
    }

    protected class HowToListener
    implements ActionListener {
        MainFrame mainFrame;

        public HowToListener(MainFrame mf) {
            this.mainFrame = mf;
        }

        public void actionPerformed(ActionEvent e) {
            HowToManager.getManager().showHowTo(this.mainFrame, DefaultNotice.this);
        }
    }

    protected class ReferenceListener
    implements ActionListener {
        MainFrame mainFrame;

        public ReferenceListener(MainFrame mf) {
            this.mainFrame = mf;
        }

        public void actionPerformed(ActionEvent e) {
            ReferenceManager.getManager().showReference(this.mainFrame, DefaultNotice.this);
        }
    }

    protected class MoreInfoListener
    implements ActionListener {
        MainFrame mainFrame;
        JInternalFrame infoFrame = null;

        public MoreInfoListener(MainFrame mf) {
            this.mainFrame = mf;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.infoFrame == null) {
                this.infoFrame = new JInternalFrame(DefaultNotice.this.getName());
                Container contents = this.infoFrame.getContentPane();
                contents.setLayout(new BorderLayout());
                SummaryLog log = new SummaryLog(this.mainFrame);
                DefaultNotice.this.display(log);
                contents.add((Component)log, "Center");
            }
            this.mainFrame.getDesktop().showFrame(this.infoFrame);
        }
    }
}

