/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.apps.gdt;

import edu.berkeley.guir.lib.gesture.GesturePackage;
import edu.berkeley.guir.lib.gesture.apps.gdt.GestureTree;
import edu.berkeley.guir.lib.gesture.apps.gdt.GestureTreeModel;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class CompositeGestureTree
extends JPanel {
    protected GestureTreeModel model;
    protected GestureTree trainingTree;
    protected GestureTree testTree;
    protected GestureTreeModel trainingTreeModel;
    protected GestureTreeModel testTreeModel;
    protected JComponent selectedWidget;
    protected JScrollPane trainingScroller;
    protected JScrollPane testScroller;

    public CompositeGestureTree() {
        super(new BorderLayout());
        this.buildUI();
    }

    protected void buildUI() {
        this.trainingTree = new GestureTree();
        this.testTree = new GestureTree();
        this.trainingScroller = new JScrollPane(this.trainingTree);
        this.testScroller = new JScrollPane(this.testTree);
        JSplitPane splitter = new JSplitPane(0, true, this.trainingScroller, this.testScroller);
        splitter.setResizeWeight(0.75);
        this.add((Component)splitter, "Center");
    }

    public void setModel(TreeModel model) {
        if (model != null && !(model instanceof GestureTreeModel)) {
            throw new IllegalArgumentException("Only GestureTreeModel is allowed, not " + model.getClass().getName() + " (" + model + ")");
        }
        this.model = (GestureTreeModel)model;
        this.updateTrees();
    }

    protected void updateTrees() {
        GesturePackage p = this.model.getGesturePackage();
        this.trainingTree.setModel(new TrainingTreeModel(p));
        this.testTree.setModel(new TestTreeModel(p));
    }

    public TreeNode getTestRootNode() {
        return this.testTreeModel.getTestRootNode();
    }

    public TreeNode getTrainingRootNode() {
        return this.trainingTreeModel.getTrainingRootNode();
    }

    public GestureTree getTrainingTree() {
        return this.trainingTree;
    }

    public GestureTree getTestTree() {
        return this.testTree;
    }

    protected class TrainingTreeModel
    extends GestureTreeModel {
        public TrainingTreeModel(GesturePackage gPackage) {
            super(gPackage);
        }

        protected GestureTreeModel.GestureTreeNode buildTree(GesturePackage gesturePackage) {
            this.trainingRootNode = this.buildTree(gesturePackage.getTrainingSet());
            return this.trainingRootNode;
        }
    }

    protected class TestTreeModel
    extends GestureTreeModel {
        public TestTreeModel(GesturePackage gPackage) {
            super(gPackage);
        }

        protected GestureTreeModel.GestureTreeNode buildTree(GesturePackage gesturePackage) {
            this.testRootNode = this.buildTree(gesturePackage.getTestSets());
            return this.testRootNode;
        }
    }
}

