/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.apps.gdt;

import edu.berkeley.guir.lib.gesture.Classifier;
import edu.berkeley.guir.lib.gesture.FeatureFactory;
import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.GestureCategory;
import edu.berkeley.guir.lib.gesture.GestureContainer;
import edu.berkeley.guir.lib.gesture.GestureObject;
import edu.berkeley.guir.lib.gesture.GesturePackage;
import edu.berkeley.guir.lib.gesture.GestureSet;
import edu.berkeley.guir.lib.gesture.HumanCoords;
import edu.berkeley.guir.lib.gesture.HumanSimilarity;
import edu.berkeley.guir.lib.gesture.TrainingException;
import edu.berkeley.guir.lib.gesture.apps.gdt.DuplicateNameNotice;
import edu.berkeley.guir.lib.gesture.apps.gdt.HumanSimilarityNotice;
import edu.berkeley.guir.lib.gesture.apps.gdt.MainFrame;
import edu.berkeley.guir.lib.gesture.apps.gdt.MisrecognitionNotice;
import edu.berkeley.guir.lib.gesture.apps.gdt.OutlyingGestureNotice;
import edu.berkeley.guir.lib.gesture.apps.gdt.RecognizerSimilarityTester;
import edu.berkeley.guir.lib.gesture.apps.gdt.TaskManager;
import edu.berkeley.guir.lib.gesture.util.Misc;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Analyzers {
    protected MainFrame mainFrame;
    protected boolean analyzersEnabled = true;

    public Analyzers(MainFrame mf) {
        this.mainFrame = mf;
    }

    public void addBackgroundTasks() {
        TaskManager manager = TaskManager.getTaskManager(this.mainFrame);
        manager.addTask(new NameClashTester(this.mainFrame));
        manager.addTask(new TrainingExampleTester(this.mainFrame));
        manager.addTask(new RecognizerSimilarityTester(this.mainFrame));
        manager.addTask(new HumanSimilarityTester(this.mainFrame));
        manager.addTask(new OutlyingGestureTester(this.mainFrame));
        manager.start();
    }

    public void restartTasks() {
        if (this.analyzersEnabled) {
            TaskManager manager = TaskManager.getTaskManager(this.mainFrame);
            manager.removeAllTasks();
            this.addBackgroundTasks();
        }
    }

    public void setAnalysisEnabled(boolean on) {
        if (this.analyzersEnabled != on) {
            this.analyzersEnabled = on;
            if (on) {
                System.out.println("Analyzers: starting tasks");
                this.restartTasks();
            } else {
                System.out.println("Analyzers: stopping tasks");
                TaskManager manager = TaskManager.getTaskManager(this.mainFrame);
                manager.removeAllTasks();
            }
        }
    }

    public static class NameClashTester
    implements TaskManager.NoticeTask {
        private MainFrame mainFrame;
        private Map names;

        public NameClashTester(MainFrame mf) {
            this.mainFrame = mf;
            this.names = new HashMap();
        }

        public Set computeNotices() throws InterruptedException {
            GesturePackage pkg = this.mainFrame.getGesturePackage();
            HashSet result = new HashSet();
            this.names.clear();
            this.testCollection(pkg.getTrainingSet());
            Iterator iter = pkg.getTestSets().iterator();
            while (iter.hasNext()) {
                this.names.clear();
                GestureContainer collection = (GestureContainer)iter.next();
                result.addAll(this.testCollection(collection));
            }
            return result;
        }

        public Set testCollection(GestureContainer collection) throws InterruptedException {
            HashSet<DuplicateNameNotice> result = new HashSet<DuplicateNameNotice>();
            Iterator iter = collection.iterator();
            while (iter.hasNext()) {
                GestureObject gestureObject = (GestureObject)iter.next();
                if (gestureObject instanceof GestureCategory) {
                    String name = ((GestureCategory)gestureObject).getName();
                    if (this.names.containsKey(name)) {
                        result.add(new DuplicateNameNotice((GestureCategory)gestureObject, (GestureCategory)this.names.get(name)));
                    } else {
                        this.names.put(name, gestureObject);
                    }
                } else if (gestureObject instanceof GestureContainer) {
                    result.addAll(this.testCollection((GestureContainer)gestureObject));
                }
                if (!Thread.currentThread().isInterrupted()) continue;
                throw new InterruptedException();
            }
            return result;
        }
    }

    public static class TrainingExampleTester
    implements TaskManager.NoticeTask {
        private MainFrame mainFrame;
        private List misrecogGestures = null;

        public TrainingExampleTester(MainFrame mf) {
            this.mainFrame = mf;
        }

        public Set computeNotices() throws InterruptedException {
            GestureSet trainingSet;
            HashSet<MisrecognitionNotice> result = new HashSet<MisrecognitionNotice>();
            Classifier classifier = this.mainFrame.getClassifier();
            GesturePackage pkg = this.mainFrame.getGesturePackage();
            if (classifier != null && pkg != null && (trainingSet = pkg.getTrainingSet()) != null) {
                this.misrecogGestures = null;
                try {
                    this.misrecogGestures = classifier.testRecognition(trainingSet);
                    if (this.misrecogGestures.size() > 0) {
                        result.add(new MisrecognitionNotice(this.mainFrame, this.misrecogGestures));
                    }
                }
                catch (TrainingException e) {
                    return result;
                }
            }
            return result;
        }
    }

    public static class HumanSimilarityTester
    implements TaskManager.NoticeTask {
        private final double DIST_THRESHOLD = 0.3487;
        private final double DISTANCE_SQ_THRESHOLD = 0.12159169;
        private MainFrame mainFrame;
        static /* synthetic */ Class class$0;

        public HumanSimilarityTester(MainFrame mf) {
            this.mainFrame = mf;
        }

        public Set computeNotices() throws InterruptedException {
            GestureSet trainingSet;
            HashSet<HumanSimilarityNotice> result = new HashSet<HumanSimilarityNotice>();
            GesturePackage pkg = this.mainFrame.getGesturePackage();
            if (pkg != null && (trainingSet = pkg.getTrainingSet()) != null) {
                List trainingCategories = trainingSet.getEnabledCategories();
                int numCats = trainingCategories.size();
                int i = 0;
                while (i < numCats) {
                    GestureCategory catA = (GestureCategory)trainingCategories.get(i);
                    int j = 0;
                    while (j < i) {
                        GestureCategory catB = (GestureCategory)trainingCategories.get(j);
                        HumanCoords.DistanceInfo distInfo = HumanCoords.getDistanceInfo(catA, catB);
                        Class principleFeature = null;
                        int direction = 0;
                        if (distInfo.distanceSq <= 0.12159169) {
                            principleFeature = distInfo.featureClass;
                            direction = distInfo.direction;
                        } else if (HumanSimilarity.areVerySimilar(catA, catB)) {
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("edu.berkeley.guir.lib.gesture.features.Aspect");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            principleFeature = clazz;
                            double a = FeatureFactory.getFeatureValue(principleFeature, catA);
                            double b = FeatureFactory.getFeatureValue(principleFeature, catB);
                            direction = Misc.sign(a - b);
                        }
                        if (principleFeature != null) {
                            result.add(new HumanSimilarityNotice(this.mainFrame, catA, catB, principleFeature, direction));
                        }
                        if (Thread.interrupted()) {
                            throw new InterruptedException();
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            return result;
        }
    }

    public static class OutlyingGestureTester
    implements TaskManager.NoticeTask {
        public double numSigmas = 10.0;
        private MainFrame mainFrame;

        public OutlyingGestureTester(MainFrame mf) {
            this.mainFrame = mf;
        }

        public Set computeNotices() throws InterruptedException {
            HashSet<OutlyingGestureNotice> result = new HashSet<OutlyingGestureNotice>();
            GesturePackage pkg = this.mainFrame.getGesturePackage();
            Classifier classifier = this.mainFrame.getClassifier();
            if (pkg != null && classifier != null) {
                try {
                    classifier.train();
                }
                catch (TrainingException e) {
                    return result;
                }
                GestureSet trainingSet = pkg.getTrainingSet();
                ArrayList<Gesture> outlyingExamples = new ArrayList<Gesture>();
                if (trainingSet != null) {
                    List trainingCategories = trainingSet.getEnabledCategories();
                    int numCats = trainingCategories.size();
                    int catIndex = 0;
                    while (catIndex < numCats) {
                        GestureCategory category = (GestureCategory)trainingCategories.get(catIndex);
                        int numGestures = category.size();
                        int gIndex = 0;
                        while (gIndex < numGestures) {
                            Gesture g = (Gesture)category.getChild(gIndex);
                            if (g.isEnabled()) {
                                double stdev = this.computeStdev(classifier, category, catIndex, gIndex);
                                double dist = Math.sqrt(classifier.distanceToCategory(g, catIndex));
                                if (dist > stdev * this.numSigmas) {
                                    outlyingExamples.add(g);
                                }
                            }
                            ++gIndex;
                        }
                        ++catIndex;
                    }
                }
                if (outlyingExamples.size() > 0) {
                    result.add(new OutlyingGestureNotice(this.mainFrame, outlyingExamples));
                }
            }
            return result;
        }

        protected double computeStdev(Classifier classifier, GestureCategory category, int catIndex, int gestureIndex) {
            int numGestures = category.size();
            double sum = 0.0;
            double sumsq = 0.0;
            int i = 0;
            while (i < numGestures) {
                Gesture g;
                if (i != gestureIndex && (g = (Gesture)category.getChild(i)).isEnabled()) {
                    double distSq = classifier.distanceToCategory(g, catIndex);
                    sum += Math.sqrt(distSq);
                    sumsq += distSq;
                }
                ++i;
            }
            int n = numGestures - 1;
            double stdev = Math.sqrt(((double)n * sumsq - sum * sum) / (double)(n * (n - 1)));
            return stdev;
        }
    }
}

