/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.apps;

import edu.berkeley.guir.lib.gesture.Feature;
import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.GestureCategory;
import edu.berkeley.guir.lib.gesture.GestureSet;
import edu.berkeley.guir.lib.gesture.GestureSetFrame;
import edu.berkeley.guir.lib.gesture.TimedPolygon;
import edu.berkeley.guir.lib.gesture.util.Misc;
import java.io.File;
import java.io.PrintStream;
import java.util.Iterator;

public class gav {
    public final int SIGFIGS = 10;

    public static void main(String[] argv) {
        if (argv.length != 1) {
            System.err.println("gav: usage: java gav gesturesetfile");
            System.exit(-1);
        }
        GestureSetFrame frame = new GestureSetFrame("gav", false);
        frame.openFile(new File(argv[0]));
        GestureSet gs = frame.getGestureSetDisplay().getGestureSet();
        gav dummy = new gav();
        dummy.printVariances(System.out, gs);
        System.exit(0);
    }

    void printVariances(PrintStream out, GestureSet gs) {
        Iterator it = gs.getCategories().iterator();
        while (it.hasNext()) {
            GestureCategory gc = (GestureCategory)it.next();
            Gesture g = gc.gestureAt(0);
            angleVariance av = new angleVariance(g);
            out.println(String.valueOf(gc.getName()) + "\t" + Misc.toString(av.getValue(), 10));
        }
    }

    class angleVariance
    extends Feature {
        public final double minValue = 0.0;
        public final double maxValue = Double.POSITIVE_INFINITY;

        public angleVariance(Gesture g) {
            super(g);
            this.minValue = 0.0;
            this.maxValue = Double.POSITIVE_INFINITY;
        }

        public String getName() {
            return "angle variance";
        }

        public double getMinValue() {
            return 0.0;
        }

        public double getMaxValue() {
            return Double.POSITIVE_INFINITY;
        }

        protected void computeValue() {
            double totalAngle = 0.0;
            TimedPolygon points = this.gesture.getPoints();
            double[] angles2 = new double[points.npoints];
            int i = 2;
            while (i < points.npoints) {
                double dx = points.xpoints[i] - points.xpoints[i - 1];
                double dy = points.ypoints[i] - points.ypoints[i - 1];
                double dx2 = points.xpoints[i - 1] - points.xpoints[i - 2];
                double dy2 = points.ypoints[i - 1] - points.ypoints[i - 2];
                angles2[i] = Math.atan2(dx * dy2 - dx2 * dy, dx * dx2 + dy * dy2);
                totalAngle += angles2[i];
                ++i;
            }
            double meanAngle = totalAngle / (double)points.npoints;
            double ssqr = 0.0;
            int i2 = 2;
            while (i2 < points.npoints) {
                double delta = angles2[i2] - meanAngle;
                ssqr += delta * delta;
                ++i2;
            }
            this.value = ssqr /= (double)(points.npoints - 2);
            this.valueOk = true;
        }

        public void scale(double factor) {
        }
    }
}

