/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.apps;

import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.GestureCategory;
import edu.berkeley.guir.lib.gesture.GestureSet;
import edu.berkeley.guir.lib.gesture.GestureSetFrame;
import edu.berkeley.guir.lib.gesture.TimedPolygon;
import edu.berkeley.guir.lib.gesture.util.Misc;
import java.io.File;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;

public class coords {
    public final int SIGFIGS = 10;

    void printdx(PrintStream out, Gesture gesture) {
        TimedPolygon points = gesture.getPoints();
        out.print("\t" + (points.npoints - 1));
        int i = 2;
        while (i < points.npoints) {
            double dx = points.xpoints[i] - points.xpoints[i - 1];
            out.print("\t" + Misc.toString(dx, 10));
            ++i;
        }
    }

    void printdy(PrintStream out, Gesture gesture) {
        TimedPolygon points = gesture.getPoints();
        out.print("\t" + (points.npoints - 1));
        int i = 2;
        while (i < points.npoints) {
            double dy = points.ypoints[i] - points.ypoints[i - 1];
            out.print("\t" + Misc.toString(dy, 10));
            ++i;
        }
    }

    void printdt(PrintStream out, Gesture gesture) {
        TimedPolygon points = gesture.getPoints();
        out.print("\t" + (points.npoints - 1));
        int i = 2;
        while (i < points.npoints) {
            double dt = points.times[i] - points.times[i - 1];
            out.print("\t" + Misc.toString(dt, 10));
            ++i;
        }
    }

    public static void main(String[] argv) {
        if (argv.length != 1) {
            System.err.println("gav: usage: java coords gesturesetfile");
            System.exit(-1);
        }
        GestureSetFrame frame = new GestureSetFrame("coords", false);
        frame.openFile(new File(argv[0]));
        GestureSet gs = frame.getGestureSetDisplay().getGestureSet();
        coords dummy = new coords();
        dummy.printGSDeltas(System.out, gs);
        System.exit(0);
    }

    void printGSDeltas(PrintStream out, GestureSet gs) {
        Gesture g;
        GestureCategory gc;
        List categories = gs.getCategories();
        Iterator it = categories.iterator();
        while (it.hasNext()) {
            gc = (GestureCategory)it.next();
            g = gc.gestureAt(0);
            out.print(gc.getName());
            this.printdx(out, g);
            out.println();
        }
        it = categories.iterator();
        while (it.hasNext()) {
            gc = (GestureCategory)it.next();
            g = gc.gestureAt(0);
            out.print(gc.getName());
            this.printdy(out, g);
            out.println();
        }
        it = categories.iterator();
        while (it.hasNext()) {
            gc = (GestureCategory)it.next();
            g = gc.gestureAt(0);
            out.print(gc.getName());
            this.printdt(out, g);
            out.println();
        }
    }
}

