/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture.apps;

import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.GestureCategory;
import edu.berkeley.guir.lib.gesture.GestureSet;
import edu.berkeley.guir.lib.gesture.GestureSetFrame;
import edu.berkeley.guir.lib.gesture.TimedPolygon;
import edu.berkeley.guir.lib.gesture.util.Misc;
import java.io.File;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;

public class angles {
    public final int SIGFIGS = 10;

    void printGestureAngles(PrintStream out, Gesture gesture) {
        TimedPolygon points = gesture.getPoints();
        int i = 2;
        while (i < points.npoints) {
            double dx = points.xpoints[i] - points.xpoints[i - 1];
            double dy = points.ypoints[i] - points.ypoints[i - 1];
            double dx2 = points.xpoints[i - 1] - points.xpoints[i - 2];
            double dy2 = points.ypoints[i - 1] - points.ypoints[i - 2];
            double angle = Math.atan2(dx * dy2 - dx2 * dy, dx * dx2 + dy * dy2);
            out.print("\t" + Misc.toString(angle, 10));
            ++i;
        }
    }

    public static void main(String[] argv) {
        if (argv.length != 1) {
            System.err.println("gav: usage: java gav gesturesetfile");
            System.exit(-1);
        }
        GestureSetFrame frame = new GestureSetFrame("gav", false);
        frame.openFile(new File(argv[0]));
        GestureSet gs = frame.getGestureSetDisplay().getGestureSet();
        angles dummy = new angles();
        dummy.printGSAngles(System.out, gs);
        System.exit(0);
    }

    void printGSAngles(PrintStream out, GestureSet gs) {
        List categories = gs.getCategories();
        Iterator it = categories.iterator();
        while (it.hasNext()) {
            GestureCategory gc = (GestureCategory)it.next();
            Gesture g = gc.gestureAt(0);
            out.print(gc.getName());
            this.printGestureAngles(out, g);
            out.println();
        }
    }
}

