/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture;

import edu.berkeley.guir.lib.gesture.Classifier;
import edu.berkeley.guir.lib.gesture.FeatureVector;
import edu.berkeley.guir.lib.gesture.GestureContainer;
import edu.berkeley.guir.lib.gesture.util.Misc;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class WeightTable
extends JFrame {
    Classifier classifier;
    JTable table;
    Double[][] weights;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    WeightTable(Classifier c) {
        super("Weight Table");
        this.classifier = c;
        this.updateWeights();
        this.buildUI();
    }

    private void updateWeights() {
        this.weights = Misc.promoteMatrix(this.classifier.weights);
    }

    private void buildUI() {
        Container contents = this.getContentPane();
        contents.setLayout(new BorderLayout());
        AbstractTableModel dataModel = new AbstractTableModel(){
            FeatureVector dummyFV = new FeatureVector();

            public int getColumnCount() {
                return WeightTable.this.weights.length + 1;
            }

            public int getRowCount() {
                return WeightTable.this.weights[0].length - 1;
            }

            public Object getValueAt(int r, int c) {
                if (c == 0) {
                    return this.getRowName(r);
                }
                return WeightTable.this.weights[c - 1][r + 1];
            }

            public Class getColumnClass(int c) {
                Class<?> clazz;
                block5: {
                    block6: {
                        if (c != 0) break block6;
                        clazz = class$0;
                        if (clazz != null) break block5;
                        try {
                            clazz = class$0 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        break block5;
                    }
                    clazz = class$1;
                    if (clazz == null) {
                        try {
                            class$1 = Class.forName("java.lang.Double");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        clazz = class$1;
                    }
                }
                return clazz;
            }

            public String getColumnName(int c) {
                if (c == 0) {
                    return "Class";
                }
                return ((GestureContainer)WeightTable.this.classifier.getGestureSet().getChild(c - 1)).getName();
            }

            public String getRowName(int r) {
                return this.dummyFV.getFeature(r).getName();
            }
        };
        this.table = new JTable(dataModel);
        new ColorRenderer(this.table);
        this.table.setRowSelectionAllowed(false);
        this.table.setColumnSelectionAllowed(false);
        this.table.setAutoResizeMode(0);
        TableColumnModel tcm = this.table.getColumnModel();
        int i = 1;
        while (i < dataModel.getColumnCount()) {
            TableColumn column = tcm.getColumn(i);
            column.setWidth(column.getWidth() / 2);
            ++i;
        }
        JScrollPane scrollPane = new JScrollPane(this.table);
        contents.add((Component)scrollPane, "Center");
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("Table");
        JMenuItem item = new JMenuItem("Close");
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WeightTable.this.dispose();
            }
        };
        item.addActionListener(listener);
        menu.add(item);
        menuBar.add(menu);
        this.getRootPane().setJMenuBar(menuBar);
    }

    class ColorRenderer
    implements TableCellRenderer {
        TableCellRenderer oldRenderer;
        static /* synthetic */ Class class$0;

        ColorRenderer(JTable table) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Double");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.oldRenderer = table.getDefaultRenderer(clazz);
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.lang.Double");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            table.setDefaultRenderer(clazz2, this);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                Component defaultComponent = this.oldRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                defaultComponent.setBackground(Color.white);
                return defaultComponent;
            }
            double x = (Double)value;
            value = Misc.toString(x, 2);
            Component defaultComponent = this.oldRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (column == 0) {
                defaultComponent.setBackground(Color.lightGray);
            } else {
                defaultComponent.setBackground(Color.white);
            }
            return defaultComponent;
        }
    }
}

