/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture;

import edu.berkeley.guir.lib.gesture.util.CTable;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

class ToolTipUpdater
extends MouseMotionAdapter {
    CTable table;

    ToolTipUpdater(CTable table) {
        this.table = table;
    }

    public void mouseMoved(MouseEvent e) {
        String toolTip;
        Point position = new Point(e.getX(), e.getY());
        int row = this.table.rowAtPoint(position);
        int col = this.table.columnAtPoint(position);
        if (row == -1 || col == -1) {
            toolTip = null;
        } else {
            String rowName = this.table.getRowName(row);
            String colName = this.table.getColumnName(col);
            toolTip = String.valueOf(rowName) + " x " + colName;
        }
        this.table.setToolTipText(toolTip);
    }
}

