/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture;

import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.Serializable;

public class TimedPolygon
extends Polygon
implements Serializable,
Cloneable {
    public long[] times;

    public TimedPolygon() {
        this.times = new long[4];
    }

    public TimedPolygon(int[] x, int[] y, int numPoints) {
        this(x, y, System.currentTimeMillis(), numPoints);
    }

    public TimedPolygon(int[] x, int[] y, long time, int numPoints) {
        super(x, y, numPoints);
        this.times = new long[numPoints];
        int i = 0;
        while (i < numPoints) {
            this.times[i] = time;
            ++i;
        }
    }

    public TimedPolygon(int[] x, int[] y, long[] t, int numPoints) {
        super(x, y, numPoints);
        this.times = new long[t.length];
        System.arraycopy(t, 0, this.times, 0, this.npoints);
    }

    public TimedPolygon(Polygon p) {
        this(p.xpoints, p.ypoints, p.npoints);
    }

    public TimedPolygon(TimedPolygon p) {
        this(p.xpoints, p.ypoints, p.times, p.npoints);
    }

    public void addPoint(int x, int y) {
        this.addPoint(x, y, System.currentTimeMillis());
    }

    public void addPoint(int x, int y, long t) {
        super.addPoint(x, y);
        if (this.npoints == this.times.length) {
            long[] temp = new long[this.times.length * 2];
            System.arraycopy(this.times, 0, temp, 0, this.times.length);
            this.times = temp;
        }
        this.times[this.npoints - 1] = t;
    }

    public Object clone() {
        try {
            TimedPolygon result = (TimedPolygon)super.clone();
            result.xpoints = (int[])this.xpoints.clone();
            result.ypoints = (int[])this.ypoints.clone();
            result.times = (long[])this.times.clone();
            if (this.bounds != null) {
                result.bounds = (Rectangle)this.bounds.clone();
            }
            return result;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

