/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture;

import edu.berkeley.guir.lib.gesture.FeaturePicker;
import edu.berkeley.guir.lib.gesture.FeatureVector;
import edu.berkeley.guir.lib.gesture.StarPlot;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class StarPlotFrame
extends JFrame {
    StarPlot plot;
    FeaturePicker featurePicker = null;

    public StarPlotFrame(FeatureVector fv, String name) {
        super(name);
        this.buildUI(fv);
    }

    void buildUI(FeatureVector fv) {
        Container contents = this.getContentPane();
        contents.setLayout(new BorderLayout());
        this.plot = new StarPlot(fv);
        contents.add((Component)this.plot, "Center");
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("Plot");
        JMenuItem item = new JMenuItem("Filter features");
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (StarPlotFrame.this.featurePicker == null) {
                    StarPlotFrame.this.featurePicker = new FeaturePicker("Star plot features");
                    StarPlotFrame.this.featurePicker.pack();
                    StarPlotFrame.this.plot.setFeaturePicker(StarPlotFrame.this.featurePicker);
                }
                StarPlotFrame.this.featurePicker.show();
            }
        };
        item.addActionListener(listener);
        menu.add(item);
        item = new JMenuItem("Close");
        listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StarPlotFrame.this.dispose();
            }
        };
        item.addActionListener(listener);
        menu.add(item);
        menuBar.add(menu);
        menu = new JMenu("View");
        item = new JMenuItem("Toggle log scale");
        listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StarPlotFrame.this.plot.setLogScale(!StarPlotFrame.this.plot.getLogScale());
            }
        };
        item.addActionListener(listener);
        menu.add(item);
        item = new JMenuItem("Zoom in");
        listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StarPlotFrame.this.plot.setScale(StarPlotFrame.this.plot.getScale() * 2.0);
            }
        };
        item.addActionListener(listener);
        menu.add(item);
        item = new JMenuItem("Zoom out");
        listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StarPlotFrame.this.plot.setScale(StarPlotFrame.this.plot.getScale() / 2.0);
            }
        };
        item.addActionListener(listener);
        menu.add(item);
        menuBar.add(menu);
        this.getRootPane().setJMenuBar(menuBar);
    }
}

