/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture;

import edu.berkeley.guir.lib.gesture.FeaturePicker;
import edu.berkeley.guir.lib.gesture.FeatureVector;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class StarPlot
extends JPanel
implements Observer {
    FeatureVector featureVector = null;
    boolean logScale = false;
    double scale = 1.0;
    FeaturePicker featurePicker = null;
    public Color negativeColor = Color.blue;
    double[] values = null;
    double[] featureScales = null;
    double[] weights = null;

    public StarPlot(FeatureVector myFeatureVector) {
        this.featureVector = myFeatureVector;
        this.featureVector.addObserver(this);
        this.buildUI();
    }

    public StarPlot(double[] valueVector) {
        this.values = valueVector;
        this.buildUI();
    }

    private void buildUI() {
        this.setPreferredSize(new Dimension(200, 200));
        this.setDoubleBuffered(true);
        this.setBackground(Color.white);
        this.addKeyListener(new KeyBindings());
        this.addMouseListener(new SimpleFocus());
    }

    public void setFeaturePicker(FeaturePicker fp) {
        this.featurePicker = fp;
        this.featurePicker.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                StarPlot.this.repaint();
            }
        });
        this.repaint();
    }

    public void setFeatureScales(double[] scales) {
        this.featureScales = scales;
        this.repaint();
    }

    public void setWeights(double[] w) {
        this.weights = w;
        this.repaint();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void paintComponent(Graphics graphics) {
        Graphics g = graphics.create();
        try {
            int numSelected;
            Insets insets = this.getInsets();
            if (this.featureVector != null) {
                this.values = this.featureVector.getValues();
            }
            super.paintComponent(g.create());
            g.translate(this.getWidth() / 2 + insets.left, this.getHeight() / 2 + insets.top);
            int numFeatures = this.values.length;
            int n = numSelected = this.featurePicker == null ? numFeatures : this.featurePicker.getNumSelected();
            if (numSelected > 0) {
                double deltaTheta = Math.PI * 2 / (double)numSelected;
                double theta = 0.0;
                int lastx = 0;
                int lasty = 0;
                int firstx = 0;
                int firsty = 0;
                boolean first = true;
                int i = 0;
                while (i < numFeatures) {
                    if (this.featurePicker == null || this.featurePicker.isFeatureSelected(i)) {
                        Graphics tempGraphics = g.create();
                        double featureValue = this.values[i];
                        if (this.featureScales != null) {
                            featureValue *= this.featureScales[i];
                        }
                        if (this.weights != null) {
                            featureValue *= this.weights[i + 1];
                        }
                        if (featureValue < 0.0) {
                            tempGraphics.setColor(this.negativeColor);
                            featureValue = -featureValue;
                        }
                        if (this.logScale && (featureValue = Math.log(featureValue)) < 0.0) {
                            featureValue = 0.0;
                        }
                        int x = (int)Math.round(Math.sin(theta) * (featureValue *= this.scale));
                        int y = (int)(-Math.round(Math.cos(theta) * featureValue));
                        tempGraphics.drawLine(0, 0, x, y);
                        tempGraphics.drawString(Integer.toString(i), x, y);
                        if (first) {
                            firstx = x;
                            firsty = y;
                            first = false;
                        } else {
                            g.drawLine(lastx, lasty, x, y);
                        }
                        lastx = x;
                        lasty = y;
                        theta += deltaTheta;
                    }
                    ++i;
                }
                g.drawLine(lastx, lasty, firstx, firsty);
            }
            Object var21_20 = null;
            g.dispose();
            return;
        }
        catch (Throwable throwable) {
            Object var21_19 = null;
            g.dispose();
            throw throwable;
        }
    }

    public void setLogScale(boolean on) {
        if (on != this.logScale) {
            this.logScale = on;
            this.repaint();
        }
    }

    public boolean getLogScale() {
        return this.logScale;
    }

    public void setScale(double newScale) {
        if (newScale != this.scale) {
            this.scale = newScale;
            this.repaint();
        }
    }

    public double getScale() {
        return this.scale;
    }

    public void update(Observable o, Object arg) {
        if (o instanceof FeatureVector) {
            this.repaint();
        }
    }

    public void setTitle(String title) {
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title, 2, 2));
        this.repaint();
    }

    class KeyBindings
    extends KeyAdapter {
        KeyBindings() {
        }

        public void keyTyped(KeyEvent e) {
            switch (e.getKeyChar()) {
                case '+': {
                    StarPlot.this.setScale(StarPlot.this.getScale() * 2.0);
                    break;
                }
                case '-': {
                    StarPlot.this.setScale(StarPlot.this.getScale() / 2.0);
                    break;
                }
                case 'l': {
                    StarPlot.this.setLogScale(!StarPlot.this.getLogScale());
                    break;
                }
            }
        }
    }

    class SimpleFocus
    extends MouseAdapter {
        SimpleFocus() {
        }

        public void mouseEntered(MouseEvent e) {
            StarPlot.this.requestFocus();
        }
    }
}

