/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture;

import edu.berkeley.guir.lib.gesture.GestureObject;
import edu.berkeley.guir.lib.gesture.util.Misc;
import edu.berkeley.guir.lib.gesture.util.TokenReader;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Properties {
    public static final String END_STRING = "endproperties";
    private static Set transientProperties = new HashSet();

    private Properties() {
    }

    public static PropertyChangeEvent getRootEvent(PropertyChangeEvent e) {
        while (e.getPropertyName() == "child changed") {
            e = (PropertyChangeEvent)e.getNewValue();
        }
        return e;
    }

    public static void setPropertyPersistence(String name, boolean persistent) {
        if (persistent) {
            transientProperties.remove(name);
        } else {
            transientProperties.add(name);
        }
    }

    public static boolean isPropertyPersistent(String name) {
        return !transientProperties.contains(name);
    }

    public static boolean hasNonEmptyCollection(GestureObject gestureObj, String propName) {
        Object value;
        boolean result = gestureObj.hasProperty(propName) && (value = gestureObj.getProperty(propName)) != null && value instanceof Collection && ((Collection)value).size() > 0;
        return result;
    }

    public static Map deepCopy(Map properties) {
        return Misc.deepCopy(properties, new Misc.MapAcceptor(){

            public boolean accept(Object key, Object value) {
                return Properties.isPropertyPersistent((String)key);
            }
        });
    }

    public static void writeProperties(Writer writer, Map properties) throws IOException {
        Iterator iter = properties.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!Properties.isPropertyPersistent((String)entry.getKey())) continue;
            Properties.writeProperty(writer, entry);
        }
        writer.write(END_STRING);
        writer.write(10);
    }

    public static void writeProperty(Writer writer, Map.Entry entry) throws IOException {
        writer.write(Misc.escapeString((String)entry.getKey()));
        writer.write(9);
        Object value = entry.getValue();
        writer.write(Misc.escapeString(value.toString()));
        writer.write(10);
    }

    public static Map readProperties(TokenReader reader) throws ParseException, IOException {
        HashMap result = new HashMap();
        boolean done = false;
        while (!done) {
            String nextToken = reader.readToken();
            if (nextToken.equals(END_STRING)) {
                done = true;
                continue;
            }
            reader.unreadString(nextToken);
            Properties.readProperty(reader, result);
        }
        return result;
    }

    public static void readProperty(Reader r, Map map) throws ParseException, IOException {
        String name = Misc.readEscapedString(r, true);
        String value = Misc.readEscapedString(r, true);
        map.put(name, value);
    }
}

