/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture;

import edu.berkeley.guir.lib.gesture.adapter;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintStream;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class PlotColumn
extends JPanel {
    static final int dotRadius = 5;
    static final int columnWidth = 20;
    double minValue;
    double maxValue;
    double[] data;
    int dataSize = 0;
    int[] y;
    int[] histogram;

    PlotColumn() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                PlotColumn.this.computeHistogram();
                PlotColumn.this.repaint();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                System.err.println("PlotColumn hit");
                PlotColumn.this.dumpData(System.err);
            }
        });
        this.data = new double[1];
        this.y = new int[1];
        this.histogram = new int[1];
    }

    public PlotColumn(double[] data, double minValue, double maxValue) {
        this();
        this.setData(data, minValue, maxValue);
    }

    private void actuallySetData(double[] d) {
        if (this.data.length < d.length) {
            this.data = new double[d.length];
        }
        this.dataSize = d.length;
        System.arraycopy(d, 0, this.data, 0, d.length);
    }

    public void setData(double[] d) {
        this.actuallySetData(d);
        this.computeHistogram();
        this.repaint();
    }

    public void setData(double[] d, double min, double max) {
        this.actuallySetData(d);
        this.minValue = min;
        this.maxValue = max;
        this.computeHistogram();
        this.repaint();
    }

    public void setRange(double min, double max) {
        if (this.minValue != min || this.maxValue != max) {
            this.minValue = min;
            this.maxValue = max;
            this.computeHistogram();
            this.repaint();
        }
    }

    private void computeHistogram() {
        int i;
        int miny;
        int height = this.getSize().height;
        double scale = (double)height / (this.maxValue - this.minValue);
        int maxy = (int)Math.ceil(this.maxValue * scale);
        int length = maxy - (miny = (int)Math.floor(this.minValue * scale)) + 1;
        if (this.histogram.length < length) {
            this.histogram = new int[length];
        } else {
            i = 0;
            while (i < length) {
                this.histogram[i] = 0;
                ++i;
            }
        }
        if (this.y.length < this.dataSize) {
            this.y = new int[this.dataSize];
        }
        i = 0;
        while (i < this.dataSize) {
            this.y[i] = (int)Math.round((this.data[i] - this.minValue) * scale);
            int n = this.y[i];
            this.histogram[n] = this.histogram[n] + 1;
            ++i;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics g = graphics.create();
        try {
            int height = this.getSize().height;
            g.translate(10, 0);
            g.setColor(this.getForeground());
            int i = 0;
            while (i < this.dataSize) {
                int radius = 10 + this.histogram[this.y[i]] - 1;
                g.drawOval(-5, height - this.y[i], radius, radius);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            g.dispose();
            throw throwable;
        }
        {
            Object var6_8 = null;
            g.dispose();
            return;
        }
    }

    public Dimension getPreferredSize() {
        int height = super.getPreferredSize().height;
        return new Dimension(20, height);
    }

    void dumpData(PrintStream out) {
        out.print("data = {");
        int i = 0;
        while (i < this.dataSize) {
            out.print(this.data[i]);
            if (i < this.dataSize - 1) {
                out.print(", ");
            }
            ++i;
        }
        out.println("}");
    }

    public static void main(String[] args) {
        double[] foo = new double[]{0.0, 1.0, 2.0, 3.0, 5.0, 10.0};
        JFrame f = new JFrame("PlotColumn test");
        f.addMouseListener(new adapter());
        WindowAdapter l = new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        };
        f.addWindowListener(l);
        f.pack();
        f.setSize(new Dimension(200, 200));
        f.show();
    }
}

