/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture;

import edu.berkeley.guir.lib.gesture.FeatureFactory;
import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.GestureCategory;
import edu.berkeley.guir.lib.gesture.util.Misc;

public class HumanCoords {
    private static final Class[] PRINCIPLE_COMPONENTS;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;

    static {
        Class[] classArray = new Class[5];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.gesture.features.Curviness2");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("edu.berkeley.guir.lib.gesture.features.TotalAbsAngle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("edu.berkeley.guir.lib.gesture.features.Density1");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz3;
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("edu.berkeley.guir.lib.gesture.features.EndsAngleCosine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[3] = clazz4;
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("edu.berkeley.guir.lib.gesture.features.Aspect");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[4] = clazz5;
        PRINCIPLE_COMPONENTS = classArray;
    }

    private HumanCoords() {
    }

    public static double[] computeCoords(Gesture gesture) {
        double[] coords2 = new double[5];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.gesture.features.Curviness2");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        double curviness2 = HumanCoords.gestureValue(clazz, gesture);
        Class<?> clazz2 = class$5;
        if (clazz2 == null) {
            try {
                clazz2 = class$5 = Class.forName("edu.berkeley.guir.lib.gesture.features.AnglePerDistance");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        double anglePerDist = HumanCoords.gestureValue(clazz2, gesture);
        coords2[0] = -0.29285916 * curviness2 - 44.16376392873 * anglePerDist + 2.08250756;
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("edu.berkeley.guir.lib.gesture.features.TotalAbsAngle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        double totalAbsAngle = HumanCoords.gestureValue(clazz3, gesture);
        Class<?> clazz4 = class$6;
        if (clazz4 == null) {
            try {
                clazz4 = class$6 = Class.forName("edu.berkeley.guir.lib.gesture.features.LogAspect");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        double logAspect = HumanCoords.gestureValue(clazz4, gesture);
        coords2[1] = -0.204093790874 * totalAbsAngle - 0.342099976898 * logAspect + 1.372313843226;
        Class<?> clazz5 = class$7;
        if (clazz5 == null) {
            try {
                clazz5 = class$7 = Class.forName("edu.berkeley.guir.lib.gesture.features.InitAngleCosine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        double cosInitAngle = HumanCoords.gestureValue(clazz5, gesture);
        Class<?> clazz6 = class$2;
        if (clazz6 == null) {
            try {
                clazz6 = class$2 = Class.forName("edu.berkeley.guir.lib.gesture.features.Density1");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        double density1 = HumanCoords.gestureValue(clazz6, gesture);
        coords2[2] = -0.580199 * cosInitAngle + 0.053814637 * density1 - 0.40120782;
        Class<?> clazz7 = class$8;
        if (clazz7 == null) {
            try {
                clazz7 = class$8 = Class.forName("edu.berkeley.guir.lib.gesture.features.EndsDistance");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        double endsDistance = HumanCoords.gestureValue(clazz7, gesture);
        Class<?> clazz8 = class$9;
        if (clazz8 == null) {
            try {
                clazz8 = class$9 = Class.forName("edu.berkeley.guir.lib.gesture.features.InitAngleSine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        double sinInitAngle = HumanCoords.gestureValue(clazz8, gesture);
        Class<?> clazz9 = class$10;
        if (clazz9 == null) {
            try {
                clazz9 = class$10 = Class.forName("edu.berkeley.guir.lib.gesture.features.BoundsAngle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        double bbAngle = HumanCoords.gestureValue(clazz9, gesture);
        Class<?> clazz10 = class$3;
        if (clazz10 == null) {
            try {
                clazz10 = class$3 = Class.forName("edu.berkeley.guir.lib.gesture.features.EndsAngleCosine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        double cosEnds = HumanCoords.gestureValue(clazz10, gesture);
        coords2[3] = -0.814554697 * cosInitAngle + 0.48012199 * sinInitAngle - 0.53175652 * bbAngle - 0.004912005 * endsDistance - 1.22419693 * cosEnds + 1.545189697;
        Class<?> clazz11 = class$11;
        if (clazz11 == null) {
            try {
                clazz11 = class$11 = Class.forName("edu.berkeley.guir.lib.gesture.features.TotalAngle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        double totalAngle = HumanCoords.gestureValue(clazz11, gesture);
        Class<?> clazz12 = class$12;
        if (clazz12 == null) {
            try {
                clazz12 = class$12 = Class.forName("edu.berkeley.guir.lib.gesture.features.Sharpness");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        double sharpness = HumanCoords.gestureValue(clazz12, gesture);
        Class<?> clazz13 = class$4;
        if (clazz13 == null) {
            try {
                clazz13 = class$4 = Class.forName("edu.berkeley.guir.lib.gesture.features.Aspect");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        double aspect = HumanCoords.gestureValue(clazz13, gesture);
        coords2[4] = -0.604946888172 * cosInitAngle + 0.048878922781 * totalAngle + 0.138386160534 * sharpness + 5.706718272706 * aspect - 2.602023183052;
        return coords2;
    }

    public static double gestureValue(Class featureClass, Gesture g) {
        return FeatureFactory.getFeature(featureClass, g).getValue();
    }

    public static double distanceSq(double[] x, double[] y) {
        double dist = 0.0;
        int i = 0;
        while (i < x.length) {
            dist += (x[i] - y[i]) * (x[i] - y[i]);
            ++i;
        }
        return dist;
    }

    public static double[] averageCoords(GestureCategory gc) {
        double[] sum = new double[5];
        int numGestures = gc.size();
        int j = 0;
        while (j < sum.length) {
            sum[j] = 0.0;
            ++j;
        }
        int i = 0;
        while (i < numGestures) {
            double[] coords2 = HumanCoords.computeCoords(gc.gestureAt(i));
            int j2 = 0;
            while (j2 < sum.length) {
                int n = j2;
                sum[n] = sum[n] + coords2[j2];
                ++j2;
            }
            ++i;
        }
        j = 0;
        while (j < sum.length) {
            int n = j++;
            sum[n] = sum[n] / (double)numGestures;
        }
        return sum;
    }

    public static DistanceInfo getDistanceInfo(GestureCategory gc1, GestureCategory gc2) {
        double dist = 0.0;
        double maxDist = 0.0;
        int dimension = -1;
        int direction = 0;
        double[] x = HumanCoords.averageCoords(gc1);
        double[] y = HumanCoords.averageCoords(gc2);
        int i = 0;
        while (i < x.length) {
            double delta = x[i] - y[i];
            double deltaSq = delta * delta;
            dist += deltaSq;
            if (deltaSq > maxDist) {
                maxDist = delta;
                dimension = i;
                direction = Misc.sign(delta);
            }
            ++i;
        }
        DistanceInfo result = new DistanceInfo();
        result.distanceSq = dist;
        result.dimension = dimension;
        result.featureClass = HumanCoords.findPrincipleComponent(dimension);
        result.direction = direction;
        return result;
    }

    public static double distanceSq(GestureCategory gc1, GestureCategory gc2) {
        double[] average1 = HumanCoords.averageCoords(gc1);
        double[] average2 = HumanCoords.averageCoords(gc2);
        return HumanCoords.distanceSq(average1, average2);
    }

    public static Class findPrincipleComponent(int dimension) {
        return PRINCIPLE_COMPONENTS[dimension];
    }

    public static class DistanceInfo {
        public double distanceSq;
        public Class featureClass;
        public int dimension;
        public int direction;
    }
}

