/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture;

import edu.berkeley.guir.lib.gesture.ClassificationMatrix;
import edu.berkeley.guir.lib.gesture.Classifier;
import edu.berkeley.guir.lib.gesture.CliqueList;
import edu.berkeley.guir.lib.gesture.DistanceMatrix;
import edu.berkeley.guir.lib.gesture.FPGraphFrame;
import edu.berkeley.guir.lib.gesture.GSStarPlotFrame;
import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.GestureCategory;
import edu.berkeley.guir.lib.gesture.GestureCategoryFrame;
import edu.berkeley.guir.lib.gesture.GestureCategoryThumbnail;
import edu.berkeley.guir.lib.gesture.GestureContainer;
import edu.berkeley.guir.lib.gesture.GestureInteractor;
import edu.berkeley.guir.lib.gesture.GestureSet;
import edu.berkeley.guir.lib.gesture.GestureSetDisplay;
import edu.berkeley.guir.lib.gesture.TestSetFrame;
import edu.berkeley.guir.lib.gesture.TrainingException;
import edu.berkeley.guir.lib.gesture.WeightTable;
import edu.berkeley.guir.lib.gesture.util.Blinker;
import edu.berkeley.guir.lib.gesture.util.HystericResizer;
import edu.berkeley.guir.lib.gesture.util.Matrix;
import edu.berkeley.guir.lib.gesture.util.Misc;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.StreamCorruptedException;
import java.text.ParseException;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GestureSetFrame
extends JFrame
implements ItemListener,
Observer {
    double cliqueDist = 8.0;
    public static Icon foobarIcon = new ImageIcon("check.gif");
    final String version = "gdt 1.0";
    final int TESTS_PER_CATEGORY = 5;
    private JLabel statusWindow;
    private JScrollPane gestureSetScroller;
    protected GestureSetDisplay gestureSetDisplay;
    private JLabel resultLabel;
    private JSplitPane splitPane;
    static Font resultFont = new Font("Serif", 1, 36);
    Classifier classifier;
    JMenuItem deleteMenuItem;
    JMenuItem cutMenuItem;
    JMenuItem copyMenuItem;
    JMenuItem pasteMenuItem;
    JMenuItem saveItem;
    JMenuItem openSelectionMenuItem;
    JMenuItem testSaveMenuItem;
    JMenuItem testStopMenuItem;
    JMenuItem testShowMenuItem;
    GestureCategory clipboard;
    TypedFile gestureSetFile = null;
    boolean autoSaveOn = true;
    final int SAVED = 2;
    final int AUTOSAVED = 1;
    final int NOT_SAVED = 0;
    int saveLevel = 2;
    final String experimentSaveDir = "data" + File.pathSeparator + "experiment";
    String lastDirectory = null;
    boolean isTrained = false;
    boolean authorsVisible = false;
    boolean experimentMode;
    boolean testMode = false;
    int testTally;
    int testsCorrect;
    int[] testCases;
    GestureSet testGestures;
    Classifier.Result[] testResults;
    Vector[][] testConfusionMatrix;
    int sameTest;
    int testSaveLevel = 2;
    transient Thread messageThread = null;

    public GestureSetFrame() {
        this("Gesture set");
    }

    public GestureSetFrame(String name) {
        this(name, false);
    }

    public GestureSetFrame(String name, boolean experimenting) {
        super(name);
        this.experimentMode = experimenting;
        this.initFrame();
    }

    protected void initFrame() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                GestureSetFrame.this.askToSave();
            }
        });
        JPanel contents = new JPanel();
        contents.setLayout(new BorderLayout(5, 5));
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        JPanel top = new JPanel(new BorderLayout(5, 5));
        JMenuBar menuBar = this.constructMenuBar();
        this.getRootPane().setJMenuBar(menuBar);
        this.gestureSetDisplay = new GestureSetDisplay(this.experimentMode);
        this.gestureSetDisplay.setAuthorsVisible(this.authorsVisible);
        this.gestureSetDisplay.getGestureSet().addObserver(this);
        this.gestureSetDisplay.addItemListener(this);
        this.gestureSetScroller = new JScrollPane(this.gestureSetDisplay);
        this.gestureSetScroller.setMinimumSize(new Dimension(0, 0));
        this.gestureSetDisplay.setScroller(this.gestureSetScroller);
        top.add((Component)this.gestureSetScroller, "Center");
        JPanel statusPanel = new JPanel();
        statusPanel.setForeground(Color.blue);
        statusPanel.setLayout(new BorderLayout(5, 5));
        this.statusWindow = new JLabel();
        this.message("Welcome to GDT!");
        statusPanel.add((Component)this.statusWindow, "Center");
        Blinker blinker = new Blinker();
        blinker.setPreferredSize(new Dimension(15, 15));
        blinker.setBorder(BorderFactory.createEmptyBorder(2, 2, 8, 4));
        statusPanel.add((Component)blinker, "East");
        top.add((Component)statusPanel, "South");
        JPanel testPanel = new JPanel(new BorderLayout(5, 5));
        GestureInteractor testInteractor = new GestureInteractor();
        testInteractor.addChangeListener(new ClassifyHandler());
        testInteractor.setBorder(BorderFactory.createLoweredBevelBorder());
        testPanel.add((Component)testInteractor, "Center");
        JLabel testLabel = new JLabel("Draw gesture to be recognized below");
        testPanel.add((Component)testLabel, "North");
        this.splitPane = new JSplitPane(0, true, top, testPanel);
        contents.add((Component)this.splitPane, "Center");
        HystericResizer hr = new HystericResizer();
        this.getRootPane().addComponentListener(hr);
        contents.setPreferredSize(new Dimension(500, 500));
        this.getContentPane().add((Component)contents, "Center");
    }

    public void setDividerLocation(double percent) {
        this.splitPane.setDividerLocation(0.5);
    }

    protected JMenuBar constructMenuBar() {
        JMenuBar mb = new JMenuBar();
        mb.add(this.constructFileMenu());
        mb.add(this.constructEditMenu());
        if (!this.experimentMode) {
            mb.add(this.constructViewMenu());
        }
        mb.add(this.constructClassMenu());
        mb.add(this.constructSetMenu());
        mb.add(this.constructTestMenu());
        if (!this.experimentMode) {
            mb.add(this.constructDebugMenu());
        }
        return mb;
    }

    protected JMenu constructFileMenu() {
        JMenu fileMenu = new JMenu("File");
        JMenuItem openItem = new JMenuItem("Open");
        ActionListener openListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String directory = GestureSetFrame.this.lastDirectory != null ? GestureSetFrame.this.lastDirectory : (GestureSetFrame.this.experimentMode ? GestureSetFrame.this.experimentSaveDir : "data");
                JFileChooser fileChooser = new JFileChooser(directory);
                int returnVal = fileChooser.showOpenDialog(GestureSetFrame.this.statusWindow.getTopLevelAncestor());
                switch (returnVal) {
                    case 0: {
                        GestureSetFrame.this.openFile(fileChooser.getSelectedFile());
                        break;
                    }
                    case 1: {
                        GestureSetFrame.this.message("Open cancelled", 10);
                        break;
                    }
                    default: {
                        System.err.println("Bogosity from JFileChooser");
                    }
                }
            }
        };
        openItem.addActionListener(openListener);
        openItem.setAccelerator(KeyStroke.getKeyStroke(79, 12));
        fileMenu.add(openItem);
        this.saveItem = new JMenuItem("Save");
        ActionListener saveListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GestureSetFrame.this.saveFile(null);
            }
        };
        this.saveItem.addActionListener(saveListener);
        this.saveItem.setEnabled(false);
        this.saveItem.setAccelerator(KeyStroke.getKeyStroke(83, 12));
        fileMenu.add(this.saveItem);
        JMenuItem saveAsItem = new JMenuItem("Save As...");
        ActionListener saveAsListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TypedFile f = GestureSetFrame.this.askForSaveFile();
                if (f != null) {
                    if (f.exists()) {
                        int reply = JOptionPane.showConfirmDialog(GestureSetFrame.this, "File exists.  Overwrite it?", "gdt: Overwrite file?", 0, 3);
                        switch (reply) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                GestureSetFrame.this.message("Save cancelled");
                                return;
                            }
                            default: {
                                GestureSetFrame.this.message("Bogosity in GestureSetFrame");
                                return;
                            }
                        }
                    }
                    GestureSetFrame.this.saveFile(f);
                } else {
                    GestureSetFrame.this.message("Save cancelled");
                }
            }
        };
        saveAsItem.addActionListener(saveAsListener);
        fileMenu.add(saveAsItem);
        JMenuItem exit = new JMenuItem("Quit");
        ActionListener exitListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GestureSetFrame.this.askToSave();
                System.exit(0);
            }
        };
        exit.addActionListener(exitListener);
        exit.setAccelerator(KeyStroke.getKeyStroke(81, 12));
        fileMenu.add(exit);
        return fileMenu;
    }

    protected JMenu constructEditMenu() {
        JMenuItem item;
        JMenu menu = new JMenu("Edit");
        this.deleteMenuItem = item = new JMenuItem("Delete");
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String selectionName = GestureSetFrame.this.gestureSetDisplay.getSelection().getName();
                int confirmDelete = JOptionPane.showConfirmDialog(GestureSetFrame.this, "Really delete class '" + selectionName + "'?", "gdt: confirm delete class", 0, 3);
                switch (confirmDelete) {
                    case 0: {
                        GestureSetFrame.this.deleteSelection();
                        break;
                    }
                    case 1: {
                        GestureSetFrame.this.message("Delete cancelled");
                        break;
                    }
                    default: {
                        GestureSetFrame.this.message("WARNING: bogosity in GestureSetFrame");
                        return;
                    }
                }
            }
        };
        item.addActionListener(listener);
        item.setEnabled(false);
        menu.add(item);
        this.cutMenuItem = item = new JMenuItem("Cut");
        listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GestureSetFrame.this.setClipboard();
                GestureSetFrame.this.deleteSelection();
            }
        };
        item.addActionListener(listener);
        item.setEnabled(false);
        menu.add(item);
        this.copyMenuItem = item = new JMenuItem("Copy");
        listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GestureSetFrame.this.copyClipboard();
            }
        };
        item.addActionListener(listener);
        item.setEnabled(false);
        menu.add(item);
        this.pasteMenuItem = item = new JMenuItem("Paste");
        listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GestureSetFrame.this.gestureSetDisplay.getGestureSet().add((GestureCategory)GestureSetFrame.this.getClipboard().clone());
            }
        };
        item.addActionListener(listener);
        item.setEnabled(false);
        menu.add(item);
        return menu;
    }

    protected JMenu constructViewMenu() {
        JMenu menu = new JMenu("View");
        final JCheckBoxMenuItem cbItem = new JCheckBoxMenuItem("Author");
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GestureSetFrame.this.authorsVisible = cbItem.getState();
                GestureSetFrame.this.gestureSetDisplay.setAuthorsVisible(GestureSetFrame.this.authorsVisible);
            }
        };
        if (!this.authorsVisible) {
            cbItem.setState(false);
        }
        cbItem.addActionListener(listener);
        menu.add(cbItem);
        return menu;
    }

    protected JMenu constructClassMenu() {
        JMenu menu = new JMenu("Class");
        JMenuItem item = new JMenuItem("New");
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String lastName;
                GestureSetFrame gsFrame = GestureSetFrame.this;
                gsFrame.doAutoSave(null);
                GestureSet gs = GestureSetFrame.this.gestureSetDisplay.getGestureSet();
                String newName = null;
                if (gs != null && gs.size() > 0 && (lastName = ((GestureContainer)gs.getChild(gs.size() - 1)).getName()) != null && lastName.length() == 1) {
                    newName = new Character((char)(lastName.charAt(0) + '\u0001')).toString();
                }
                GestureCategory gc = new GestureCategory(newName);
                gc.setAuthor(gs.getAuthor());
                GestureSetFrame.this.addCategory(gc);
                GestureCategoryFrame gcFrame = GestureSetFrame.this.gestureSetDisplay.showCategoryFrame(gc);
                gcFrame.addWindowListener(new WindowAdapter(this, gsFrame){
                    final /* synthetic */ 11 this$1;
                    private final /* synthetic */ GestureSetFrame val$gsFrame;
                    {
                        this.this$1 = var1_1;
                        this.val$gsFrame = gestureSetFrame;
                    }

                    public void windowClosing(WindowEvent we) {
                        this.val$gsFrame.doAutoSave(null);
                    }
                });
            }
        };
        item.addActionListener(listener);
        menu.add(item);
        this.openSelectionMenuItem = new JMenuItem("Open selection");
        listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GestureSetFrame.this.gestureSetDisplay.showCategoryFrame(GestureSetFrame.this.gestureSetDisplay.getSelection());
            }
        };
        this.openSelectionMenuItem.addActionListener(listener);
        this.openSelectionMenuItem.setEnabled(false);
        menu.add(this.openSelectionMenuItem);
        return menu;
    }

    protected JMenu constructSetMenu() {
        JMenu menu = new JMenu("Set");
        JMenuItem item = new JMenuItem("Distance matrix");
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!GestureSetFrame.this.train()) {
                    GestureSetFrame.this.message("Cannot build distance matrix unless training succeeds");
                } else {
                    DistanceMatrix f = new DistanceMatrix(GestureSetFrame.this.classifier);
                    f.pack();
                    f.show();
                }
            }
        };
        item.addActionListener(listener);
        menu.add(item);
        item = new JMenuItem("Feature graph");
        listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean trainingFailed = false;
                if (GestureSetFrame.this.classifier == null) {
                    GestureSetFrame.this.classifier = new Classifier(GestureSetFrame.this.gestureSetDisplay.getGestureSet());
                    try {
                        GestureSetFrame.this.classifier.train();
                    }
                    catch (TrainingException exception) {
                        trainingFailed = true;
                    }
                    catch (InterruptedException exception) {
                        trainingFailed = true;
                    }
                }
                FPGraphFrame f = new FPGraphFrame(GestureSetFrame.this.classifier);
                f.enableWeights(!trainingFailed);
                f.pack();
                f.setSize(new Dimension(800, 400));
                f.show();
            }
        };
        item.addActionListener(listener);
        menu.add(item);
        item = new JMenuItem("Change author");
        listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GestureSetFrame.this.setAuthorDialog();
            }
        };
        item.addActionListener(listener);
        menu.add(item);
        item = new JMenuItem("Train");
        listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GestureSetFrame.this.train();
            }
        };
        item.addActionListener(listener);
        menu.add(item);
        if (!this.experimentMode) {
            item = new JMenuItem("Star plots");
            listener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (!GestureSetFrame.this.train()) {
                        GestureSetFrame.this.message("Cannot make star plots unless training succeeds");
                    } else {
                        GSStarPlotFrame gsspf = new GSStarPlotFrame(GestureSetFrame.this.classifier);
                        gsspf.show();
                    }
                }
            };
            item.addActionListener(listener);
            menu.add(item);
            item = new JMenuItem("Weight table");
            listener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (!GestureSetFrame.this.train()) {
                        GestureSetFrame.this.message("Cannot build weight table unless training succeeds");
                    } else {
                        WeightTable f = new WeightTable(GestureSetFrame.this.classifier);
                        f.pack();
                        f.show();
                    }
                }
            };
            item.addActionListener(listener);
            menu.add(item);
        }
        return menu;
    }

    protected JMenu constructTestMenu() {
        JMenu menu = new JMenu("Test");
        JMenuItem testStartMenuItem = new JMenuItem("Start");
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GestureSetFrame.this.startTest();
            }
        };
        testStartMenuItem.addActionListener(listener);
        menu.add(testStartMenuItem);
        this.testStopMenuItem = new JMenuItem("Stop");
        listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GestureSetFrame.this.stopTest();
            }
        };
        this.testStopMenuItem.addActionListener(listener);
        this.testStopMenuItem.setEnabled(false);
        menu.add(this.testStopMenuItem);
        this.testSaveMenuItem = new JMenuItem("Save results");
        listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GestureSetFrame foo = GestureSetFrame.this;
                foo.saveTest();
            }
        };
        this.testSaveMenuItem.addActionListener(listener);
        this.testSaveMenuItem.setEnabled(false);
        menu.add(this.testSaveMenuItem);
        this.testShowMenuItem = new JMenuItem("Show results");
        listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GestureSetFrame.this.showTestResults();
            }
        };
        this.testShowMenuItem.addActionListener(listener);
        this.testShowMenuItem.setEnabled(false);
        menu.add(this.testShowMenuItem);
        JMenuItem item = new JMenuItem("New test set");
        listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TestSetFrame f = new TestSetFrame(GestureSetFrame.this);
                f.pack();
                f.show();
            }
        };
        item.addActionListener(listener);
        menu.add(item);
        return menu;
    }

    protected JMenu constructDebugMenu() {
        JMenu menu = new JMenu("Debug");
        JMenuItem item = new JMenuItem("Dump cliques");
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    if (GestureSetFrame.this.classifier == null) {
                        GestureSetFrame.this.classifier = new Classifier(GestureSetFrame.this.gestureSetDisplay.getGestureSet());
                    }
                    CliqueList cl = new CliqueList(GestureSetFrame.this.classifier, GestureSetFrame.this.cliqueDist);
                    cl.printCliques(System.out);
                }
                catch (TrainingException exception) {
                    GestureSetFrame.this.message("Cannot show clique list unless training succeeds");
                }
                catch (InterruptedException exception) {
                    GestureSetFrame.this.message("Training was interrupted, cannot show clique list");
                }
            }
        };
        item.addActionListener(listener);
        menu.add(item);
        item = new JMenuItem("Category info");
        listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GestureSetFrame.this.gestureSetDisplay.getGestureSet().dumpNames(System.out);
            }
        };
        item.addActionListener(listener);
        menu.add(item);
        item = new JMenuItem("Covariance matrix");
        listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (GestureSetFrame.this.classifier != null) {
                    Matrix.prettyPrint(GestureSetFrame.this.classifier.ccm);
                }
            }
        };
        item.addActionListener(listener);
        menu.add(item);
        item = new JMenuItem("Relative variance");
        listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (GestureSetFrame.this.classifier != null) {
                    GestureSetFrame.this.classifier.dumpRelativeVariance(System.out);
                }
            }
        };
        item.addActionListener(listener);
        menu.add(item);
        item = new JMenuItem("GSD Position");
        listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Rectangle r = GestureSetFrame.this.gestureSetDisplay.getBounds();
                Dimension ps = GestureSetFrame.this.gestureSetDisplay.getLayout().preferredLayoutSize(GestureSetFrame.this.gestureSetDisplay.getParent());
                GestureSetFrame.this.message(String.valueOf(r.width) + "x" + r.height + "+" + r.x + "+" + r.y + "  Pref: " + ps.width + "x" + ps.height);
            }
        };
        item.addActionListener(listener);
        menu.add(item);
        return menu;
    }

    void addCategory(GestureCategory category) {
        GestureSet gestureSet = this.gestureSetDisplay.getGestureSet();
        if (gestureSet == null) {
            System.err.println("gdt: Bogosity in GestureSetFrame.addCategory. This should never happen");
            gestureSet = new GestureSet();
            this.gestureSetDisplay.setGestureSet(gestureSet);
            gestureSet.addObserver(this);
        }
        gestureSet.add(category);
    }

    public void message(String msg) {
        this.message(msg, 300000);
    }

    public void message(String msg, int delay) {
        final int delaytime = delay;
        if (this.messageThread != null) {
            this.messageThread.interrupt();
        }
        this.statusWindow.setText(msg);
        this.statusWindow.paintImmediately(this.getBounds());
        if (delaytime > 0) {
            this.messageThread = new Thread(){

                public void run() {
                    try {
                        Thread.sleep(delaytime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    GestureSetFrame.this.statusWindow.setText("");
                }
            };
            this.messageThread.setDaemon(true);
            this.messageThread.setName("message thread");
            this.messageThread.start();
        }
    }

    boolean train() {
        boolean success = true;
        GestureSet gs = this.gestureSetDisplay.getGestureSet();
        if (gs == null) {
            this.message("No gestures to train");
            success = false;
        } else if (this.isTrained) {
            this.message("Already trained.");
        } else {
            this.message("Beginning training...");
            try {
                if (this.classifier == null) {
                    this.classifier = new Classifier(this.gestureSetDisplay.getGestureSet());
                } else {
                    this.classifier.train();
                }
                this.isTrained = true;
                this.message("Training done");
            }
            catch (TrainingException exception) {
                success = false;
                final JDialog dialog = new JDialog((Frame)this, "Training Error");
                JTextArea ta = new JTextArea(new String("The following error occurred while traiing this gesture set:" + exception.getMessage()));
                dialog.getContentPane().add((Component)ta, "Center");
                JButton closeButton = new JButton("Ok");
                ActionListener l = new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        dialog.dispose();
                    }
                };
                closeButton.addActionListener(l);
                dialog.getContentPane().add((Component)closeButton, "South");
                dialog.pack();
                dialog.show();
                this.message("Error during training");
            }
            catch (InterruptedException exception) {
                this.message("Training was interrupted");
            }
        }
        return success;
    }

    TypedFile askForSaveFile() {
        String directory = this.lastDirectory != null ? this.lastDirectory : (this.experimentMode ? this.experimentSaveDir : "data");
        JFileChooser fileChooser = new JFileChooser(directory);
        JPanel panel = new JPanel();
        panel.add(new JLabel("File type"));
        JComboBox<String> fileType = new JComboBox<String>();
        fileType.addItem("ASCII");
        fileType.addItem("Binary");
        panel.add(fileType);
        panel.setMaximumSize(panel.getPreferredSize());
        fileChooser.setAccessory(panel);
        int returnVal = fileChooser.showSaveDialog(this.statusWindow.getTopLevelAncestor());
        switch (returnVal) {
            case 0: {
                return new TypedFile(fileChooser.getSelectedFile(), (String)fileType.getSelectedItem());
            }
            case 1: {
                this.message("Save cancelled", 10);
                break;
            }
            default: {
                System.err.println("Bogosity from JFileChooser");
            }
        }
        return null;
    }

    public void openFile(File f) {
        block14: {
            this.lastDirectory = f.getParent();
            File asFile = this.autoSaveFile(f);
            boolean usingAutosave = false;
            try {
                if (asFile.exists() && asFile.lastModified() > f.lastModified()) {
                    int useAutosave = JOptionPane.showConfirmDialog(this, "Autosave file exists for '" + f.getName() + "'.  Use autosave file?", "gdt: Use Autosave File?", 1, 3);
                    switch (useAutosave) {
                        case 0: {
                            f = asFile;
                            this.setFile(this.openActualFile(f));
                            this.setSaveLevel(1);
                            break block14;
                        }
                        case 1: {
                            this.message("Autosave disabled until file saved");
                            this.autoSaveOn = false;
                            this.setFile(this.openActualFile(f));
                            this.saveItem.setEnabled(true);
                            this.setSaveLevel(2);
                            break block14;
                        }
                        case 2: {
                            return;
                        }
                        default: {
                            this.message("WARNING: bogosity in GestureSetFrame.openFile");
                            return;
                        }
                    }
                }
                this.setFile(this.openActualFile(f));
                this.saveItem.setEnabled(true);
                this.setSaveLevel(2);
            }
            catch (ClassNotFoundException e) {
                this.message("Cannot find required class while reading file '" + f + "': " + e);
            }
            catch (InvalidClassException e) {
                this.message("Problem with a class while reading file '" + f + "': " + e);
            }
            catch (StreamCorruptedException e) {
                this.message("The stream for file '" + f + "' is corrupted");
            }
            catch (ObjectStreamException e) {
                this.message("Expected an object but got primitive data while reading file '" + f + "': " + e);
            }
            catch (IOException e) {
                this.message("I/O error reading file '" + f + "': " + e);
            }
            catch (ParseException e) {
                this.message("Error parsing file '" + f + "': " + e);
            }
            catch (UnknownClassException e) {
                this.message("Error reading file '" + f + "': " + e);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    TypedFile openActualFile(File f) throws IOException, ParseException, UnknownClassException, ClassNotFoundException {
        Object var8_13;
        boolean OK = false;
        boolean NON_BINARY = true;
        int ERROR = 2;
        TypedFile openedFile = null;
        try {
            ObjectInputStream p = new ObjectInputStream(new FileInputStream(f));
            try {
                Object obj;
                String v = (String)p.readObject();
                if (!"gdt 1.0".equals(v)) {
                    this.message("Error while reading file '" + f + "': expected version '" + "gdt 1.0" + "' but got version '" + v + "'");
                }
                if ((obj = p.readObject()) instanceof GestureSet) {
                    GestureSet gestureSet = (GestureSet)obj;
                    this.gestureSetDisplay.setGestureSet(gestureSet);
                    gestureSet.addObserver(this);
                    this.classifier = null;
                    this.isTrained = false;
                } else {
                    if (!(obj instanceof GestureCategory)) throw new UnknownClassException("Unknown object type '" + obj.getClass().getName() + "'");
                    this.addCategory((GestureCategory)obj);
                }
            }
            catch (Throwable throwable) {
                Object var10_17 = null;
                p.close();
                throw throwable;
            }
            {
                Object var10_18 = null;
            }
            p.close();
            this.stopTest();
            openedFile = new TypedFile(f, "binary");
        }
        catch (ClassNotFoundException e) {
            throw new ClassNotFoundException("Cannot find required class while reading file '" + f + "': " + e);
        }
        catch (InvalidClassException e) {
            throw new InvalidClassException("Problem with a class while reading file '" + f + "': " + e);
        }
        catch (StreamCorruptedException e) {
        }
        catch (ObjectStreamException e) {
            throw new IOException("Expected an object but got primitive data while reading file '" + f + "': " + e);
        }
        catch (IOException e) {
            throw new IOException("I/O error reading file '" + f + "': " + e);
        }
        if (openedFile != null) return openedFile;
        FileReader reader = new FileReader(f);
        try {
            GestureSet gestureSet = GestureSet.read(reader);
            this.gestureSetDisplay.setGestureSet(gestureSet);
            gestureSet.addObserver(this);
            this.classifier = null;
            this.isTrained = false;
            openedFile = new TypedFile(f, "ASCII");
        }
        catch (Throwable throwable) {
            var8_13 = null;
            reader.close();
            throw throwable;
        }
        {
            var8_13 = null;
        }
        reader.close();
        return openedFile;
    }

    public void saveFile(TypedFile f) {
        this.saveFile(f, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void saveFile(TypedFile f, boolean isAutosave) {
        if (f == null) {
            if (this.gestureSetFile == null) {
                f = this.askForSaveFile();
                if (f == null) {
                    this.message("Save cancelled");
                    return;
                }
            } else {
                f = this.gestureSetFile;
            }
        }
        this.lastDirectory = f.getParent();
        try {
            block14: {
                String type = f.getType();
                if (type.equals("ASCII")) {
                    this.message("Saving as ASCII...");
                    FileWriter writer = new FileWriter(f);
                    try {
                        this.gestureSetDisplay.getGestureSet().write(writer);
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        writer.close();
                        throw throwable;
                    }
                    {
                        Object var5_9 = null;
                        writer.close();
                        break block14;
                    }
                }
                if (type.equals("binary")) {
                    this.message("Saving as binary...");
                    FileOutputStream ostream = new FileOutputStream(f);
                    ObjectOutputStream objStream = new ObjectOutputStream(ostream);
                    objStream.writeObject("gdt 1.0");
                    objStream.writeObject(this.gestureSetDisplay.getGestureSet());
                    objStream.flush();
                    ostream.close();
                } else {
                    this.message("Bogosity: bad file type '" + type + "'. Save aborted. (Try 'Save As'.)");
                }
            }
            if (isAutosave) {
                this.setSaveLevel(1);
            } else {
                this.setFile(f);
                this.autoSaveOn = true;
                this.setSaveLevel(2);
            }
            this.message("File saved", 10);
            return;
        }
        catch (IOException exception) {
            this.message("I/O Error saving file " + f + ": " + exception);
        }
    }

    TypedFile autoSaveFile(TypedFile f) {
        return new TypedFile(new File(f.getParent(), "#" + f.getName() + "#"), f.getType());
    }

    File autoSaveFile(File f) {
        return new File(f.getParent(), "#" + f.getName() + "#");
    }

    void doAutoSave(TypedFile f) {
        if (this.autoSaveOn && this.saveLevel < 1) {
            if (f == null) {
                if (this.gestureSetFile == null) {
                    return;
                }
                f = this.gestureSetFile;
            }
            this.message("Autosaving...");
            this.saveFile(this.autoSaveFile(f), true);
            this.message("Done autosaving");
        }
    }

    private void handleTestCase(Gesture gesture, Classifier.Result result) {
    }

    void showTestResults() {
        int percentCorrect = (int)Math.round((double)this.testsCorrect * 100.0 / (double)this.testCases.length);
        this.message("Test done. " + percentCorrect + "% (" + this.testsCorrect + "/" + this.testCases.length + ") correct.", 0);
        TestSetFrame tsFrame = new TestSetFrame(this);
        tsFrame.gestureSetDisplay.setGestureSet(this.testGestures);
        tsFrame.pack();
        tsFrame.show();
        ClassificationMatrix cm = new ClassificationMatrix(this.testConfusionMatrix, tsFrame.gestureSetDisplay);
        cm.setTitle("Test results");
        cm.pack();
        cm.show();
    }

    void showTestCase() {
        String timeString;
        int gcIndex = this.testCases[this.testTally];
        String name = ((GestureContainer)this.gestureSetDisplay.getGestureSet().getChild(gcIndex)).getName();
        GestureCategoryThumbnail gct = this.gestureSetDisplay.getGestureCategoryThumbnail(gcIndex);
        this.gestureSetDisplay.setSelection(gct);
        this.gestureSetDisplay.scrollRectToVisible(gct.getBounds());
        if (this.testTally > 0 && gcIndex == this.testCases[this.testTally - 1]) {
            ++this.sameTest;
            timeString = " (" + Misc.ordinal(this.sameTest) + " time)";
        } else {
            this.sameTest = 1;
            timeString = "";
        }
        this.message("Draw the '" + name + "' gesture" + timeString, 0);
    }

    void startTest() {
        if (!this.testMode && this.testSaveLevel != 2) {
            int reply = JOptionPane.showConfirmDialog(this, "Test results have not been saved. Save them now?", "gdt: Save Test Results?", 0, 3);
            switch (reply) {
                case 0: {
                    this.saveTest();
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    this.message("Bogosity in GestureSetFrame.askToSave");
                }
            }
        }
        this.testMode = true;
        this.resetTestState();
        this.testStopMenuItem.setEnabled(true);
        this.testSaveMenuItem.setEnabled(false);
        this.testShowMenuItem.setEnabled(false);
        this.gestureSetDisplay.setSelection(null);
        this.showTestCase();
    }

    void resetTestState() {
        if (this.testMode) {
            GestureSet gestureSet = this.gestureSetDisplay.getGestureSet();
            int numCategories = gestureSet.size();
            int numTestCases = numCategories * 5;
            this.testSaveLevel = 0;
            this.sameTest = 1;
            this.testTally = 0;
            this.testsCorrect = 0;
            this.testConfusionMatrix = new Vector[numCategories][numCategories];
            this.testResults = new Classifier.Result[numTestCases];
            this.testGestures = new GestureSet();
            int tally = 0;
            this.testCases = new int[numTestCases];
            int gcIndex = 0;
            while (gcIndex < numCategories) {
                int i = 0;
                while (i < 5) {
                    this.testCases[tally] = gcIndex;
                    ++i;
                    ++tally;
                }
                this.testGestures.add(new GestureCategory(((GestureContainer)gestureSet.getChild(gcIndex)).getName()));
                ++gcIndex;
            }
            Misc.shuffle(this.testCases);
        }
    }

    void stopTest() {
        this.testMode = false;
        this.testStopMenuItem.setEnabled(false);
        this.gestureSetDisplay.setSelection(null);
    }

    void saveTest() {
        FileDialog fileChooser = new FileDialog((Frame)this.statusWindow.getTopLevelAncestor(), "Save Test", 1);
        fileChooser.setDirectory(this.experimentMode ? this.experimentSaveDir : "data");
        fileChooser.show();
        String baseName = fileChooser.getFile();
        if (baseName != null) {
            String dirName = fileChooser.getDirectory();
            File f = new File(dirName, baseName);
            GestureSet gs = this.gestureSetDisplay.getGestureSet();
            try {
                FileWriter writer = new FileWriter(f);
                int row = 0;
                while (row < this.testConfusionMatrix.length) {
                    writer.write(((GestureContainer)gs.getChild(row)).getName());
                    Vector[] currentRow = this.testConfusionMatrix[row];
                    int col = 0;
                    while (col < currentRow.length) {
                        int size = currentRow[col] == null ? 0 : currentRow[col].size();
                        writer.write("\t" + size);
                        ++col;
                    }
                    writer.write("\n");
                    ++row;
                }
                writer.close();
            }
            catch (IOException exception) {
                this.message("Error saving test results to '" + f + "': " + exception);
                return;
            }
            f = new File(dirName, String.valueOf(baseName) + "-ex.gs");
            try {
                ObjectOutputStream objStream = new ObjectOutputStream(new FileOutputStream(f));
                objStream.writeObject("gdt 1.0");
                objStream.writeObject(this.testGestures);
                objStream.close();
            }
            catch (IOException exception) {
                this.message("Error saving test examples to '" + f + "': " + exception);
                return;
            }
            this.testSaveLevel = 2;
        } else {
            this.message("Test save cancelled");
        }
    }

    void setClipboard() {
        this.clipboard = this.gestureSetDisplay.getSelection();
        this.pasteMenuItem.setEnabled(true);
    }

    void copyClipboard() {
        this.clipboard = (GestureCategory)this.gestureSetDisplay.getSelection().clone();
        this.pasteMenuItem.setEnabled(true);
    }

    GestureCategory getClipboard() {
        return this.clipboard;
    }

    void deleteSelection() {
        this.gestureSetDisplay.getGestureSet().remove(this.gestureSetDisplay.getSelection());
        this.openSelectionMenuItem.setEnabled(false);
        this.deleteMenuItem.setEnabled(false);
        this.cutMenuItem.setEnabled(false);
        this.copyMenuItem.setEnabled(false);
    }

    public void itemStateChanged(ItemEvent e) {
        int state = e.getStateChange();
        if (state == 1) {
            this.openSelectionMenuItem.setEnabled(true);
            this.deleteMenuItem.setEnabled(true);
            this.cutMenuItem.setEnabled(true);
            this.copyMenuItem.setEnabled(true);
        } else if (state == 2) {
            this.openSelectionMenuItem.setEnabled(false);
            this.deleteMenuItem.setEnabled(false);
            this.cutMenuItem.setEnabled(false);
            this.copyMenuItem.setEnabled(false);
        } else {
            System.err.println("GestureSetFrame: Unknown item state " + state);
        }
    }

    private void setFile(TypedFile f) {
        this.gestureSetFile = f;
        this.saveItem.setEnabled(true);
        this.updateTitle();
    }

    void setSaveLevel(int newLevel) {
        if (newLevel != this.saveLevel) {
            this.saveLevel = newLevel;
            this.updateTitle();
            if (this.saveLevel == 2 && this.gestureSetFile != null) {
                this.saveItem.setEnabled(false);
                TypedFile asFile = this.autoSaveFile(this.gestureSetFile);
                if (asFile.exists()) {
                    asFile.delete();
                }
            }
            if (this.saveLevel != 2 && this.gestureSetFile != null) {
                this.saveItem.setEnabled(true);
            }
        }
    }

    void updateTitle() {
        String name = this.gestureSetFile == null ? "(unnamed)" : this.gestureSetFile.getName();
        String authorName = this.gestureSetDisplay.getGestureSet().getAuthor();
        if (authorName == null) {
            authorName = "nobody";
        }
        String title = "gdt: " + name + " [" + authorName + "]";
        if (this.saveLevel != 2) {
            title = String.valueOf(title) + " (*)";
        }
        this.setTitle(title);
    }

    public void update(Observable o, Object arg) {
        if (o != null && o instanceof GestureSet) {
            this.isTrained = false;
            this.setSaveLevel(0);
            this.updateTitle();
        }
    }

    void askToSave() {
        if (this.saveLevel != 2) {
            int reply = JOptionPane.showConfirmDialog(this, "This file has not been saved. Save it now?", "gdt: Save File?", 0, 3);
            switch (reply) {
                case 0: {
                    this.saveFile(null);
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    System.err.println("Bogosity in GestureSetFrame.askToSave");
                }
            }
        }
    }

    public void setAuthor(String name) {
        this.gestureSetDisplay.getGestureSet().setAuthor(name);
    }

    void setAuthorDialog() {
        GestureSet gs = this.gestureSetDisplay.getGestureSet();
        Box widgets = new Box(1);
        widgets.add(new JLabel("Enter the author name for this gesture set"));
        String oldAuthor = gs.getAuthor();
        JTextField authorField = new JTextField(oldAuthor);
        widgets.add(authorField);
        JCheckBox recurse = new JCheckBox("Set author recursively", false);
        widgets.add(recurse);
        int dialogResult = JOptionPane.showOptionDialog(this, widgets, "Change GestureSet author", 2, 3, null, null, null);
        switch (dialogResult) {
            case 0: {
                String author = authorField.getText();
                if (author.equals(oldAuthor)) break;
                gs.setAuthor(author);
                if (!recurse.isSelected()) break;
                Iterator catIter = gs.iterator();
                while (catIter.hasNext()) {
                    GestureCategory category = (GestureCategory)catIter.next();
                    category.setAuthor(author);
                    Iterator gIter = category.iterator();
                    while (gIter.hasNext()) {
                        Gesture gesture = (Gesture)gIter.next();
                        gesture.setAuthor(author);
                    }
                }
                break;
            }
            case -1: 
            case 2: {
                break;
            }
            default: {
                System.err.println("Warning: bogus return value " + dialogResult + " from JOptionPane in GestureSetFrame");
            }
        }
    }

    public TypedFile makeTypedFile(File f, String type) {
        return new TypedFile(f, type);
    }

    public GestureSetDisplay getGestureSetDisplay() {
        return this.gestureSetDisplay;
    }

    class myFilenameFilter
    implements FilenameFilter {
        myFilenameFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(".gs");
        }
    }

    class ClassifyHandler
    implements ChangeListener {
        ClassifyHandler() {
        }

        public void stateChanged(ChangeEvent e) {
            if (GestureSetFrame.this.train()) {
                GestureInteractor interactor = (GestureInteractor)e.getSource();
                Gesture gesture = (Gesture)interactor.getGesture().clone();
                Classifier.Result result = GestureSetFrame.this.classifier.classifyWithoutTraining(gesture);
                GestureSet gestureSet = GestureSetFrame.this.gestureSetDisplay.getGestureSet();
                if (result == null) {
                    String name = "?";
                    GestureSetFrame.this.message("Unrecognized");
                } else {
                    String name = result.category.getName();
                    GestureSetFrame.this.message("Category: " + name + " Accuracy: " + Misc.toString(result.accuracy, 4) + " Distance to Mean: " + result.distToMean);
                }
                if (GestureSetFrame.this.testMode) {
                    GestureSetFrame.this.handleTestCase((Gesture)gesture.clone(), result);
                }
            } else {
                GestureSetFrame.this.message("Training failed.  Can't do recognition");
            }
        }
    }

    public class TypedFile
    extends File {
        String type;

        TypedFile(File f, String type) {
            super(f.getAbsolutePath());
            this.setType(type);
        }

        void setType(String t) {
            this.type = t.intern();
        }

        String getType() {
            return this.type;
        }
    }

    public class UnknownClassException
    extends Exception {
        public UnknownClassException() {
        }

        public UnknownClassException(String detail) {
            super(detail);
        }
    }
}

