/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture;

import edu.berkeley.guir.lib.gesture.GestureCategory;
import edu.berkeley.guir.lib.gesture.GestureCategoryFrame;
import edu.berkeley.guir.lib.gesture.GestureCategoryThumbnail;
import edu.berkeley.guir.lib.gesture.GestureSet;
import edu.berkeley.guir.lib.gesture.util.FlowScrollPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class GestureSetDisplay
extends FlowScrollPanel
implements Observer,
ItemSelectable {
    private GestureSet gestureSet;
    private GestureCategoryThumbnail selectedCategoryThumbnail;
    protected EventListenerList itemListenerList = new EventListenerList();
    int maxChildHeight = 0;
    boolean experimentMode;
    boolean authorsVisible = false;
    static /* synthetic */ Class class$0;

    public GestureSetDisplay(GestureSet gs) {
        this(gs, false);
    }

    public GestureSetDisplay(boolean experimenting) {
        this(new GestureSet(), experimenting);
    }

    public GestureSetDisplay(GestureSet gs, boolean experimenting) {
        this.experimentMode = experimenting;
        this.setGestureSet(gs);
        this.initUI();
    }

    public void setGestureSet(GestureSet gs) {
        if (this.gestureSet != null) {
            this.gestureSet.deleteObserver(this);
        }
        this.gestureSet = gs;
        if (gs != null) {
            gs.addObserver(this);
        }
        this.rebuildUI();
        this.repaint();
    }

    public GestureSet getGestureSet() {
        return this.gestureSet;
    }

    public GestureCategoryThumbnail getGestureCategoryThumbnail(int gcIndex) {
        return (GestureCategoryThumbnail)this.getComponents()[gcIndex];
    }

    boolean isDisplayed(GestureCategory gc) {
        boolean found = false;
        Component[] components = this.getComponents();
        int i = 0;
        while (i < components.length && !found) {
            GestureCategoryThumbnail gct;
            JComponent c = (JComponent)components[i];
            if (c instanceof GestureCategoryThumbnail && (gct = (GestureCategoryThumbnail)c).getGestureCategory() == gc) {
                found = true;
            }
            ++i;
        }
        return found;
    }

    public void update(Observable o, Object arg) {
        if (arg != null && arg instanceof GestureCategory) {
            GestureSet gs = (GestureSet)o;
            GestureCategory gc = (GestureCategory)arg;
            if (!this.isDisplayed(gc)) {
                this.addGestureCategory(gc);
            }
        } else if (arg == null || !(arg instanceof String)) {
            this.rebuildUI();
            if (!this.isAncestorOf(this.selectedCategoryThumbnail)) {
                GestureCategoryThumbnail oldSelection = this.selectedCategoryThumbnail;
                this.selectedCategoryThumbnail = null;
                this.fireItemChange(701, oldSelection, 2);
            }
        }
    }

    public void addGestureCategory(GestureCategory gestureCategory) {
        this.addGestureCategory(gestureCategory, false);
    }

    public void addGestureCategory(GestureCategory gestureCategory, boolean showFrame) {
        GestureCategoryThumbnail gct = new GestureCategoryThumbnail(gestureCategory, this.experimentMode, this.authorsVisible);
        if (showFrame) {
            gct.showCategoryFrame();
        }
        this.regularizeChildSizes(gct);
        gct.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                GestureCategoryThumbnail gestureCategoryThumbnail = (GestureCategoryThumbnail)e.getSource();
                GestureSetDisplay.this.regularizeChildSizes(gestureCategoryThumbnail);
            }
        });
        this.add(gct);
        this.revalidate();
        this.pack();
    }

    void regularizeChildSizes(GestureCategoryThumbnail gct) {
        boolean changed = false;
        int newHeight = gct.getMinimumSize().height;
        if (newHeight > this.maxChildHeight) {
            Component[] components = this.getComponents();
            int i = 0;
            while (i < components.length) {
                JComponent c = (JComponent)components[i];
                int oldWidth = c.getMinimumSize().width;
                c.setPreferredSize(new Dimension(oldWidth, newHeight));
                ++i;
            }
            this.maxChildHeight = newHeight;
            changed = true;
        } else if (newHeight < this.maxChildHeight) {
            gct.setPreferredSize(new Dimension(gct.getMinimumSize().width, this.maxChildHeight));
            changed = true;
        }
        if (changed) {
            this.revalidate();
            this.pack();
        }
    }

    void pack() {
        Window w = (Window)this.getTopLevelAncestor();
        if (w != null) {
            w.pack();
        }
    }

    protected void initUI() {
        this.setBackground(Color.white);
        this.setMinimumSize(new Dimension(10, 10));
        this.addMouseListener(new MouseHandler());
        ((FlowLayout)this.getLayout()).setHgap(0);
    }

    void rebuildUI() {
        this.removeAll();
        this.maxChildHeight = 0;
        Iterator iter = this.gestureSet.iterator();
        while (iter.hasNext()) {
            GestureCategory gestureCategory = (GestureCategory)iter.next();
            this.addGestureCategory(gestureCategory);
        }
        this.repaint();
    }

    public boolean isOpaque() {
        return true;
    }

    public GestureCategoryThumbnail getSelectionDisplay() {
        return this.selectedCategoryThumbnail;
    }

    public GestureCategory getSelection() {
        return this.selectedCategoryThumbnail == null ? null : this.selectedCategoryThumbnail.getGestureCategory();
    }

    public boolean isOptimizedDrawingEnabled() {
        return true;
    }

    public void setSelection(GestureCategoryThumbnail newSelection) {
        GestureCategoryThumbnail oldSelection = this.selectedCategoryThumbnail;
        if (newSelection != oldSelection) {
            this.selectedCategoryThumbnail = newSelection;
            if (oldSelection != null) {
                oldSelection.setSelected(false);
                this.fireItemChange(701, oldSelection, 2);
            }
            if (this.selectedCategoryThumbnail != null) {
                this.selectedCategoryThumbnail.setSelected(true);
                this.fireItemChange(701, this.selectedCategoryThumbnail, 1);
            }
        }
    }

    public Object[] getSelectedObjects() {
        Object[] result = new Object[]{this.selectedCategoryThumbnail};
        if (this.selectedCategoryThumbnail == null) {
            result = null;
        }
        return result;
    }

    public void addItemListener(ItemListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.awt.event.ItemListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.itemListenerList.add(clazz, l);
    }

    public void removeItemListener(ItemListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.awt.event.ItemListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.itemListenerList.remove(clazz, l);
    }

    protected void fireItemChange(int type, GestureCategoryThumbnail item, int selectState) {
        ItemEvent event = null;
        Object[] listeners = this.itemListenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            Object object = listeners[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("java.awt.event.ItemListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                if (event == null) {
                    event = new ItemEvent(this, type, item, selectState);
                }
                ((ItemListener)listeners[i + 1]).itemStateChanged(event);
            }
            i -= 2;
        }
    }

    public GestureCategoryFrame showCategoryFrame(GestureCategory category) {
        Component[] components = this.getComponents();
        boolean done = false;
        GestureCategoryFrame result = null;
        int i = 0;
        while (i < components.length && !done) {
            GestureCategoryThumbnail gct;
            if (components[i] instanceof GestureCategoryThumbnail && (gct = (GestureCategoryThumbnail)components[i]).getGestureCategory() == category) {
                result = gct.showCategoryFrame();
                done = true;
            }
            ++i;
        }
        return result;
    }

    public void setAuthorsVisible(boolean on) {
        if (this.authorsVisible != on) {
            this.authorsVisible = on;
            Component[] components = this.getComponents();
            int i = 0;
            while (i < components.length) {
                if (components[i] instanceof GestureCategoryThumbnail) {
                    GestureCategoryThumbnail gct = (GestureCategoryThumbnail)components[i];
                    gct.setAuthorVisible(on);
                }
                ++i;
            }
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        boolean mouse1(MouseEvent e) {
            int mods = e.getModifiers();
            return mods == 0 || (mods & 0x10) != 0;
        }

        public void mousePressed(MouseEvent e) {
            Point p = new Point(e.getPoint());
            Component component = GestureSetDisplay.this.getComponentAt(p);
            if (component != null && component instanceof GestureCategoryThumbnail) {
                GestureCategoryThumbnail newSelection = (GestureCategoryThumbnail)component;
                if (this.mouse1(e)) {
                    if (GestureSetDisplay.this.selectedCategoryThumbnail == newSelection) {
                        GestureSetDisplay.this.setSelection(null);
                    } else {
                        GestureSetDisplay.this.setSelection(newSelection);
                    }
                } else if ((e.getModifiers() & 4) != 0) {
                    newSelection.showCategoryFrame();
                }
            }
        }
    }
}

