/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture;

import edu.berkeley.guir.lib.gesture.AbstractGestureContainer;
import edu.berkeley.guir.lib.gesture.GestureCategory;
import edu.berkeley.guir.lib.gesture.GestureContainer;
import edu.berkeley.guir.lib.gesture.GestureGroup;
import edu.berkeley.guir.lib.gesture.GestureObject;
import edu.berkeley.guir.lib.gesture.util.Misc;
import edu.berkeley.guir.lib.gesture.util.TokenReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Vector;

public class GestureSet
extends AbstractGestureContainer
implements Serializable,
Cloneable {
    protected String keywords;
    protected Vector members = new Vector();
    private static final Class[] CHILD_TYPES;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.gesture.GestureGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("edu.berkeley.guir.lib.gesture.GestureCategory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        CHILD_TYPES = classArray;
    }

    public GestureSet() {
        this(null);
    }

    public GestureSet(Collection children) {
        if (children != null) {
            this.members.addAll(children);
        }
    }

    protected List getChildren() {
        return this.members;
    }

    public void setKeywords(String kw) {
        this.keywords = kw;
    }

    public String getKeywords() {
        return this.keywords;
    }

    protected void addCategories(List list, GestureContainer container) {
        Iterator iter = container.iterator();
        while (iter.hasNext()) {
            Object childObj = iter.next();
            Class<?> type = childObj.getClass();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("edu.berkeley.guir.lib.gesture.GestureCategory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.isAssignableFrom(type)) {
                list.add(childObj);
                continue;
            }
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("edu.berkeley.guir.lib.gesture.GestureContainer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz2.isAssignableFrom(type)) continue;
            this.addCategories(list, (GestureContainer)childObj);
        }
    }

    public List getCategories() {
        ArrayList result = new ArrayList();
        this.addCategories(result, this);
        return result;
    }

    public GestureCategory getCategory(String name) {
        if (name == null) {
            return null;
        }
        List categories = this.getCategories();
        Iterator it = categories.iterator();
        GestureCategory category = null;
        name = name.trim();
        while (it.hasNext()) {
            category = (GestureCategory)it.next();
            if (!name.equals(category.getName().trim())) continue;
            return category;
        }
        return null;
    }

    public List getEnabledCategories() {
        return (List)Misc.accept(this.getCategories(), new Misc.Acceptor(){

            public boolean accept(Object obj) {
                GestureObject g = (GestureObject)obj;
                return g.isEnabled();
            }
        });
    }

    public Class[] getChildTypes() {
        return CHILD_TYPES;
    }

    public void update(Observable gestureCategory, Object arg) {
        this.setChanged();
        this.notifyObservers(gestureCategory);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void write(Writer writer) throws IOException {
        writer.write("name\t" + this.name + "\n");
        if (this.keywords != null) {
            writer.write("keywords\t" + this.keywords + "\n");
        }
        if (this.author != null) {
            writer.write("author\t" + this.author + "\n");
        }
        int i = 0;
        while (i < this.members.size()) {
            GestureContainer container = (GestureContainer)this.members.get(i);
            if (container instanceof GestureGroup) {
                writer.write("group\n");
                ((GestureGroup)container).write(writer);
            } else if (container instanceof GestureCategory) {
                writer.write("category\n");
                ((GestureCategory)container).write(writer);
            }
            ++i;
        }
        writer.write("endset\n");
    }

    public static GestureSet read(Reader reader) throws IOException, ParseException {
        GestureSet result = new GestureSet();
        boolean done = false;
        TokenReader r = new TokenReader(reader);
        while (!done) {
            try {
                String token = r.readToken().intern();
                if (token == "name") {
                    result.name = r.readLine();
                    continue;
                }
                if (token == "keywords") {
                    result.keywords = r.readLine();
                    continue;
                }
                if (token == "author") {
                    result.author = r.readLine();
                    continue;
                }
                if (token == "categories") {
                    try {
                        int numMembers = Integer.parseInt(r.readToken());
                        int i = 0;
                        while (i < numMembers) {
                            GestureCategory gc = GestureCategory.read(r);
                            result.add(gc);
                            ++i;
                        }
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new IOException("bad argument for categories");
                    }
                }
                if (token == "category") {
                    GestureCategory gc = GestureCategory.read(r);
                    result.add(gc);
                    continue;
                }
                if (token == "group") {
                    GestureGroup gg = GestureGroup.read(r);
                    result.add(gg);
                    continue;
                }
                if (token != "endset") continue;
                done = true;
            }
            catch (EOFException e) {
                done = true;
            }
        }
        return result;
    }

    public Object clone() {
        GestureSet gs = (GestureSet)super.clone();
        gs.members = (Vector)Misc.deepCopy(this.members);
        gs.fixParents();
        return gs;
    }

    public void dumpNames(PrintStream out) {
    }

    public String toString() {
        return this.getName();
    }
}

