/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture;

import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.TimedPolygon;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import javax.swing.Timer;

public class GesturePointsDisplay
extends JPanel
implements Observer {
    static final int minDelay = 9;
    static final int restartDelay = 5000;
    static final int normalDelay = 10;
    protected static final int dotRadius = 3;
    static final int defaultXOffset = 5;
    static final int defaultYOffset = 5;
    Gesture gesture;
    boolean autoCentering = true;
    protected int xoffset;
    protected int yoffset;
    protected boolean isSelected;
    protected boolean showSelected = true;
    protected boolean showPointsOn;
    Dimension preferredSize;
    boolean narrowed;
    protected boolean animate = false;
    protected int animatePoints = 0;
    Timer timer;
    boolean validTimings = false;

    public GesturePointsDisplay() {
        this((Gesture)null);
    }

    public GesturePointsDisplay(Gesture g) {
        this(g, 5, 5);
    }

    public GesturePointsDisplay(Gesture g, int x, int y) {
        this.setGesture(g);
        this.setOffset(x, y);
        this.setBackground(Color.white);
        if (g != null) {
            this.setSize(this.getMinimumSize());
        }
    }

    public Gesture getGesture() {
        return this.gesture;
    }

    public void setGesture(Gesture g) {
        if (this.gesture != g) {
            if (this.gesture != null) {
                this.gesture.deleteObserver(this);
            }
            this.gesture = g;
            if (g != null) {
                g.addObserver(this);
                TimedPolygon polygon = g.getPoints();
                if (polygon != null && polygon.npoints > 1) {
                    this.validTimings = polygon.times[0] != polygon.times[polygon.npoints - 1];
                    this.animatePoints = polygon.npoints - 1;
                }
                if (this.animate) {
                    this.stopAnimation();
                    this.startAnimation();
                }
            } else {
                this.validTimings = false;
            }
            this.repaint();
        }
    }

    public boolean getAutoCentering() {
        return this.autoCentering;
    }

    public void setAutoCentering(boolean on) {
        if (this.autoCentering != on) {
            this.autoCentering = on;
            this.repaint();
        }
    }

    public void centerGesture() {
        this.gesture.normalize();
    }

    public void setPreferredSize(Dimension preferredSize) {
        super.setPreferredSize(preferredSize);
        this.preferredSize = preferredSize;
    }

    public Dimension getPreferredSize() {
        return this.preferredSize == null ? this.getMinimumSize() : this.preferredSize;
    }

    public Dimension getMinimumSize() {
        if (this.gesture != null) {
            Rectangle bounds = this.gesture.getBounds();
            Insets insets = this.getInsets();
            return new Dimension(bounds.x + bounds.width + this.xoffset * 2 + insets.left + insets.right, bounds.y + bounds.height + this.yoffset * 2 + insets.top + insets.bottom);
        }
        return super.getMinimumSize();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void paint(Graphics graphics) {
        TimedPolygon points;
        super.paint(graphics);
        if (this.getGesture() == null) return;
        Dimension size = this.getSize();
        if (this.isSelected && this.showSelected) {
            graphics.setColor(Color.red);
            graphics.drawRect(0, 0, size.width - 1, size.height - 1);
        }
        if ((points = this.getGesture().getPoints()) == null) return;
        if (points.npoints <= 0) return;
        Insets insets = this.getInsets();
        Graphics g = graphics.create();
        try {
            int numPoints;
            g.clipRect(0, 0, size.width - insets.right, size.height - insets.bottom);
            g.translate(this.xoffset + insets.left, this.yoffset + insets.top);
            g.setColor(Color.black);
            Graphics pointsGraphics = null;
            if (this.showPointsOn) {
                pointsGraphics = g.create();
                pointsGraphics.setColor(Color.white);
            }
            g.fillOval(points.xpoints[0] - 3, points.ypoints[0] - 3, 6, 6);
            int n = numPoints = this.animate ? this.animatePoints : points.npoints;
            if (numPoints > 1) {
                int i = 1;
                while (i < numPoints) {
                    g.drawLine(points.xpoints[i - 1], points.ypoints[i - 1], points.xpoints[i], points.ypoints[i]);
                    if (this.showPointsOn) {
                        pointsGraphics.drawLine(points.xpoints[i - 1], points.ypoints[i - 1], points.xpoints[i - 1], points.ypoints[i - 1]);
                    }
                    ++i;
                }
            }
            if (this.showPointsOn && numPoints > 0) {
                pointsGraphics.drawLine(points.xpoints[numPoints - 1], points.ypoints[numPoints - 1], points.xpoints[numPoints - 1], points.ypoints[numPoints - 1]);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            g.dispose();
            throw throwable;
        }
        {
            Object var9_11 = null;
            g.dispose();
            return;
        }
    }

    public void update(Observable gesture, Object arg) {
        this.repaint();
    }

    public void setSelected(boolean on) {
        if (this.isSelected != on) {
            this.isSelected = on;
            this.repaint();
        }
    }

    public boolean getSelected() {
        return this.isSelected;
    }

    public boolean toggleSelected() {
        this.isSelected = !this.isSelected;
        this.repaint();
        return this.isSelected;
    }

    public void setOffset(int x, int y) {
        this.xoffset = x;
        this.yoffset = y;
        this.repaint();
    }

    public void setShowPoints(boolean on) {
        if (this.showPointsOn != on) {
            this.showPointsOn = on;
            this.repaint();
        }
    }

    public boolean getShowPoints() {
        return this.showPointsOn;
    }

    public boolean getShowSelected() {
        return this.showSelected;
    }

    public void setShowSelected(boolean on) {
        if (this.showSelected != on) {
            this.showSelected = on;
            if (this.isSelected) {
                this.repaint();
            }
        }
    }

    public void setNarrowed(boolean on) {
        if (this.narrowed != on) {
            this.narrowed = on;
            this.setBackground(this.narrowed ? Color.white : Color.lightGray);
            this.repaint();
        }
    }

    public void toggleNarrowed() {
        this.setNarrowed(!this.narrowed);
    }

    public void setAnimated(boolean on) {
        if (this.animate != on) {
            this.animate = on;
            if (on) {
                this.startAnimation();
            } else {
                this.stopAnimation();
            }
        }
    }

    public boolean isAnimated() {
        return this.animate;
    }

    void startAnimation() {
        this.timer = new Timer(5000, new AnimateStep());
        this.timer.setRepeats(true);
        this.timer.setCoalesce(false);
        this.timer.start();
    }

    void stopAnimation() {
        this.timer.stop();
    }

    class AnimateStep
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            int delay;
            GesturePointsDisplay gpd = GesturePointsDisplay.this;
            TimedPolygon polygon = gpd.gesture.getPoints();
            ++gpd.animatePoints;
            if (gpd.animatePoints == polygon.npoints - 1) {
                delay = 5000;
            } else {
                if (gpd.animatePoints >= polygon.npoints) {
                    gpd.animatePoints = 0;
                }
                delay = GesturePointsDisplay.this.validTimings ? (int)(polygon.times[gpd.animatePoints + 1] - polygon.times[gpd.animatePoints]) * 10 : 9;
                gpd.repaint();
            }
            gpd.timer.setDelay(delay);
        }
    }
}

