/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture;

import edu.berkeley.guir.lib.gesture.AbstractGestureContainer;
import edu.berkeley.guir.lib.gesture.GestureMetaSet;
import edu.berkeley.guir.lib.gesture.GestureSet;
import edu.berkeley.guir.lib.gesture.util.TokenReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;

public class GesturePackage
extends AbstractGestureContainer {
    protected GestureSet trainingSet = null;
    protected GestureMetaSet testSets = null;
    public static final String TEST_SET_ADDED = "test set added";
    private static final Class[] CHILD_TYPES;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.gesture.GestureMetaSet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("edu.berkeley.guir.lib.gesture.GestureSet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        CHILD_TYPES = classArray;
    }

    public GesturePackage() {
        this(new GestureSet());
        this.trainingSet.setName("Training");
    }

    public GesturePackage(GestureSet trainingSet) {
        this(trainingSet, new GestureMetaSet());
        this.testSets.setName("Test");
    }

    public GesturePackage(GestureSet trainingSet, GestureMetaSet testSets) {
        this.setTrainingSet(trainingSet);
        this.setTestSets(testSets);
    }

    public GestureSet getTrainingSet() {
        return this.trainingSet;
    }

    public void setTrainingSet(GestureSet gs) {
        if (this.trainingSet != null) {
            this.trainingSet.removeCollectionListener(this.collectionListener);
            this.trainingSet.removePropertyChangeListener(this.propChangeListener);
            this.trainingSet.setParent(null);
        }
        GestureSet oldSet = this.trainingSet;
        this.trainingSet = gs;
        if (this.trainingSet != null) {
            this.trainingSet.setParent(this);
            this.trainingSet.addCollectionListener(this.collectionListener);
            this.trainingSet.addPropertyChangeListener(this.propChangeListener);
        }
        this.fireCollectionEvent(2, gs, 0);
        this.propChangeSupport.firePropertyChange("children", oldSet, gs);
    }

    public GestureMetaSet getTestSets() {
        return this.testSets;
    }

    public void setTestSets(GestureMetaSet sets) {
        if (this.testSets != null) {
            this.testSets.removeCollectionListener(this.collectionListener);
            this.testSets.removePropertyChangeListener(this.propChangeListener);
            this.testSets.setParent(null);
        }
        GestureMetaSet oldValue = this.testSets;
        this.testSets = sets;
        if (this.testSets != null) {
            this.testSets.setParent(this);
            this.testSets.addCollectionListener(this.collectionListener);
            this.testSets.addPropertyChangeListener(this.propChangeListener);
        }
        this.fireCollectionEvent(2, sets, 1);
        this.propChangeSupport.firePropertyChange("children", oldValue, sets);
    }

    protected List getChildren() {
        Object[] a = new Object[]{this.trainingSet, this.testSets};
        return Arrays.asList(a);
    }

    public Class[] getChildTypes() {
        return CHILD_TYPES;
    }

    public void write(Writer writer) throws IOException {
        writer.write("name\t" + this.name + "\n");
        if (this.author != null) {
            writer.write("author\t" + this.author + "\n");
        }
        writer.write("training\n");
        this.trainingSet.write(writer);
        writer.write("test\n");
        this.testSets.write(writer);
        writer.write("endpackage\n");
    }

    public static GesturePackage read(Reader reader) throws IOException, ParseException {
        GesturePackage result = new GesturePackage();
        boolean done = false;
        TokenReader r = new TokenReader(reader);
        while (!done) {
            try {
                String token = r.readToken().intern();
                if (token == "name") {
                    result.name = r.readLine();
                    continue;
                }
                if (token == "author") {
                    result.author = r.readLine();
                    continue;
                }
                if (token == "training") {
                    result.setTrainingSet(GestureSet.read(r));
                    continue;
                }
                if (token == "test") {
                    result.setTestSets(GestureMetaSet.read(r));
                    continue;
                }
                if (token != "endpackage") continue;
                done = true;
            }
            catch (EOFException e) {
                done = true;
            }
        }
        if (result.name == null) {
            result.name = result.trainingSet.getName();
        }
        result.trainingSet.setName("Training Set");
        result.testSets.setName("Test Sets");
        return result;
    }
}

