/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture;

import edu.berkeley.guir.lib.gesture.AbstractGestureContainer;
import edu.berkeley.guir.lib.gesture.GestureSet;
import edu.berkeley.guir.lib.gesture.util.Misc;
import edu.berkeley.guir.lib.gesture.util.TokenReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.text.ParseException;
import java.util.List;
import java.util.Vector;

public class GestureMetaSet
extends AbstractGestureContainer
implements Serializable,
Cloneable {
    protected Vector sets = new Vector();
    private static final Class[] CHILD_TYPES;
    static /* synthetic */ Class class$0;

    static {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.gesture.GestureSet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        CHILD_TYPES = classArray;
    }

    public Class[] getChildTypes() {
        return CHILD_TYPES;
    }

    protected List getChildren() {
        return this.sets;
    }

    public Object clone() {
        GestureMetaSet result = (GestureMetaSet)super.clone();
        result.sets = (Vector)Misc.deepCopy(this.sets);
        result.fixParents();
        return result;
    }

    public void write(Writer writer) throws IOException {
        writer.write("name\t" + this.name + "\n");
        if (this.author != null) {
            writer.write("author\t" + this.author + "\n");
        }
        int i = 0;
        while (i < this.sets.size()) {
            GestureSet set = (GestureSet)this.sets.get(i);
            writer.write("set\n");
            set.write(writer);
            ++i;
        }
        writer.write("endmetaset\n");
    }

    public static GestureMetaSet read(Reader reader) throws IOException, ParseException {
        GestureMetaSet result = new GestureMetaSet();
        boolean done = false;
        TokenReader r = new TokenReader(reader);
        while (!done) {
            try {
                String token = r.readToken().intern();
                if (token == "name") {
                    result.name = r.readLine();
                    continue;
                }
                if (token == "author") {
                    result.author = r.readLine();
                    continue;
                }
                if (token == "set") {
                    GestureSet gs = GestureSet.read(r);
                    result.add(gs);
                    continue;
                }
                if (token != "endmetaset") continue;
                done = true;
            }
            catch (EOFException e) {
                done = true;
            }
        }
        return result;
    }
}

