/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture;

import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.GestureDisplay;
import edu.berkeley.guir.lib.gesture.GestureInteractor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GestureInteractorTest
extends JPanel
implements KeyListener {
    GestureDisplay gestureDisplay;
    GestureInteractor gi;
    int width = 200;
    int height = 200;
    Frame frame;

    public static void main(String[] args) {
        WindowAdapter l = new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        };
        JFrame frame = new JFrame("GITest");
        frame.addWindowListener(l);
        GestureInteractorTest me = new GestureInteractorTest(args, frame);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)me, "Center");
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        JMenuItem item = new JMenuItem("Quit");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        menu.add(item);
        menuBar.add(menu);
        frame.setJMenuBar(menuBar);
        frame.pack();
        frame.setVisible(true);
        me.requestFocus();
    }

    public GestureInteractorTest(String[] args, Frame f) {
        super(true);
        this.frame = f;
        this.addKeyListener(this);
        Box box = new Box(0);
        this.add((Component)box, "Center");
        JPanel panel = new JPanel(new BorderLayout());
        this.gi = new GestureInteractor();
        this.gi.setPreferredSize(new Dimension(this.width, this.height));
        this.gi.setBorder(BorderFactory.createEtchedBorder());
        panel.add((Component)this.gi, "Center");
        box.add(panel);
        this.gestureDisplay = new GestureDisplay();
        this.gestureDisplay.setPreferredSize(new Dimension(200, 200));
        this.gestureDisplay.setBorder(BorderFactory.createTitledBorder(null, "foo", 2, 1));
        box.add(this.gestureDisplay);
        this.gi.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                GestureInteractor interactor = (GestureInteractor)e.getSource();
                if (interactor != GestureInteractorTest.this.gi) {
                    System.err.println("interactor (" + interactor + ") != gi (" + GestureInteractorTest.this.gi + ")");
                }
                Gesture g = interactor.getGesture();
                GestureInteractorTest.this.gestureDisplay.setGesture(g);
            }
        });
    }

    private void resize(int delta) {
        this.width += delta;
        this.height += delta;
        System.err.println("new size is " + this.width + "x" + this.height);
        this.gi.setPreferredSize(new Dimension(this.width, this.height));
        this.gi.invalidate();
    }

    public void keyTyped(KeyEvent e) {
        switch (e.getKeyChar()) {
            case ' ': {
                this.resize(10);
                break;
            }
            case '\b': 
            case 'b': {
                this.resize(-10);
                break;
            }
            case 'c': {
                this.gi.setGesture(null);
                break;
            }
            case 'p': {
                Window w = (Window)this.getTopLevelAncestor();
                System.err.println("Packing...");
                w.pack();
                System.err.println("Done packing");
                break;
            }
            default: {
                System.err.println("Unknown char '" + e.getKeyChar() + "'");
            }
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }
}

