/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture;

import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.GesturePointsDisplay;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class GestureInteractor
extends GesturePointsDisplay
implements MouseListener,
MouseMotionListener {
    protected EventListenerList changeListenerList = new EventListenerList();
    protected ChangeEvent changeEvent = null;
    private boolean enabled = false;
    static /* synthetic */ Class class$0;

    public GestureInteractor() {
        this.initUI();
    }

    public GestureInteractor(Gesture g) {
        super(g);
        this.initUI();
    }

    private void initUI() {
        this.setEnabled(true);
    }

    public void setEnabled(boolean on) {
        if (this.enabled != on) {
            if (on) {
                this.addMouseListener(this);
                this.addMouseMotionListener(this);
                this.setBackground(Color.white);
                this.setForeground(Color.black);
            } else {
                this.removeMouseListener(this);
                this.removeMouseMotionListener(this);
                this.setBackground(Color.lightGray);
                this.setForeground(Color.black);
            }
            this.enabled = on;
        }
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    boolean mouse1only(MouseEvent e) {
        int mods = e.getModifiers();
        return mods == 0 || mods == 16;
    }

    public void mousePressed(MouseEvent e) {
        if (this.mouse1only(e)) {
            this.drag_start(e, null);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.mouse1only(e)) {
            this.drag_end(e, null);
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        if (this.mouse1only(e)) {
            this.drag_feedback(e, null);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public boolean drag_start(MouseEvent evt, Object user_info) {
        Gesture g = this.getGesture();
        if (g == null) {
            this.setGesture(new Gesture());
            g = this.getGesture();
        }
        g.clearPoints();
        this.drag_feedback(evt, user_info);
        return true;
    }

    public boolean drag_feedback(MouseEvent evt, Object user_info) {
        Insets insets = this.getInsets();
        int x = evt.getX() - insets.left;
        int y = evt.getY() - insets.top;
        this.getGesture().addPoint(x, y);
        return true;
    }

    public boolean drag_end(MouseEvent evt, Object user_info) {
        this.fireStateChange();
        return true;
    }

    public void addChangeListener(ChangeListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.swing.event.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.changeListenerList.add(clazz, l);
    }

    public void removeChangeListener(ChangeListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.swing.event.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.changeListenerList.remove(clazz, l);
    }

    protected void fireStateChange() {
        Object[] listeners = this.changeListenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            Object object = listeners[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("javax.swing.event.ChangeListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
            }
            i -= 2;
        }
    }
}

