/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture;

import edu.berkeley.guir.lib.gesture.AbstractGestureContainer;
import edu.berkeley.guir.lib.gesture.GestureCategory;
import edu.berkeley.guir.lib.gesture.util.CollectionAdapter;
import edu.berkeley.guir.lib.gesture.util.CollectionListener;
import edu.berkeley.guir.lib.gesture.util.Misc;
import edu.berkeley.guir.lib.gesture.util.TokenReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.text.ParseException;
import java.util.List;
import java.util.Observable;
import java.util.Vector;

public class GestureGroup
extends AbstractGestureContainer
implements Cloneable {
    Vector categories;
    protected CollectionListener listener = new MyCollectionListener();
    private static final Class[] CHILD_TYPES;
    static /* synthetic */ Class class$0;

    static {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.gesture.GestureCategory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        CHILD_TYPES = classArray;
    }

    public GestureGroup() {
        this(null);
    }

    public GestureGroup(String name) {
        this.setName(name);
        this.categories = new Vector();
    }

    public Vector getCategories() {
        return this.categories;
    }

    public void setCategories(Vector newCategories) {
        if (this.categories != newCategories) {
            Vector oldValue = this.categories;
            this.categories = newCategories;
            this.propChangeSupport.firePropertyChange("children", oldValue, this.categories);
            this.setChanged();
            this.notifyObservers(this.categories);
        }
    }

    protected List getChildren() {
        return this.categories;
    }

    public GestureCategory get(int i) {
        return (GestureCategory)this.categories.get(i);
    }

    public void addCategory(GestureCategory gc) {
        this.add(gc);
    }

    public void removeCategory(GestureCategory gc) {
        this.remove(gc);
    }

    public GestureCategory categoryAt(int i) {
        return (GestureCategory)this.categories.get(i);
    }

    public Class[] getChildTypes() {
        return CHILD_TYPES;
    }

    public void update(Observable gestureCategory, Object arg) {
        this.setChanged();
        this.notifyObservers(gestureCategory);
    }

    public void write(Writer writer) throws IOException {
        writer.write("name\t" + this.name + "\n");
        if (this.author != null) {
            writer.write("author\t" + this.author + "\n");
        }
        int i = 0;
        while (i < this.categories.size()) {
            writer.write("category\n");
            GestureCategory gc = this.categoryAt(i);
            gc.write(writer);
            ++i;
        }
        writer.write("endgroup\n");
    }

    public static GestureGroup read(Reader reader) throws IOException, ParseException {
        GestureGroup result = new GestureGroup();
        boolean done = false;
        TokenReader r = new TokenReader(reader);
        while (!done) {
            try {
                String token = r.readToken().intern();
                if (token == "name") {
                    result.name = r.readLine();
                    continue;
                }
                if (token == "author") {
                    result.author = r.readLine();
                    continue;
                }
                if (token == "category") {
                    GestureCategory gc = GestureCategory.read(r);
                    result.add(gc);
                    continue;
                }
                if (token != "endgroup") continue;
                done = true;
            }
            catch (EOFException e) {
                done = true;
            }
        }
        return result;
    }

    public Object clone() {
        GestureGroup gg = (GestureGroup)super.clone();
        gg.categories = (Vector)Misc.deepCopy(this.categories);
        gg.fixParents();
        return gg;
    }

    public String toString() {
        return this.getName();
    }

    protected class MyCollectionListener
    extends CollectionAdapter {
        protected MyCollectionListener() {
        }
    }
}

