/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture;

import edu.berkeley.guir.lib.gesture.AbstractGestureContainer;
import edu.berkeley.guir.lib.gesture.GestureCategory;
import edu.berkeley.guir.lib.gesture.GesturePackage;
import edu.berkeley.guir.lib.gesture.GestureSet;
import edu.berkeley.guir.lib.gesture.util.ExtensionFileFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.StreamCorruptedException;
import java.text.ParseException;
import javax.swing.filechooser.FileFilter;

public class GestureFile {
    public final String VERSION = "gdt 2.0";
    public final int UNKNOWN = -1;
    public final int ASCII = 0;
    public final int BINARY = 1;
    public final int PACKAGE = 2;
    protected GesturePackage gesturePackage;
    protected File file;
    protected int fileType = -1;
    protected boolean autoSaveWasRead = false;
    protected boolean useAutoSave = true;
    private static String[] validExtensions = new String[]{"gs", "gsa", "gp"};
    private static ExtensionFileFilter fileFilter = new ExtensionFileFilter(validExtensions, "Gesture files");

    public GestureFile(File f, GesturePackage gp) {
        this.file = f;
        this.gesturePackage = gp;
    }

    public GestureFile(File f) {
        this(f, null);
    }

    public void setGesturePackage(GesturePackage gp) {
        this.gesturePackage = gp;
    }

    public GesturePackage getGesturePackage() {
        return this.gesturePackage;
    }

    public void setUseAutosave(boolean useIt) {
        this.useAutoSave = useIt;
    }

    public boolean isUseAutosave() {
        return this.useAutoSave;
    }

    public void write() throws IOException {
        FileWriter writer = new FileWriter(this.file);
        writer.write("gdt 2.0\n");
        this.gesturePackage.write(writer);
    }

    public void writeAutoSave() throws IOException {
        FileWriter writer = new FileWriter(this.getAutoSaveFile());
        writer.write("gdt 2.0\n");
        this.gesturePackage.write(writer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void read() throws ClassNotFoundException, InvalidClassException, InvalidObjectException, IOException, FileNotFoundException, ParseException {
        File inputFile;
        boolean readBinaryFile = false;
        if (this.useAutoSave && this.doesNewerAutoSaveExist()) {
            inputFile = this.getAutoSaveFile();
            this.autoSaveWasRead = true;
        } else {
            inputFile = this.file;
            this.autoSaveWasRead = false;
        }
        AbstractGestureContainer gestureSet = null;
        if (!inputFile.exists()) {
            throw new FileNotFoundException();
        }
        try {
            ObjectInputStream p = new ObjectInputStream(new FileInputStream(inputFile));
            try {
                String v = (String)p.readObject();
                Object obj = p.readObject();
                if (obj instanceof GestureSet) {
                    gestureSet = (GestureSet)obj;
                } else {
                    if (!(obj instanceof GestureCategory)) {
                        throw new InvalidClassException("Unknown object type '" + obj.getClass().getName() + "'");
                    }
                    if (gestureSet == null) {
                        gestureSet = new GestureSet();
                    }
                    gestureSet.add((GestureCategory)obj);
                }
                readBinaryFile = true;
                this.fileType = 1;
                Object var7_17 = null;
            }
            catch (Throwable throwable) {
                Object var7_16 = null;
                p.close();
                throw throwable;
            }
            p.close();
        }
        catch (ClassNotFoundException e) {
            throw new ClassNotFoundException("Cannot find required class while reading file '" + inputFile + "': " + e);
        }
        catch (InvalidClassException e) {
            throw new InvalidClassException("Problem with a class while reading file '" + inputFile + "': " + e);
        }
        catch (StreamCorruptedException e) {
        }
        catch (ObjectStreamException e) {
            throw new InvalidObjectException("Expected an object but got primitive data while reading file '" + inputFile + "': " + e);
        }
        catch (IOException e) {
            throw new IOException("I/O error reading file '" + inputFile + "': " + e);
        }
        if (gestureSet == null) {
            FileReader reader = new FileReader(inputFile);
            BufferedReader br = new BufferedReader(reader);
            try {
                String v = br.readLine();
                if (this.canReadVersion(v)) {
                    this.gesturePackage = GesturePackage.read(br);
                    this.fileType = 2;
                } else {
                    FileReader setReader = new FileReader(inputFile);
                    try {
                        gestureSet = GestureSet.read(setReader);
                        this.fileType = 0;
                        Object var8_15 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_14 = null;
                        setReader.close();
                        throw throwable;
                    }
                    setReader.close();
                }
                Object var10_21 = null;
            }
            catch (Throwable throwable) {
                Object var10_20 = null;
                reader.close();
                throw throwable;
            }
            reader.close();
        }
        if (gestureSet != null) {
            this.gesturePackage = new GesturePackage((GestureSet)gestureSet);
            String packageName = gestureSet.getName();
            if (packageName == null) {
                String noDirectory = inputFile.getName();
                int extIndex = noDirectory.lastIndexOf(46);
                packageName = noDirectory.substring(0, extIndex);
            }
            this.gesturePackage.setName(packageName);
            gestureSet.setName("Training");
            this.gesturePackage.getTestSets().setName("Test");
        }
    }

    public boolean canReadVersion(String versionString) {
        return "gdt 2.0".equals(versionString);
    }

    public static File getAutoSaveFile(File f) {
        return new File(f.getParent(), "#" + f.getName() + "#");
    }

    public File getAutoSaveFile() {
        return GestureFile.getAutoSaveFile(this.file);
    }

    public boolean doesAutoSaveExist() {
        return this.getAutoSaveFile().exists();
    }

    public boolean doesNewerAutoSaveExist() {
        File asFile = this.getAutoSaveFile();
        return asFile.exists() && asFile.lastModified() > this.file.lastModified();
    }

    public File getFile() {
        return this.file;
    }

    public boolean wasAutoSaveRead() {
        return this.autoSaveWasRead;
    }

    public static FileFilter getFileFilter() {
        return fileFilter;
    }

    public class UnsupportedVersionException
    extends IOException {
        public UnsupportedVersionException() {
        }

        public UnsupportedVersionException(String details) {
            super(details);
        }
    }
}

