/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture;

import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.GesturePointsDisplay;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class GestureDisplay
extends JPanel
implements Observer {
    static final DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
    Gesture gesture;
    GesturePointsDisplay gpDisplay;
    JTextField authorField;
    JLabel creationDateLabel;
    Box infoPanel;
    boolean authorVisible = false;
    static Class displayClass;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.gesture.GesturePointsDisplay");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        displayClass = clazz;
    }

    public GestureDisplay() {
        this((Gesture)null);
    }

    public GestureDisplay(Gesture g) {
        this(g, 0, 0);
    }

    public GestureDisplay(Gesture g, JScrollPane scrollPane) {
        this(g);
    }

    public GestureDisplay(Gesture g, int xoffset, int yoffset) {
        this.gesture = g;
        try {
            this.gpDisplay = (GesturePointsDisplay)displayClass.newInstance();
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        this.gpDisplay.setGesture(g);
        this.gpDisplay.setOffset(xoffset, yoffset);
        this.buildUI();
    }

    public Gesture getGesture() {
        return this.gesture;
    }

    public void setGesture(Gesture g) {
        this.gesture = g;
        this.gpDisplay.setGesture(g);
        this.updateProperties();
    }

    public void update(Observable gesture, Object arg) {
        if (arg != null) {
            this.updateProperties();
        }
    }

    protected void buildUI() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.gpDisplay, "Center");
        this.infoPanel = new Box(1);
        this.authorField = new JTextField();
        this.authorField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GestureDisplay.this.gesture.setAuthor(GestureDisplay.this.authorField.getText());
            }
        });
        this.infoPanel.add(this.authorField);
        this.creationDateLabel = new JLabel();
        this.infoPanel.add(this.creationDateLabel);
        if (this.authorVisible) {
            this.add((Component)this.infoPanel, "South");
        }
        this.setBackground(Color.white);
        this.updateProperties();
    }

    protected void rebuildUI() {
        this.removeAll();
        this.buildUI();
    }

    protected void updateProperties() {
        if (this.gesture != null) {
            String author = this.gesture.getAuthor();
            this.authorField.setText(author == null ? "(unknown author)" : author);
            Date date = this.gesture.getCreationDate();
            String dateText = date == null ? "(unknown date)" : dateFormat.format(date);
            this.creationDateLabel.setText(dateText);
            this.repaint();
        }
    }

    public void setSelected(boolean on) {
        this.gpDisplay.setSelected(on);
    }

    public boolean getSelected() {
        return this.gpDisplay.getSelected();
    }

    public boolean toggleSelected() {
        return this.gpDisplay.toggleSelected();
    }

    public void setShowPoints(boolean on) {
        this.gpDisplay.setShowPoints(on);
    }

    public boolean getShowPoints() {
        return this.gpDisplay.getShowPoints();
    }

    public boolean getShowSelected() {
        return this.gpDisplay.getShowSelected();
    }

    public void setOffset(int x, int y) {
        this.gpDisplay.setOffset(x, y);
    }

    public void setShowSelected(boolean on) {
        this.gpDisplay.setShowSelected(on);
    }

    public void setNarrowed(boolean on) {
        this.gpDisplay.setNarrowed(on);
    }

    public void toggleNarrowed() {
        this.gpDisplay.toggleNarrowed();
    }

    public void setAuthorVisible(boolean on) {
        if (this.authorVisible != on) {
            this.authorVisible = on;
            if (on) {
                this.add((Component)this.infoPanel, "South");
            } else {
                this.remove(this.infoPanel);
            }
            this.validate();
        }
    }

    public GesturePointsDisplay getGesturePointsDisplay() {
        return this.gpDisplay;
    }

    public static void setPointsDisplayClass(Class displayClass) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.gesture.GesturePointsDisplay");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz.isAssignableFrom(displayClass)) {
            throw new IllegalArgumentException("displayClass must be a GesturePointsDisplay");
        }
        if (GestureDisplay.displayClass != displayClass) {
            GestureDisplay.displayClass = displayClass;
        }
    }
}

