/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture;

import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.GestureCategory;
import edu.berkeley.guir.lib.gesture.GestureCategoryFrame;
import edu.berkeley.guir.lib.gesture.GestureDisplay;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Window;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class GestureCategoryThumbnail
extends JPanel
implements Observer {
    protected EventListenerList changeListenerList = new EventListenerList();
    protected ChangeEvent changeEvent = null;
    GestureCategory gestureCategory;
    GestureCategoryFrame gestureCategoryFrame;
    GestureDisplay thumbnail = new GestureDisplay();
    boolean experimentMode = false;
    boolean authorVisible = false;
    static /* synthetic */ Class class$0;

    public GestureCategoryThumbnail() {
        this.thumbnail.setOffset(10, 10);
        this.thumbnail.setShowSelected(false);
        this.setLayout(new BorderLayout());
        this.setBackground(Color.white);
        this.add((Component)this.thumbnail, "Center");
    }

    public GestureCategoryThumbnail(GestureCategory gc) {
        this(gc, false, false);
    }

    public GestureCategoryThumbnail(GestureCategory gc, JScrollPane scrollPane) {
        this(gc);
    }

    public GestureCategoryThumbnail(GestureCategory gc, boolean experimenting, boolean authorVisible) {
        this();
        this.authorVisible = authorVisible;
        this.thumbnail.setAuthorVisible(authorVisible);
        this.experimentMode = experimenting;
        this.setGestureCategory(gc);
    }

    public void setGestureCategory(GestureCategory gc) {
        if (this.gestureCategory != null) {
            this.gestureCategory.deleteObserver(this);
        }
        this.gestureCategory = gc;
        if (this.gestureCategoryFrame != null) {
            this.gestureCategoryFrame.setGestureCategory(gc);
        }
        if (gc != null) {
            gc.addObserver(this);
        }
        this.rebuildUI();
    }

    public GestureCategory getGestureCategory() {
        return this.gestureCategory;
    }

    private void rebuildUI() {
        String name = this.gestureCategory.getName();
        if (name == null) {
            name = "(unnamed)";
        }
        this.thumbnail.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), name, 2, 1));
        Gesture gesture = this.gestureCategory.size() > 0 ? this.gestureCategory.gestureAt(0) : null;
        this.thumbnail.setGesture(gesture);
        this.thumbnail.invalidate();
        this.thumbnail.setSize(this.thumbnail.getMinimumSize());
        this.invalidate();
        Window w = (Window)this.getTopLevelAncestor();
        if (w != null) {
            w.pack();
        }
        this.fireStateChange();
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.thumbnail.getSelected()) {
            Dimension size = this.getSize();
            g.setColor(Color.red);
            g.drawRect(0, 0, size.width - 1, size.height - 1);
        }
    }

    public void update(Observable gestureCategory, Object arg) {
        Gesture gesture = this.thumbnail.getGesture();
        if (gesture == null || arg == null || arg instanceof String || arg instanceof GestureCategory) {
            this.rebuildUI();
        }
    }

    public boolean toggleSelected() {
        boolean result = this.thumbnail.toggleSelected();
        this.repaint();
        return result;
    }

    public void setSelected(boolean value) {
        if (value != this.thumbnail.getSelected()) {
            this.repaint();
        }
        this.thumbnail.setSelected(value);
    }

    public GestureCategoryFrame showCategoryFrame() {
        this.createCategoryFrame();
        this.gestureCategoryFrame.show();
        return this.gestureCategoryFrame;
    }

    public GestureCategoryFrame createCategoryFrame() {
        if (this.gestureCategoryFrame == null) {
            this.gestureCategoryFrame = new GestureCategoryFrame(this.gestureCategory, this.experimentMode, this.authorVisible);
            this.gestureCategoryFrame.pack();
        }
        return this.gestureCategoryFrame;
    }

    public GestureCategoryFrame getCategoryFrame() {
        return this.gestureCategoryFrame;
    }

    public void addChangeListener(ChangeListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.swing.event.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.changeListenerList.add(clazz, l);
    }

    public void removeChangeListener(ChangeListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.swing.event.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.changeListenerList.remove(clazz, l);
    }

    protected void fireStateChange() {
        Object[] listeners = this.changeListenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            Object object = listeners[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("javax.swing.event.ChangeListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
            }
            i -= 2;
        }
    }

    public void setAuthorVisible(boolean on) {
        if (on != this.authorVisible) {
            this.authorVisible = on;
            this.thumbnail.setAuthorVisible(on);
        }
    }
}

