/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture;

import edu.berkeley.guir.lib.gesture.FeatureFrame;
import edu.berkeley.guir.lib.gesture.FeatureVector;
import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.GestureCategory;
import edu.berkeley.guir.lib.gesture.GestureCategoryDisplay;
import edu.berkeley.guir.lib.gesture.GestureDisplay;
import edu.berkeley.guir.lib.gesture.GestureInteractor;
import edu.berkeley.guir.lib.gesture.StarPlotFrame;
import edu.berkeley.guir.lib.gesture.util.HystericResizer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

public class GestureCategoryFrame
extends JFrame
implements Observer,
ItemListener {
    private JLabel statusWindow;
    private GestureInteractor drawingArea;
    private GestureCategoryDisplay gestureCategoryDisplay;
    private JScrollPane scrollPane;
    private JLabel exampleCounter;
    JMenuItem deleteMenuItem;
    JMenuItem cutMenuItem;
    JMenuItem copyMenuItem;
    JMenuItem pasteMenuItem;
    Gesture clipboard;
    boolean experimentMode = false;
    boolean authorVisible = false;
    final String version = "gdt 1.0";

    public GestureCategoryFrame() {
        this(new GestureCategory());
    }

    public GestureCategoryFrame(GestureCategory gc) {
        this(gc, false, true);
    }

    public GestureCategoryFrame(GestureCategory gc, boolean experimenting, boolean showAuthor) {
        this.experimentMode = experimenting;
        this.authorVisible = showAuthor;
        this.setGestureCategoryInternal(gc);
        this.buildUI(gc);
    }

    public void setGestureCategory(GestureCategory gc) {
        this.setGestureCategoryInternal(gc);
        this.gestureCategoryDisplay.setGestureCategory(gc);
    }

    private void setGestureCategoryInternal(GestureCategory gestureCategory) {
        if (gestureCategory != null) {
            gestureCategory.deleteObserver(this);
        }
        if (gestureCategory != null) {
            gestureCategory.addObserver(this);
        }
        this.resetName(gestureCategory);
    }

    private void resetName(GestureCategory gestureCategory) {
        String name = gestureCategory.getName() == null ? "(unnamed)" : gestureCategory.getName();
        this.setTitle("gdt: " + name);
    }

    public GestureCategoryDisplay getGestureCategoryDisplay() {
        return this.gestureCategoryDisplay;
    }

    protected void buildUI(GestureCategory gestureCategory) {
        JSplitPane splitPane = new JSplitPane(0);
        JMenuBar menuBar = this.constructMenuBar();
        this.setJMenuBar(menuBar);
        this.gestureCategoryDisplay = new GestureCategoryDisplay(gestureCategory, this.authorVisible);
        this.gestureCategoryDisplay.setBorder(BorderFactory.createEtchedBorder());
        this.gestureCategoryDisplay.addItemListener(this);
        this.scrollPane = new JScrollPane(this.gestureCategoryDisplay);
        this.scrollPane.setPreferredSize(new Dimension(200, 200));
        this.scrollPane.setMinimumSize(new Dimension(100, 100));
        this.gestureCategoryDisplay.setScroller(this.scrollPane);
        JTextField nameField = new JTextField(gestureCategory.getName());
        DocumentListener nameChangeListener = new DocumentListener(){

            public void update(DocumentEvent e) {
                try {
                    GestureCategoryFrame.this.getGestureCategoryDisplay().getGestureCategory().setName(e.getDocument().getText(0, e.getDocument().getLength()));
                }
                catch (BadLocationException exception) {
                    System.err.println("gdt bogosity: got exception: " + exception);
                }
            }

            public void insertUpdate(DocumentEvent e) {
                this.update(e);
            }

            public void removeUpdate(DocumentEvent e) {
                this.update(e);
            }

            public void changedUpdate(DocumentEvent e) {
                this.update(e);
            }
        };
        nameField.getDocument().addDocumentListener(nameChangeListener);
        JPanel namePanel = new JPanel(new BorderLayout());
        JLabel nameLabel = new JLabel("Name");
        namePanel.add((Component)nameLabel, "West");
        namePanel.add((Component)nameField, "Center");
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)namePanel, "North");
        topPanel.add((Component)this.scrollPane, "Center");
        splitPane.setTopComponent(topPanel);
        JPanel extras = new JPanel();
        extras.setDoubleBuffered(true);
        extras.setLayout(new BorderLayout(5, 5));
        this.drawingArea = new GestureInteractor();
        this.drawingArea.addChangeListener(new ChangeListener(){
            JScrollPane sp;
            {
                this.sp = GestureCategoryFrame.this.scrollPane;
            }

            public void stateChanged(ChangeEvent e) {
                GestureInteractor interactor = (GestureInteractor)e.getSource();
                Gesture g = interactor.getGesture();
                Gesture copy = new Gesture(g);
                GestureCategory gc = GestureCategoryFrame.this.gestureCategoryDisplay.getGestureCategory();
                copy.setAuthor(gc.getAuthor());
                copy.normalize();
                gc.addGesture(copy);
                Component gestureDisplay = GestureCategoryFrame.this.gestureCategoryDisplay.getComponent(GestureCategoryFrame.this.gestureCategoryDisplay.getComponentCount() - 1);
                GestureCategoryFrame.this.scrollPane.getViewport().scrollRectToVisible(gestureDisplay.getBounds());
            }
        });
        this.drawingArea.setMinimumSize(new Dimension(200, 200));
        this.drawingArea.setSize(new Dimension(200, 200));
        this.drawingArea.setBorder(BorderFactory.createLoweredBevelBorder());
        JLabel drawingLabel = new JLabel("Draw new examples below");
        drawingLabel.setHorizontalAlignment(4);
        this.exampleCounter = new JLabel();
        this.exampleCounter.setBorder(BorderFactory.createEtchedBorder());
        this.updateExampleCounter();
        Box infoPanel = new Box(0);
        infoPanel.add(this.exampleCounter);
        infoPanel.add(Box.createHorizontalGlue());
        infoPanel.add(drawingLabel);
        extras.add((Component)this.drawingArea, "Center");
        extras.add((Component)infoPanel, "North");
        splitPane.setBottomComponent(extras);
        HystericResizer hr = new HystericResizer();
        this.getRootPane().addComponentListener(hr);
        this.getContentPane().add(splitPane);
    }

    protected JMenuBar constructMenuBar() {
        JMenuBar mb = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        if (!this.experimentMode) {
            JMenuItem openItem = new JMenuItem("Open");
            ActionListener openListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FileDialog fileChooser = new FileDialog((Frame)GestureCategoryFrame.this.scrollPane.getTopLevelAncestor(), "Open", 0);
                    fileChooser.setFilenameFilter(new myFilenameFilter());
                    fileChooser.show();
                    String baseName = fileChooser.getFile();
                    if (baseName != null) {
                        File f = new File(fileChooser.getDirectory(), baseName);
                        GestureCategoryFrame.this.openFile(f);
                    }
                }
            };
            openItem.addActionListener(openListener);
            fileMenu.add(openItem);
            JMenuItem saveItem = new JMenuItem("Save");
            ActionListener saveListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FileDialog fileChooser = new FileDialog((Frame)GestureCategoryFrame.this.scrollPane.getTopLevelAncestor(), "Save", 1);
                    fileChooser.setFilenameFilter(new myFilenameFilter());
                    fileChooser.show();
                    String baseName = fileChooser.getFile();
                    if (baseName != null) {
                        File f = new File(fileChooser.getDirectory(), baseName);
                        try {
                            FileOutputStream ostream = new FileOutputStream(f);
                            ObjectOutputStream objStream = new ObjectOutputStream(ostream);
                            objStream.writeObject("gdt 1.0");
                            objStream.writeObject(GestureCategoryFrame.this.gestureCategoryDisplay.getGestureCategory());
                            objStream.flush();
                            ostream.close();
                        }
                        catch (IOException exception) {
                            System.err.println("Error saving file " + f + ": " + exception);
                        }
                    } else {
                        GestureCategoryFrame.this.message("Save cancelled");
                    }
                }
            };
            saveItem.addActionListener(saveListener);
            fileMenu.add(saveItem);
        }
        JMenuItem item = new JMenuItem("Rename");
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JDialog dialog = new JDialog((Frame)GestureCategoryFrame.this, "Rename class");
                JTextField text = new JTextField("");
                dialog.getContentPane().add((Component)text, "Center");
                JButton closeButton = new JButton("Ok");
                ActionListener l = new ActionListener(this, text, dialog){
                    final /* synthetic */ 5 this$1;
                    private final /* synthetic */ JTextField val$text;
                    private final /* synthetic */ JDialog val$dialog;
                    {
                        this.this$1 = var1_1;
                        this.val$text = jTextField;
                        this.val$dialog = jDialog;
                    }

                    public void actionPerformed(ActionEvent e2) {
                        GestureCategoryFrame frame = 5.access$0(this.this$1);
                        frame.getGestureCategoryDisplay().getGestureCategory().setName(this.val$text.getText());
                        this.val$dialog.dispose();
                    }
                };
                closeButton.addActionListener(l);
                dialog.getContentPane().add((Component)closeButton, "South");
                dialog.pack();
                dialog.show();
            }

            static /* synthetic */ GestureCategoryFrame access$0(5 var0) {
                return var0.GestureCategoryFrame.this;
            }
        };
        item.addActionListener(listener);
        fileMenu.add(item);
        JMenuItem close = new JMenuItem("Close");
        ActionListener closeListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GestureCategoryFrame.this.setVisible(false);
            }
        };
        close.addActionListener(closeListener);
        fileMenu.add(close);
        mb.add(fileMenu);
        JMenu menu = new JMenu("Edit");
        this.deleteMenuItem = new JMenuItem("Delete");
        ActionListener deleteListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GestureCategoryFrame.this.deleteSelection();
            }
        };
        this.deleteMenuItem.addActionListener(deleteListener);
        this.deleteMenuItem.setEnabled(false);
        menu.add(this.deleteMenuItem);
        this.cutMenuItem = item = new JMenuItem("Cut");
        listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GestureCategoryFrame.this.setClipboard();
                GestureCategoryFrame.this.deleteSelection();
            }
        };
        item.addActionListener(listener);
        item.setEnabled(false);
        menu.add(item);
        this.copyMenuItem = item = new JMenuItem("Copy");
        listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GestureCategoryFrame.this.copyClipboard();
            }
        };
        item.addActionListener(listener);
        item.setEnabled(false);
        menu.add(item);
        this.pasteMenuItem = item = new JMenuItem("Paste");
        listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GestureCategoryFrame.this.gestureCategoryDisplay.getGestureCategory().addGesture((Gesture)GestureCategoryFrame.this.getClipboard().clone());
            }
        };
        item.addActionListener(listener);
        item.setEnabled(false);
        menu.add(item);
        mb.add(menu);
        JMenu viewMenu = new JMenu("View");
        JMenuItem featureItem = new JMenuItem("Features");
        ActionListener featureListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Gesture selection = GestureCategoryFrame.this.gestureCategoryDisplay.getSelection();
                if (selection != null) {
                    new FeatureFrame(selection);
                }
            }
        };
        featureItem.addActionListener(featureListener);
        viewMenu.add(featureItem);
        JMenuItem pointsItem = new JMenuItem("Toggle points");
        ActionListener pointsListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GestureDisplay gestureDisplay = GestureCategoryFrame.this.gestureCategoryDisplay.getSelectionDisplay();
                if (gestureDisplay != null) {
                    gestureDisplay.setShowPoints(!gestureDisplay.getShowPoints());
                }
            }
        };
        pointsItem.addActionListener(pointsListener);
        viewMenu.add(pointsItem);
        if (!this.experimentMode) {
            item = new JMenuItem("Star plot");
            listener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Gesture selection = GestureCategoryFrame.this.gestureCategoryDisplay.getSelection();
                    if (selection != null) {
                        StarPlotFrame spf = new StarPlotFrame(new FeatureVector(selection), "Star plot");
                        spf.pack();
                        spf.show();
                    }
                }
            };
            item.addActionListener(listener);
            viewMenu.add(item);
            item = new JMenuItem("Toggle narrowing");
            listener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GestureDisplay gestureDisplay = GestureCategoryFrame.this.gestureCategoryDisplay.getSelectionDisplay();
                    if (gestureDisplay != null) {
                        gestureDisplay.toggleNarrowed();
                    }
                }
            };
            item.addActionListener(listener);
            viewMenu.add(item);
        }
        mb.add(viewMenu);
        if (!this.experimentMode) {
            menu = new JMenu("Debug");
            item = new JMenuItem("Pack");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GestureCategoryFrame.this.invalidate();
                    GestureCategoryFrame.this.validate();
                    GestureCategoryFrame.this.pack();
                }
            });
            menu.add(item);
            item = new JMenuItem("Rebuild GCD");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GestureCategoryFrame.this.gestureCategoryDisplay.rebuildUI();
                }
            });
            menu.add(item);
            item = new JMenuItem("Timing");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Gesture selection = GestureCategoryFrame.this.gestureCategoryDisplay.getSelection();
                    if (selection != null) {
                        selection.printTiming(System.out);
                    }
                }
            });
            menu.add(item);
            mb.add(menu);
        }
        return mb;
    }

    public void message(String msg) {
        this.statusWindow.setText(msg);
    }

    void openFile(File f) {
        try {
            ObjectInputStream p = new ObjectInputStream(new FileInputStream(f));
            String v = (String)p.readObject();
            if (!"gdt 1.0".equals(v)) {
                System.err.println("Error while reading file '" + f + "': expected version '" + "gdt 1.0" + "' but got version '" + v + "'");
            }
            this.gestureCategoryDisplay.getGestureCategory().replace((GestureCategory)p.readObject());
            p.close();
            this.setTitle(f.getName());
        }
        catch (ClassNotFoundException e) {
            System.err.println("Cannot find required class while reading file '" + f + "': " + e);
        }
        catch (InvalidClassException e) {
            System.err.println("Problem with a class while reading file '" + f + "': " + e);
        }
        catch (StreamCorruptedException e) {
            System.err.println("File '" + f + "' is corrupted: " + e);
        }
        catch (OptionalDataException e) {
            System.err.println("Expected an object but got primitive data while reading file '" + f + "': " + e);
        }
        catch (IOException ioexception) {
            System.err.println("I/O error reading file '" + f + "': " + ioexception);
        }
    }

    public void update(Observable o, Object arg) {
        if (o != null && o instanceof GestureCategory) {
            if (arg != null && arg instanceof String) {
                this.resetName((GestureCategory)o);
            } else {
                this.updateExampleCounter();
                this.drawingArea.setGesture(null);
            }
        }
    }

    private void updateExampleCounter() {
        this.exampleCounter.setText(String.valueOf(this.gestureCategoryDisplay.getGestureCategory().size()) + " examples");
    }

    void setClipboard() {
        this.clipboard = this.gestureCategoryDisplay.getSelection();
        this.pasteMenuItem.setEnabled(true);
    }

    void copyClipboard() {
        this.clipboard = (Gesture)this.gestureCategoryDisplay.getSelection().clone();
        this.pasteMenuItem.setEnabled(true);
    }

    Gesture getClipboard() {
        return this.clipboard;
    }

    void deleteSelection() {
        this.gestureCategoryDisplay.getGestureCategory().removeGesture(this.gestureCategoryDisplay.getSelection());
        this.deleteMenuItem.setEnabled(false);
        this.cutMenuItem.setEnabled(false);
        this.copyMenuItem.setEnabled(false);
    }

    public void itemStateChanged(ItemEvent e) {
        int state = e.getStateChange();
        if (state == 1) {
            this.deleteMenuItem.setEnabled(true);
            this.cutMenuItem.setEnabled(true);
            this.copyMenuItem.setEnabled(true);
        } else if (state == 2) {
            this.deleteMenuItem.setEnabled(false);
            this.cutMenuItem.setEnabled(false);
            this.copyMenuItem.setEnabled(false);
        } else {
            System.err.println("GestureSetFrame: Unknown item state " + state);
        }
    }

    public static void main(String[] args) {
        GestureCategoryFrame frame = new GestureCategoryFrame();
        frame.pack();
        frame.show();
    }

    class myFilenameFilter
    implements FilenameFilter {
        myFilenameFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(".gc");
        }
    }
}

