/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture;

import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.GestureCategory;
import edu.berkeley.guir.lib.gesture.GestureDisplay;
import edu.berkeley.guir.lib.gesture.util.FlowScrollPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;

public class GestureCategoryDisplay
extends FlowScrollPanel
implements Observer,
ItemSelectable {
    private GestureCategory gestureCategory;
    private GestureDisplay selectedGestureDisplay;
    protected EventListenerList itemListenerList = new EventListenerList();
    int maxChildHeight = 0;
    boolean authorVisible = false;
    static /* synthetic */ Class class$0;

    public GestureCategoryDisplay() {
        this((GestureCategory)null, true);
    }

    public GestureCategoryDisplay(GestureCategory gc) {
        this(gc, false);
    }

    public GestureCategoryDisplay(GestureCategory gc, boolean showAuthor) {
        this.authorVisible = showAuthor;
        this.initUI();
        this.setGestureCategory(gc);
    }

    public void setGestureCategory(GestureCategory gc) {
        if (this.gestureCategory != null) {
            this.gestureCategory.deleteObserver(this);
        }
        this.gestureCategory = gc;
        if (gc != null) {
            gc.addObserver(this);
        }
        this.rebuildUI();
    }

    public GestureCategory getGestureCategory() {
        return this.gestureCategory;
    }

    public void update(Observable o, Object arg) {
        if (arg != null) {
            if (arg instanceof Gesture) {
                GestureCategory gc = (GestureCategory)o;
                Gesture gesture = (Gesture)arg;
                this.addGesture(gesture);
            } else if (!(arg instanceof String)) {
                this.rebuildUI();
            }
        } else {
            this.rebuildUI();
        }
    }

    public GestureDisplay addGesture(Gesture gesture) {
        GestureDisplay gestureDisplay = new GestureDisplay(gesture, 10, 10);
        gestureDisplay.setAuthorVisible(this.authorVisible);
        gestureDisplay.setBorder(BorderFactory.createEtchedBorder());
        int newHeight = gestureDisplay.getMinimumSize().height;
        if (newHeight > this.maxChildHeight) {
            Component[] components = this.getComponents();
            int i = 0;
            while (i < components.length) {
                JComponent c = (JComponent)components[i];
                int oldWidth = c.getPreferredSize().width;
                c.setPreferredSize(new Dimension(oldWidth, newHeight));
                ++i;
            }
            this.maxChildHeight = newHeight;
        } else if (newHeight < this.maxChildHeight) {
            gestureDisplay.setPreferredSize(new Dimension(gestureDisplay.getMinimumSize().width, this.maxChildHeight));
        }
        this.add(gestureDisplay);
        this.revalidate();
        Window w = (Window)this.getTopLevelAncestor();
        if (w != null) {
            w.pack();
        }
        return gestureDisplay;
    }

    protected void initUI() {
        this.setMinimumSize(new Dimension(10, 10));
        this.addMouseListener(new MouseHandler());
        ((FlowLayout)this.getLayout()).setHgap(0);
    }

    static boolean mouse1(MouseEvent e) {
        int mods = e.getModifiers();
        return mods == 0 || (mods & 0x10) != 0;
    }

    public void rebuildUI() {
        this.removeAll();
        this.maxChildHeight = 0;
        Iterator iter = this.gestureCategory.iterator();
        while (iter.hasNext()) {
            Gesture gesture = (Gesture)iter.next();
            this.gestureCategory.add(gesture);
        }
    }

    public boolean isOpaque() {
        return false;
    }

    public GestureDisplay getSelectionDisplay() {
        return this.selectedGestureDisplay;
    }

    public Gesture getSelection() {
        return this.selectedGestureDisplay == null ? null : this.selectedGestureDisplay.getGesture();
    }

    public Object[] getSelectedObjects() {
        Gesture selection = this.getSelection();
        Object[] result = new Object[]{selection};
        if (selection == null) {
            result = null;
        }
        return result;
    }

    public boolean isOptimizedDrawingEnabled() {
        return true;
    }

    public void narrow(Vector gestures, String reason) {
        Component[] components = this.getComponents();
        int i = 0;
        while (i < components.length) {
            GestureDisplay gestureDisplay = (GestureDisplay)components[i];
            boolean narrow = gestures.contains(gestureDisplay.getGesture());
            gestureDisplay.setNarrowed(narrow);
            ++i;
        }
    }

    public void addItemListener(ItemListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.awt.event.ItemListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.itemListenerList.add(clazz, l);
    }

    public void removeItemListener(ItemListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.awt.event.ItemListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.itemListenerList.remove(clazz, l);
    }

    protected void fireItemChange(int type, Gesture item, int selectState) {
        ItemEvent event = null;
        Object[] listeners = this.itemListenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            Object object = listeners[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("java.awt.event.ItemListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                if (event == null) {
                    event = new ItemEvent(this, type, item, selectState);
                }
                ((ItemListener)listeners[i + 1]).itemStateChanged(event);
            }
            i -= 2;
        }
    }

    public void setAuthorVisible(boolean on) {
        if (this.authorVisible != on) {
            this.authorVisible = on;
            Component[] components = this.getComponents();
            int i = 0;
            while (i < components.length) {
                GestureDisplay gestureDisplay = (GestureDisplay)components[i];
                gestureDisplay.setAuthorVisible(on);
                ++i;
            }
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        public void mousePressed(MouseEvent e) {
            Point p = new Point(e.getPoint());
            Component component = GestureCategoryDisplay.this.getComponentAt(p);
            if (component != null && component instanceof GestureDisplay) {
                GestureDisplay newSelection = (GestureDisplay)component;
                GestureDisplay oldSelection = GestureCategoryDisplay.this.selectedGestureDisplay;
                if (newSelection.toggleSelected()) {
                    if (GestureCategoryDisplay.this.selectedGestureDisplay != null) {
                        GestureCategoryDisplay.this.selectedGestureDisplay.setSelected(false);
                    }
                    GestureCategoryDisplay.this.selectedGestureDisplay = newSelection;
                } else {
                    GestureCategoryDisplay.this.selectedGestureDisplay = null;
                }
                if (oldSelection != null) {
                    GestureCategoryDisplay.this.fireItemChange(701, oldSelection.getGesture(), 2);
                }
                if (GestureCategoryDisplay.this.selectedGestureDisplay != null) {
                    GestureCategoryDisplay.this.fireItemChange(701, GestureCategoryDisplay.this.selectedGestureDisplay.getGesture(), 1);
                }
            }
        }
    }
}

