/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture;

import edu.berkeley.guir.lib.gesture.AbstractGestureContainer;
import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.GestureObject;
import edu.berkeley.guir.lib.gesture.util.Misc;
import edu.berkeley.guir.lib.gesture.util.TokenReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

public class GestureCategory
extends AbstractGestureContainer
implements Serializable,
Observer,
Cloneable {
    static int nameCounter = 1;
    static final long serialVersionUID = -1317677446709873144L;
    protected Vector gestures;
    protected boolean directionInvariant;
    protected boolean orientationInvariant;
    protected boolean sizeInvariant;
    private static final Class[] CHILD_TYPES;
    static /* synthetic */ Class class$0;

    static {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.gesture.Gesture");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        CHILD_TYPES = classArray;
    }

    public GestureCategory() {
        this(null);
    }

    public GestureCategory(String name) {
        this(new Vector(), name);
    }

    public GestureCategory(Vector gestureVector, String name) {
        if (name == null) {
            name = "unnamed" + Integer.toString(nameCounter);
            ++nameCounter;
        }
        this.name = name;
        this.gestures = gestureVector;
    }

    protected List getChildren() {
        return this.gestures;
    }

    public void addGesture(Gesture g) {
        this.add(g);
    }

    public Gesture gestureAt(int i) {
        return (Gesture)this.gestures.elementAt(i);
    }

    public int getGestureIndex(Gesture target) {
        return this.indexOf(target);
    }

    public void removeGesture(Gesture g) {
        this.remove(g);
    }

    public void replace(GestureCategory gc) {
        GestureObject[] oldValue = this.gestures == null ? null : (Gesture[])this.gestures.toArray();
        this.gestures = gc.gestures != null ? (Vector)gc.gestures.clone() : null;
        this.name = gc.name != null ? new String(gc.name) : null;
        this.setChanged();
        this.notifyObservers(gc);
        if (oldValue != null) {
            this.fireCollectionEvent(1, oldValue, 0);
        }
        if (this.gestures != null) {
            this.fireCollectionEvent(0, (Gesture[])this.gestures.toArray(), 0);
        }
    }

    public void update(Observable gesture, Object arg) {
        this.setChanged();
        this.notifyObservers(gesture);
    }

    public boolean isDot() {
        boolean result = true;
        if (this.gestures.isEmpty()) {
            result = false;
        } else {
            Iterator iter = this.iterator();
            while (result && iter.hasNext()) {
                Gesture g = (Gesture)iter.next();
                if (g.size() == 1) continue;
                result = false;
            }
        }
        return result;
    }

    public Object clone() {
        GestureCategory gc = (GestureCategory)super.clone();
        gc.gestures = (Vector)Misc.deepCopy(this.gestures);
        gc.fixParents();
        return gc;
    }

    public boolean isSizeInvariant() {
        return this.sizeInvariant;
    }

    public void setSizeInvariance(boolean on) {
        this.sizeInvariant = on;
    }

    public boolean isDirectionInvariant() {
        return this.directionInvariant;
    }

    public void setDirectionInvariance(boolean on) {
        this.directionInvariant = on;
    }

    public boolean isOrientationInvariant() {
        return this.orientationInvariant;
    }

    public void setOrientationInvariance(boolean on) {
        this.orientationInvariant = on;
    }

    public void setExamplesEnabled(boolean enabled) {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Gesture g = (Gesture)iter.next();
            g.setEnabled(enabled);
        }
    }

    public Class[] getChildTypes() {
        return CHILD_TYPES;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Enumeration en = this.gestures.elements();
        while (en.hasMoreElements()) {
            Gesture g = (Gesture)en.nextElement();
            g.addObserver(this);
        }
    }

    public void write(Writer writer) throws IOException {
        writer.write("name\t" + this.name + "\n");
        if (this.author != null) {
            writer.write("author\t" + this.author + "\n");
        }
        writer.write("directionInvariant\t" + this.directionInvariant + "\n");
        writer.write("orientationInvariant\t" + this.orientationInvariant + "\n");
        writer.write("sizeInvariant\t" + this.sizeInvariant + "\n");
        writer.write("gestures\t" + this.gestures.size() + "\n");
        int i = 0;
        while (i < this.gestures.size()) {
            Gesture g = this.gestureAt(i);
            g.write(writer);
            ++i;
        }
        writer.write("endcategory\n");
    }

    public static GestureCategory read(Reader reader) throws IOException, ParseException {
        return GestureCategory.read(new TokenReader(reader));
    }

    public static GestureCategory read(TokenReader r) throws IOException, ParseException {
        GestureCategory result = new GestureCategory();
        boolean done = false;
        while (!done) {
            try {
                String token = r.readToken().intern();
                if (token == "name") {
                    result.name = r.readLine();
                    result.name.trim();
                    continue;
                }
                if (token == "author") {
                    result.author = r.readLine();
                    result.author.trim();
                    continue;
                }
                if (token == "directionInvariant") {
                    result.directionInvariant = r.readBoolean();
                    continue;
                }
                if (token == "orientationInvariant") {
                    result.orientationInvariant = r.readBoolean();
                    continue;
                }
                if (token == "sizeInvariant") {
                    result.sizeInvariant = r.readBoolean();
                    continue;
                }
                if (token == "gestures") {
                    try {
                        int numGestures = Integer.parseInt(r.readToken());
                        int i = 0;
                        while (i < numGestures) {
                            Gesture gesture = Gesture.read(r);
                            result.addGesture(gesture);
                            ++i;
                        }
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new IOException("bad argument for categories");
                    }
                }
                if (token != "endcategory") continue;
                done = true;
            }
            catch (EOFException e) {
                done = true;
            }
        }
        return result;
    }

    public String toString() {
        return this.getName();
    }
}

