/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture;

import edu.berkeley.guir.lib.gesture.DefaultGestureObject;
import edu.berkeley.guir.lib.gesture.TimedPolygon;
import edu.berkeley.guir.lib.gesture.util.TokenReader;
import edu.berkeley.guir.lib.util.DateLib;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Gesture
extends DefaultGestureObject
implements Serializable,
Cloneable {
    public static final String CREATION_DATE_PROP = "creation date";
    public static final String POINTS_PROP = "points";
    static final int filterThreshold = 16;
    static final long serialVersionUID = -783808682935248803L;
    protected int lastx = Integer.MIN_VALUE;
    protected int lasty = Integer.MIN_VALUE;
    protected TimedPolygon points;
    protected boolean normalized = false;
    protected boolean enabled;
    protected Date creationDate;

    public Gesture() {
        this(null);
    }

    public Gesture(Gesture g) {
        this.points = g == null ? new TimedPolygon() : new TimedPolygon(g.points);
        this.enabled = true;
        this.creationDate = new Date(System.currentTimeMillis());
    }

    public void addPoint(int x, int y) {
        int dx = this.lastx - x;
        int dy = this.lasty - y;
        int distSq = dx * dx + dy * dy;
        if (distSq > 16) {
            this.points.addPoint(x, y);
            this.lastx = x;
            this.lasty = y;
            if (x < 0 || y < 0) {
                this.normalized = false;
            }
            this.propChangeSupport.firePropertyChange(POINTS_PROP, null, new Point(x, y));
            this.setChanged();
            this.notifyObservers(new Point(x, y));
        }
    }

    public TimedPolygon getPoints() {
        return new TimedPolygon(this.points);
    }

    public TimedPolygon getPointsRef() {
        return this.points;
    }

    public void setPoints(TimedPolygon p) {
        if (p != this.points) {
            TimedPolygon oldValue = this.points;
            this.points = p;
            this.normalized = false;
            if (this.points.npoints > 0) {
                this.lastx = this.points.xpoints[this.points.npoints - 1];
                this.lasty = this.points.ypoints[this.points.npoints - 1];
            } else {
                this.lastx = Integer.MIN_VALUE;
                this.lasty = Integer.MIN_VALUE;
            }
            this.propChangeSupport.firePropertyChange(POINTS_PROP, oldValue, this.points);
            this.setChanged();
            this.notifyObservers(this.points);
        }
    }

    public void clearPoints() {
        TimedPolygon oldValue = this.points;
        this.setPoints(new TimedPolygon());
        this.propChangeSupport.firePropertyChange(POINTS_PROP, oldValue, this.points);
    }

    public Rectangle getBounds() {
        return (Rectangle)this.points.getBounds().clone();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean e) {
        this.setEnabled((boolean)e);
    }

    public void setEnabled(boolean e) {
        if (e != this.enabled) {
            this.enabled = e;
            this.propChangeSupport.firePropertyChange("enabled", !this.enabled, this.enabled);
            this.setChanged();
            this.notifyObservers(new Boolean(this.enabled));
        }
    }

    public void normalize() {
        if (!this.normalized) {
            TimedPolygon oldPoints = this.points;
            this.normalized = true;
            Rectangle bounds = this.points.getBounds();
            this.points.translate(-bounds.x, -bounds.y);
            this.propChangeSupport.firePropertyChange(POINTS_PROP, oldPoints, this.points);
            this.setChanged();
            this.notifyObservers(this.points);
        }
    }

    public int size() {
        return this.points.npoints;
    }

    public boolean hasProperty(String name) {
        if (name == CREATION_DATE_PROP || name == POINTS_PROP || name == "enabled") {
            return true;
        }
        return super.hasProperty(name);
    }

    public void setProperty(String name, Object value) {
        if (name == CREATION_DATE_PROP) {
            this.setCreationDate((Date)value);
        } else if (name == POINTS_PROP) {
            this.setPoints((TimedPolygon)value);
        } else if (name == "enabled") {
            this.setEnabled((boolean)((Boolean)value));
        } else {
            super.setProperty(name, value);
        }
    }

    public Object getProperty(String name) {
        if (name == CREATION_DATE_PROP) {
            return this.getCreationDate();
        }
        if (name == POINTS_PROP) {
            return this.getPoints();
        }
        if (name == "enabled") {
            return new Boolean(this.isEnabled());
        }
        return super.getProperty(name);
    }

    public Object clone() {
        Gesture g = (Gesture)super.clone();
        g.points = (TimedPolygon)this.points.clone();
        g.creationDate = (Date)this.creationDate.clone();
        return g;
    }

    public void dump(PrintStream out) {
        int i = 0;
        while (i < this.points.npoints) {
            out.print(String.valueOf(this.points.xpoints[i]) + ", " + this.points.ypoints[i] + " ");
            ++i;
        }
        out.println();
    }

    public void printTiming(PrintStream out) {
        int ncols = 4;
        int i = 0;
        while (i < this.points.npoints) {
            out.print("" + this.points.times[i]);
            if (i % 4 == 3) {
                out.println();
            } else {
                out.print("\t");
            }
            ++i;
        }
        out.println();
    }

    public void setCreationDate(Date d) {
        if (this.creationDate != d) {
            Date oldValue = this.creationDate;
            this.creationDate = d;
            this.propChangeSupport.firePropertyChange(CREATION_DATE_PROP, oldValue, this.creationDate);
            this.setChanged();
            this.notifyObservers(this.creationDate);
        }
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void write(Writer writer) throws IOException {
        if (this.author != null) {
            writer.write("author\t" + this.author + "\n");
        }
        writer.write("normalized\t" + this.normalized + "\n");
        if (this.creationDate != null) {
            writer.write("creationDate\t" + DateLib.DateToISO(this.creationDate) + "\n");
        }
        writer.write("points\t" + this.points.npoints + "\n");
        int i = 0;
        while (i < this.points.npoints) {
            writer.write("\t" + this.points.xpoints[i] + "\t" + this.points.ypoints[i] + "\t" + this.points.times[i] + "\n");
            ++i;
        }
        writer.write("endgesture\n");
    }

    public static Gesture read(Reader reader) throws IOException, ParseException {
        return Gesture.read(new TokenReader(reader));
    }

    public static Gesture read(TokenReader r) throws IOException, ParseException {
        Gesture result = new Gesture();
        boolean done = false;
        while (!done) {
            try {
                String token = r.readToken().intern();
                if (token == "author") {
                    result.author = r.readLine();
                    result.author.trim();
                    continue;
                }
                if (token == "normalized") {
                    result.normalized = r.readBoolean();
                    continue;
                }
                if (token == "creationDate") {
                    String dateStr = r.readLine();
                    try {
                        result.creationDate = DateLib.ISOToDate(dateStr);
                    }
                    catch (IllegalArgumentException e) {
                        SimpleDateFormat dateFormat = new SimpleDateFormat();
                        try {
                            result.creationDate = dateFormat.parse(dateStr);
                        }
                        catch (ParseException e2) {
                            System.err.println("WARNING: Could not parse date string '" + dateStr + "'.  Setting to null...");
                            result.creationDate = null;
                        }
                    }
                    continue;
                }
                if (token == POINTS_PROP) {
                    try {
                        int numPoints = r.readInt();
                        TimedPolygon poly = new TimedPolygon();
                        int i = 0;
                        while (i < numPoints) {
                            int x = r.readInt();
                            int y = r.readInt();
                            long t = r.readLong();
                            poly.addPoint(x, y, t);
                            ++i;
                        }
                        result.points = poly;
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new IOException("bad argument for points (" + e + ")");
                    }
                }
                if (token != "endgesture") continue;
                done = true;
            }
            catch (EOFException e) {
                done = true;
            }
        }
        return result;
    }

    public String toString() {
        return String.valueOf(super.toString()) + "/" + this.points.toString();
    }
}

