/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture;

import edu.berkeley.guir.lib.gesture.Classifier;
import edu.berkeley.guir.lib.gesture.Feature;
import edu.berkeley.guir.lib.gesture.FeatureVector;
import edu.berkeley.guir.lib.gesture.GestureContainer;
import edu.berkeley.guir.lib.gesture.GestureSet;
import edu.berkeley.guir.lib.gesture.StarPlot;
import java.awt.FlowLayout;
import javax.swing.JPanel;

public class GSStarPlot
extends JPanel {
    Classifier classifier;
    double scale = 100.0;
    double[] featureScales;

    public GSStarPlot(Classifier myClassifier) {
        this.classifier = myClassifier;
        this.buildUI();
    }

    private void buildUI() {
        FeatureVector dummyFV = new FeatureVector();
        int numFeatures = dummyFV.size();
        double[] maxValues = new double[numFeatures];
        double[] minValues = new double[numFeatures];
        double[][] meanVals = this.classifier.meanFeatureValues;
        this.featureScales = new double[numFeatures];
        int featureNum = 0;
        while (featureNum < numFeatures) {
            boolean finiteMax;
            Feature feature = dummyFV.getFeature(featureNum);
            double min = feature.getMinValue();
            double max = feature.getMaxValue();
            boolean finiteMin = min != Double.NEGATIVE_INFINITY;
            boolean bl = finiteMax = max != Double.POSITIVE_INFINITY;
            if (!finiteMin) {
                min = Double.POSITIVE_INFINITY;
            }
            if (!finiteMax) {
                max = Double.NEGATIVE_INFINITY;
            }
            if (!finiteMax || !finiteMin) {
                int gcIndex = 0;
                while (gcIndex < meanVals.length) {
                    double current = meanVals[gcIndex][featureNum];
                    if (!finiteMin && current < min) {
                        min = current;
                    }
                    if (!finiteMax && current > min) {
                        max = current;
                    }
                    ++gcIndex;
                }
            }
            minValues[featureNum] = min;
            maxValues[featureNum] = max;
            this.featureScales[featureNum] = 1.0 / Math.max(Math.abs(min), Math.abs(max));
            ++featureNum;
        }
        this.setLayout(new FlowLayout());
        GestureSet gestureSet = this.classifier.getGestureSet();
        int gcIndex = 0;
        while (gcIndex < meanVals.length) {
            StarPlot starPlot = new StarPlot(meanVals[gcIndex]);
            starPlot.setTitle(((GestureContainer)gestureSet.getChild(gcIndex)).getName());
            starPlot.setFeatureScales(this.featureScales);
            starPlot.setScale(this.scale);
            starPlot.setWeights(this.classifier.weights[gcIndex]);
            this.add(starPlot);
            ++gcIndex;
        }
    }
}

