/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture;

import edu.berkeley.guir.lib.gesture.Feature;
import edu.berkeley.guir.lib.gesture.FeatureFactory;
import edu.berkeley.guir.lib.gesture.Gesture;
import java.awt.Point;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Observable;
import java.util.Observer;

public class FeatureVector
extends Observable
implements Serializable,
Observer {
    public static final Class[] defaultFeatureClasses;
    protected Feature[] features;
    protected Gesture gesture;
    protected Class[] featureClasses;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;

    static {
        Class[] classArray = new Class[11];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.gesture.features.InitAngleCosine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("edu.berkeley.guir.lib.gesture.features.InitAngleSine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("edu.berkeley.guir.lib.gesture.features.BoundsSize");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz3;
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("edu.berkeley.guir.lib.gesture.features.BoundsAngle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[3] = clazz4;
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("edu.berkeley.guir.lib.gesture.features.EndsDistance");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[4] = clazz5;
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("edu.berkeley.guir.lib.gesture.features.EndsAngleCosine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[5] = clazz6;
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("edu.berkeley.guir.lib.gesture.features.EndsAngleSine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[6] = clazz7;
        Class<?> clazz8 = class$7;
        if (clazz8 == null) {
            try {
                clazz8 = class$7 = Class.forName("edu.berkeley.guir.lib.gesture.features.TotalLength");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[7] = clazz8;
        Class<?> clazz9 = class$8;
        if (clazz9 == null) {
            try {
                clazz9 = class$8 = Class.forName("edu.berkeley.guir.lib.gesture.features.TotalAngle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[8] = clazz9;
        Class<?> clazz10 = class$9;
        if (clazz10 == null) {
            try {
                clazz10 = class$9 = Class.forName("edu.berkeley.guir.lib.gesture.features.TotalAbsAngle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[9] = clazz10;
        Class<?> clazz11 = class$10;
        if (clazz11 == null) {
            try {
                clazz11 = class$10 = Class.forName("edu.berkeley.guir.lib.gesture.features.Sharpness");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[10] = clazz11;
        defaultFeatureClasses = classArray;
    }

    public FeatureVector() {
        try {
            this.init(defaultFeatureClasses);
        }
        catch (IllegalAccessException e) {
            System.err.println("FeatureVector: problem initializing default feature classes: " + e);
        }
        catch (InstantiationException e) {
            System.err.println("FeatureVector: problem initializing default feature classes: " + e);
        }
    }

    public FeatureVector(Class[] featureClasses) throws IllegalAccessException, InstantiationException {
        this.init(featureClasses);
    }

    protected void init(Class[] featureClasses) throws IllegalAccessException, InstantiationException {
        this.featureClasses = featureClasses;
        this.features = new Feature[featureClasses.length];
        int i = 0;
        while (i < featureClasses.length) {
            this.features[i] = (Feature)featureClasses[i].newInstance();
            ++i;
        }
    }

    public FeatureVector(Gesture g) {
        this();
        this.setGesture(g);
    }

    public FeatureVector(Gesture g, Class[] featureClasses) throws IllegalAccessException, InstantiationException {
        this(featureClasses);
        this.setGesture(g);
    }

    public Class getFeatureType(int featureNum) {
        return this.featureClasses[featureNum];
    }

    public void newPoint(Point p) {
        int i = 0;
        while (i < this.features.length) {
            this.features[i].newPoint(p);
            ++i;
        }
    }

    public void setGesture(Gesture g) {
        if (g != this.gesture) {
            int i = 0;
            while (i < this.features.length) {
                this.features[i].setGesture(g);
                this.features[i].addObserver(this);
                ++i;
            }
            this.gesture = g;
            this.update(null, null);
        }
    }

    public Gesture getGesture() {
        return this.gesture;
    }

    public double getValue(int featureNum) {
        return this.features[featureNum].getValue();
    }

    public Feature getFeature(int featureNum) {
        return this.features[featureNum];
    }

    public double[] getValues() {
        double[] result = new double[this.features.length];
        int i = 0;
        while (i < this.features.length) {
            result[i] = this.features[i].getValue();
            ++i;
        }
        return result;
    }

    public Feature[] getFeatures() {
        return this.features;
    }

    public int size() {
        return this.featureClasses.length;
    }

    public static int defaultSize() {
        return defaultFeatureClasses.length;
    }

    public void update(Observable feature, Object arg) {
        this.setChanged();
        this.notifyObservers(arg);
    }

    public static Feature singleFeature(Gesture g, int featureNum) {
        return FeatureVector.singleFeature(g, featureNum, defaultFeatureClasses);
    }

    public static Feature singleFeature(Gesture g, int featureNum, Class[] featureClasses) {
        return FeatureFactory.getFeature(featureClasses[featureNum], g);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int i = 0;
        while (i < this.features.length) {
            this.features[i].addObserver(this);
            ++i;
        }
    }
}

