/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture;

import edu.berkeley.guir.lib.gesture.Classifier;
import edu.berkeley.guir.lib.gesture.FPGraphFeature;
import edu.berkeley.guir.lib.gesture.FeaturePicker;
import edu.berkeley.guir.lib.gesture.FeatureVector;
import edu.berkeley.guir.lib.gesture.GestureSet;
import edu.berkeley.guir.lib.gesture.TrainingException;
import edu.berkeley.guir.lib.gesture.util.Misc;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.BitSet;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.Scrollable;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class FeaturePointGraph
extends JPanel
implements Observer,
Scrollable {
    private BitSet categoryMask;
    private boolean useWeights = false;
    private Classifier classifier;
    static final int xborder = 30;
    static final int topBorder = 20;
    static final int bottomBorder = 80;
    static final int minFeatureOffset = 50;
    static final int categoryOffset = 5;
    Dimension size;
    int axesWidth = 3;
    int xorig;
    int yorig;
    int height;
    int width;
    int featureOffset = 50;
    int numCategories;
    FeaturePicker featurePicker;
    JTextPane[] featureLabels;
    static final int labelHeight = 70;
    static final int minLabelWidth = 100;
    FPGraphFeature[] fpFeatureGraphs;

    public FeaturePointGraph(Classifier c, BitSet categoryMask) {
        this.categoryMask = categoryMask;
        this.classifier = c;
        GestureSet gs = this.classifier.getGestureSet();
        if (gs != null) {
            gs.addObserver(this);
        }
        this.initUI();
    }

    public FeaturePointGraph(Classifier c) {
        this(c, Misc.not(new BitSet(c.getGestureSet().size())));
    }

    private void initUI() {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setBackground(Color.white);
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        int numFeatures = FeatureVector.defaultSize();
        GridBagConstraints dataConstraints = new GridBagConstraints();
        dataConstraints.fill = 3;
        dataConstraints.weighty = 1.0;
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.fill = 0;
        this.featureLabels = new JTextPane[numFeatures];
        this.fpFeatureGraphs = new FPGraphFeature[numFeatures];
        FeatureVector dummyFV = new FeatureVector();
        SimpleAttributeSet centerStyle = new SimpleAttributeSet();
        StyleConstants.setAlignment(centerStyle, 1);
        int i = 0;
        while (i < numFeatures) {
            this.fpFeatureGraphs[i] = new FPGraphFeature(this.classifier, i, this.categoryMask);
            this.fpFeatureGraphs[i].setBorder(BorderFactory.createEtchedBorder());
            if (i == numFeatures - 1) {
                dataConstraints.gridwidth = 0;
            }
            this.add((Component)this.fpFeatureGraphs[i], dataConstraints);
            ++i;
        }
        i = 0;
        while (i < numFeatures) {
            DefaultStyledDocument doc = new DefaultStyledDocument();
            try {
                doc.insertString(0, dummyFV.getFeature(i).getName(), centerStyle);
            }
            catch (BadLocationException e) {
                System.err.println("Bogosity in FeaturePointGraph.initUI");
                break;
            }
            this.featureLabels[i] = new JTextPane(doc);
            this.featureLabels[i].setEditable(false);
            this.featureLabels[i].setBorder(BorderFactory.createEtchedBorder());
            int width = this.fpFeatureGraphs[i].getPreferredSize().width;
            this.featureLabels[i].setPreferredSize(new Dimension(width > 100 ? width : 100, 70));
            this.add((Component)this.featureLabels[i], labelConstraints);
            ++i;
        }
    }

    void rebuildUI() {
        int numFeatures = FeatureVector.defaultSize();
        GridBagConstraints dataConstraints = new GridBagConstraints();
        dataConstraints.fill = 3;
        dataConstraints.weighty = 1.0;
        GridBagLayout gridbag = (GridBagLayout)this.getLayout();
        int lastOne = 0;
        int i = 0;
        while (i < numFeatures) {
            boolean on = true;
            if (this.featurePicker != null) {
                on = this.featurePicker.isFeatureSelected(i);
                this.fpFeatureGraphs[i].setVisible(on);
                this.featureLabels[i].setVisible(on);
            }
            if (on) {
                int width = this.fpFeatureGraphs[i].getPreferredSize().width;
                this.featureLabels[i].setPreferredSize(new Dimension(width > 100 ? width : 100, 70));
                this.featureLabels[i].invalidate();
                gridbag.setConstraints(this.fpFeatureGraphs[i], dataConstraints);
                lastOne = i;
            }
            ++i;
        }
        dataConstraints.gridwidth = 0;
        gridbag.setConstraints(this.fpFeatureGraphs[lastOne], dataConstraints);
        this.invalidate();
        Window w = (Window)this.getTopLevelAncestor();
        if (w != null) {
            w.pack();
        }
        this.repaint();
    }

    public void setCategoryMask(BitSet catMask) {
        if (!catMask.equals(this.categoryMask)) {
            this.categoryMask = (BitSet)catMask.clone();
            int i = 0;
            while (i < this.fpFeatureGraphs.length) {
                this.fpFeatureGraphs[i].setCategoryMask(catMask);
                ++i;
            }
            this.rebuildUI();
        }
    }

    public BitSet getCategoryMask() {
        return (BitSet)this.categoryMask.clone();
    }

    public void update(Observable observable, Object arg) {
        if (this.classifier != null) {
            this.setClassifier(this.classifier);
        }
        this.invalidate();
        this.repaint();
    }

    public void setFeaturePicker(FeaturePicker fp) {
        this.featurePicker = fp;
        this.featurePicker.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                FeaturePointGraph.this.rebuildUI();
            }
        });
        this.rebuildUI();
    }

    public void setClassifier(Classifier c) {
        block5: {
            this.classifier = c;
            if (!this.classifier.trained) {
                try {
                    this.classifier.train();
                    this.repaint();
                }
                catch (TrainingException e) {
                    if (this.useWeights) {
                        System.err.println("Weights disabled because classifier could not be trained");
                        this.useWeights = false;
                    }
                }
                catch (InterruptedException e) {
                    if (!this.useWeights) break block5;
                    System.err.println("Weights disabled because classifier was interrupted while training");
                    this.useWeights = false;
                }
            }
        }
    }

    public void weightsOn(boolean on) {
        if (this.useWeights != on) {
            this.useWeights = on;
            int i = 0;
            while (i < this.fpFeatureGraphs.length) {
                this.fpFeatureGraphs[i].weightsOn(on);
                ++i;
            }
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 20;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return visibleRect.width;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return true;
    }
}

