/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture;

import edu.berkeley.guir.lib.gesture.FeatureVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.event.EventListenerList;

public class FeaturePicker
extends JFrame
implements ItemSelectable {
    static FeatureVector fv = new FeatureVector();
    JCheckBox[] checkBoxes;
    protected EventListenerList itemListenerList = new EventListenerList();
    int numSelected;
    static /* synthetic */ Class class$0;

    public FeaturePicker() {
        this.buildUI();
    }

    public FeaturePicker(String name) {
        super(name);
        this.buildUI();
    }

    void buildUI() {
        int numRows = fv.size();
        this.checkBoxes = new JCheckBox[numRows];
        Box contents = Box.createVerticalBox();
        int i = 0;
        while (i < numRows) {
            this.checkBoxes[i] = new JCheckBox(String.valueOf(Integer.toString(i)) + " " + fv.getFeature(i).getName());
            this.checkBoxes[i].addItemListener(new CheckBoxListener(i));
            this.checkBoxes[i].setSelected(true);
            contents.add(this.checkBoxes[i]);
            ++i;
        }
        this.numSelected = numRows;
        this.getContentPane().setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(contents);
        this.getContentPane().add((Component)scrollPane, "Center");
        JButton b = new JButton("Close");
        ActionListener l = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FeaturePicker.this.dispose();
            }
        };
        b.addActionListener(l);
        this.getContentPane().add((Component)b, "South");
    }

    public void setFeatureSelected(int featureNum, boolean on) {
        this.checkBoxes[featureNum].setSelected(on);
    }

    public boolean isFeatureSelected(int featureNum) {
        return this.checkBoxes[featureNum].isSelected();
    }

    public int getNumSelected() {
        return this.numSelected;
    }

    public void addItemListener(ItemListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.awt.event.ItemListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.itemListenerList.add(clazz, l);
    }

    public void removeItemListener(ItemListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.awt.event.ItemListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.itemListenerList.remove(clazz, l);
    }

    protected void fireItemChange(int type, int featureNum, int selectState) {
        ItemEvent event = null;
        Object[] listeners = this.itemListenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            Object object = listeners[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("java.awt.event.ItemListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                if (event == null) {
                    event = new ItemEvent(this, type, new Integer(featureNum), selectState);
                }
                ((ItemListener)listeners[i + 1]).itemStateChanged(event);
            }
            i -= 2;
        }
    }

    public Object[] getSelectedObjects() {
        Object[] result = new Object[this.numSelected];
        int ri = 0;
        int i = 0;
        while (i < this.checkBoxes.length) {
            if (this.checkBoxes[i].isSelected()) {
                result[ri++] = new Integer(i);
            }
            ++i;
        }
        return result;
    }

    public static void main(String[] args) {
        FeaturePicker fp = new FeaturePicker("FeaturePicker test");
        WindowAdapter l = new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                System.exit(0);
            }

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        };
        fp.addWindowListener(l);
        fp.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Object[] o = e.getItemSelectable().getSelectedObjects();
                System.out.print("Current selection:");
                int i = 0;
                while (i < o.length) {
                    System.out.print(" " + o[i]);
                    ++i;
                }
                System.out.println();
            }
        });
        fp.pack();
        fp.show();
    }

    public class CheckBoxListener
    implements ItemListener {
        int cbNum;

        CheckBoxListener(int n) {
            this.cbNum = n;
        }

        public void itemStateChanged(ItemEvent e) {
            FeaturePicker.this.numSelected = e.getStateChange() == 1 ? ++FeaturePicker.this.numSelected : --FeaturePicker.this.numSelected;
            FeaturePicker.this.fireItemChange(701, this.cbNum, e.getStateChange());
        }
    }
}

