/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture;

import edu.berkeley.guir.lib.gesture.Feature;
import edu.berkeley.guir.lib.gesture.FeatureDisplay;
import edu.berkeley.guir.lib.gesture.FeatureVector;
import edu.berkeley.guir.lib.gesture.Gesture;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class FeatureFrame
extends JFrame {
    Gesture gesture;

    FeatureFrame(Gesture g) {
        super("Feature values");
        this.gesture = g;
        this.buildUI();
    }

    private void buildUI() {
        Box featureHolder = new Box(1);
        FeatureVector fv = new FeatureVector(this.gesture);
        Feature[] features = fv.getFeatures();
        int i = 0;
        while (i < features.length) {
            this.addFeature(featureHolder, features[i]);
            ++i;
        }
        this.getContentPane().add((Component)featureHolder, "Center");
        JButton dismiss = new JButton("Close");
        ActionListener dismissListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FeatureFrame.this.dispose();
            }
        };
        dismiss.addActionListener(dismissListener);
        this.getContentPane().add((Component)dismiss, "South");
        this.setResizable(false);
        this.pack();
        this.show();
    }

    private void addFeature(Container c, Feature f) {
        Box b = new Box(0);
        b.add(new JLabel(String.valueOf(f.getName()) + " "));
        b.add(Box.createGlue());
        b.add(new FeatureDisplay(f));
        final JTextField multiplier = new JTextField("1.0");
        JButton button = new JButton("Change");
        final Feature dummy = f;
        ActionListener buttonListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                double factor = Double.valueOf(multiplier.getText());
                dummy.scale(factor);
            }
        };
        button.addActionListener(buttonListener);
        b.add(multiplier);
        multiplier.setColumns(10);
        b.add(button);
        c.add(b);
    }
}

