/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture;

import edu.berkeley.guir.lib.gesture.Feature;
import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.GestureContainer;
import edu.berkeley.guir.lib.gesture.GestureObject;
import java.util.HashMap;
import java.util.Iterator;

public class FeatureFactory {
    private static HashMap featureTable = new HashMap();
    private static boolean flagCaching = true;
    static /* synthetic */ Class class$0;

    private FeatureFactory() {
    }

    protected static void checkFeatureClass(Class c) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.gesture.Feature");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz.isAssignableFrom(c)) {
            throw new IllegalArgumentException("featureClass must be a Feature");
        }
    }

    public static Feature getFeature(Class featureClass, GestureObject gestureObj) {
        FeatureFactory.checkFeatureClass(featureClass);
        Feature result = null;
        if (gestureObj instanceof Gesture) {
            if (FeatureFactory.isCaching()) {
                result = FeatureFactory.createFeature(featureClass, gestureObj);
            } else {
                HashMap<Class, Feature> features = FeatureFactory.getFeatures((Gesture)gestureObj);
                if (features == null) {
                    features = new HashMap<Class, Feature>();
                    featureTable.put(gestureObj, features);
                }
                if ((result = FeatureFactory.getFeature(features, featureClass)) == null) {
                    result = FeatureFactory.createFeature(featureClass, gestureObj);
                    features.put(featureClass, result);
                }
            }
        } else {
            System.err.println("Warning: FeatureFactory.getFeature: Features for non-Gestures are not supported (yet)");
        }
        return result;
    }

    public static double getFeatureValue(Class featureClass, GestureObject gestureObj) {
        double result;
        FeatureFactory.checkFeatureClass(featureClass);
        if (gestureObj instanceof Gesture) {
            Feature f = FeatureFactory.getFeature(featureClass, gestureObj);
            result = f.getValue();
        } else if (gestureObj instanceof GestureContainer) {
            GestureContainer container = (GestureContainer)gestureObj;
            result = 0.0;
            int count = 0;
            Iterator iter = container.iterator();
            while (iter.hasNext()) {
                GestureObject child = (GestureObject)iter.next();
                result += FeatureFactory.getFeatureValue(featureClass, child);
                ++count;
            }
            result /= (double)count;
        } else {
            System.err.println("Warning: FeatureFactory.getFeatureValue: Only Gesture and GestureContainer are supported");
            result = 0.0;
        }
        return result;
    }

    protected static Feature createFeature(Class featureClass, GestureObject gestureObj) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.gesture.Feature");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz.isAssignableFrom(featureClass)) {
            throw new IllegalArgumentException("featureClass must be a Feature");
        }
        Feature feature = null;
        try {
            feature = (Feature)featureClass.newInstance();
            if (gestureObj != null) {
                if (gestureObj instanceof Gesture) {
                    feature.setGesture((Gesture)gestureObj);
                } else {
                    System.err.println("Warning: FeatureFactory.getFeature: Features for non-Gestures are not supported (yet)");
                }
            }
        }
        catch (InstantiationException e) {
            System.err.println("Warning: could not instantiate feature of class '" + featureClass.getName() + "':" + e);
        }
        catch (IllegalAccessException e) {
            System.err.println("Warning: could not access class '" + featureClass.getName() + "':" + e);
        }
        return feature;
    }

    protected static Feature getFeature(HashMap table, Class featureClass) {
        Feature result = table.containsKey(featureClass) ? (Feature)table.get(featureClass) : null;
        return result;
    }

    protected static HashMap getFeatures(Gesture gesture) {
        HashMap result = featureTable.containsKey(gesture) ? (HashMap)featureTable.get(gesture) : null;
        return result;
    }

    public static double[] getValues(Class[] featureClasses, GestureObject gestureObj) {
        double[] result = new double[featureClasses.length];
        int i = 0;
        while (i < featureClasses.length) {
            result[i] = FeatureFactory.getFeatureValue(featureClasses[i], gestureObj);
            ++i;
        }
        return result;
    }

    public static String getFeatureName(Class featureClass) {
        Feature f = FeatureFactory.createFeature(featureClass, null);
        return f == null ? null : f.getName();
    }

    public static void setCaching(boolean flag) {
        flagCaching = flag;
    }

    public static boolean isCaching() {
        return flagCaching;
    }

    public static void clearCache() {
        featureTable.clear();
    }
}

