/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture;

import edu.berkeley.guir.lib.gesture.Feature;
import edu.berkeley.guir.lib.gesture.FeatureVector;
import edu.berkeley.guir.lib.gesture.GestureCategory;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

public class FeatureArray
extends Observable
implements Serializable,
Observer {
    private Vector featureVectors;
    private GestureCategory gestureCategory;
    private Class[] featureClasses;

    public FeatureArray() {
        this.featureClasses = FeatureVector.defaultFeatureClasses;
        this.featureVectors = new Vector();
    }

    public FeatureArray(GestureCategory gc) {
        try {
            this.init(gc, FeatureVector.defaultFeatureClasses);
        }
        catch (IllegalAccessException e) {
            System.err.println("FeatureArray: problem accessing default feature classes.  (This should never happen.)");
        }
        catch (InstantiationException e) {
            System.err.println("FeatureArray: problem instantiating default features.  (This should never happen.)");
        }
        gc.addObserver(this);
    }

    public FeatureArray(GestureCategory gc, Class[] featureClasses) throws IllegalAccessException, InstantiationException {
        this.init(gc, featureClasses);
    }

    private void init(GestureCategory gc, Class[] featureClasses) throws IllegalAccessException, InstantiationException {
        this.featureClasses = featureClasses;
        this.gestureCategory = gc;
        this.buildArray();
        gc.addObserver(this);
    }

    private void buildArray() throws IllegalAccessException, InstantiationException {
    }

    public void add(FeatureVector fv) {
        this.featureVectors.addElement(fv);
        fv.addObserver(this);
        this.setChanged();
        this.notifyObservers(fv);
    }

    public FeatureVector elementAt(int i) {
        return (FeatureVector)this.featureVectors.elementAt(i);
    }

    public void removeElementAt(int i) {
        FeatureVector fv = this.elementAt(i);
        fv.deleteObserver(this);
        this.featureVectors.removeElementAt(i);
        this.setChanged();
        this.notifyObservers(fv);
    }

    public Feature getFeature(int vectorNum, int featureNum) {
        FeatureVector fv = this.elementAt(vectorNum);
        return fv.getFeatures()[featureNum];
    }

    public int size() {
        return this.featureVectors.size();
    }

    public Enumeration elements() {
        return this.featureVectors.elements();
    }

    public void update(Observable featureVector, Object arg) {
        try {
            this.buildArray();
        }
        catch (IllegalAccessException e) {
            System.err.println("FeatureArray.update: problem accessing default feature classes.  (This should never happen.)");
        }
        catch (InstantiationException e) {
            System.err.println("FeatureArray.update: problem instantiating default features.  (This should never happen.)");
        }
        this.setChanged();
        this.notifyObservers(featureVector);
    }

    public double maxFeatureValue(int featureNum) {
        double max = Double.NEGATIVE_INFINITY;
        if (this.size() > 0) {
            Feature dummy = this.getFeature(0, featureNum);
            if (dummy.getMaxValue() == Double.POSITIVE_INFINITY) {
                int exampleNum = 0;
                while (exampleNum < this.size()) {
                    Feature f = this.getFeature(exampleNum, featureNum);
                    double newVal = f.getValue();
                    if (newVal > max) {
                        max = newVal;
                    }
                    ++exampleNum;
                }
            } else {
                max = dummy.getMaxValue();
            }
        }
        return max;
    }

    public double minFeatureValue(int featureNum) {
        double min = Double.POSITIVE_INFINITY;
        if (this.size() > 0) {
            Feature dummy = this.getFeature(0, featureNum);
            if (dummy.getMinValue() == Double.NEGATIVE_INFINITY) {
                int exampleNum = 0;
                while (exampleNum < this.size()) {
                    Feature f = this.getFeature(exampleNum, featureNum);
                    double newVal = f.getValue();
                    if (newVal < min) {
                        min = newVal;
                    }
                    ++exampleNum;
                }
            } else {
                min = dummy.getMinValue();
            }
        }
        return min;
    }

    public double meanFeatureValue(int featureNum) {
        double mean = 0.0;
        if (this.size() > 0) {
            int numExamples = this.size();
            int exampleNum = 0;
            while (exampleNum < numExamples) {
                Feature f = this.getFeature(exampleNum, featureNum);
                mean += f.getValue();
                ++exampleNum;
            }
            mean /= (double)numExamples;
        }
        return mean;
    }

    public String featureName(int featureNum) {
        String result;
        if (this.size() > 0) {
            Feature dummy = this.getFeature(0, featureNum);
            result = dummy.getName();
        } else {
            result = null;
        }
        return result;
    }
}

