/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture;

import edu.berkeley.guir.lib.gesture.Gesture;
import java.awt.Point;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Observable;
import java.util.Observer;

public abstract class Feature
extends Observable
implements Serializable,
Observer {
    protected double value;
    protected boolean valueOk = false;
    protected Gesture gesture;

    public Feature() {
        this(null);
    }

    public Feature(Gesture g) {
        this.setGesture(g);
    }

    public void newPoint(Point p) {
        this.newPoint(p.x, p.y);
    }

    public void newPoint(int x, int y) {
    }

    public void setGesture(Gesture g) {
        if (this.gesture != null) {
            this.gesture.deleteObserver(this);
        }
        this.gesture = g;
        this.valueOk = false;
        if (g != null) {
            g.addObserver(this);
            this.update(g, null);
        }
    }

    public Gesture getGesture() {
        return this.gesture;
    }

    public double getValue() {
        if (!this.valueOk) {
            this.computeValue();
            this.valueOk = true;
        }
        return this.value;
    }

    public void update(Observable gesture, Object arg) {
        if (arg != null && arg instanceof Point) {
            Point p = (Point)arg;
            Gesture g = (Gesture)gesture;
            if (g != gesture) {
                System.err.println("Feature.update: Bizarreness " + g + " != " + gesture);
                return;
            }
            this.valueOk = false;
            if (p != null) {
                this.newPoint(p);
            }
            this.setChanged();
            this.notifyObservers(p);
        }
    }

    public abstract String getName();

    public abstract double getMinValue();

    public abstract double getMaxValue();

    protected abstract void computeValue();

    public abstract void scale(double var1);

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.gesture != null) {
            this.gesture.addObserver(this);
        }
    }
}

