/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture;

import edu.berkeley.guir.lib.gesture.CategoryPicker;
import edu.berkeley.guir.lib.gesture.Classifier;
import edu.berkeley.guir.lib.gesture.FPGraphFeature;
import edu.berkeley.guir.lib.gesture.FeaturePicker;
import edu.berkeley.guir.lib.gesture.FeaturePointGraph;
import edu.berkeley.guir.lib.gesture.GestureSet;
import edu.berkeley.guir.lib.gesture.util.HystericResizer;
import edu.berkeley.guir.lib.gesture.util.Misc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.BitSet;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;

public class FPGraphFrame
extends JFrame {
    FeaturePointGraph graph;
    FeaturePicker featurePicker = null;
    CategoryPicker categoryPicker;
    JCheckBoxMenuItem weightsMenuItem;

    public FPGraphFrame(Classifier c) {
        this(c, null);
    }

    public FPGraphFrame(Classifier classifier, String name) {
        GestureSet gestureSet = classifier.getGestureSet();
        this.setTitle("Feature Graph" + (gestureSet.getName() == null ? "" : ": " + gestureSet.getName()));
        this.buildUI(classifier);
    }

    private void buildUI(Classifier classifier) {
        Container contents = this.getContentPane();
        contents.setLayout(new BorderLayout());
        GestureSet gestureSet = classifier.getGestureSet();
        this.graph = new FeaturePointGraph(classifier);
        JScrollPane scrollPane = new JScrollPane(this.graph);
        scrollPane.setVerticalScrollBarPolicy(21);
        contents.add((Component)scrollPane, "Center");
        this.categoryPicker = new CategoryPicker(gestureSet, FPGraphFeature.colorArray);
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                FPGraphFrame.this.graph.setCategoryMask(FPGraphFrame.this.categoryPicker.getCategoryMask());
            }
        };
        this.categoryPicker.addItemListener(itemListener);
        JScrollPane categoryPickerScroller = new JScrollPane(this.categoryPicker, 20, 31);
        contents.add((Component)categoryPickerScroller, "West");
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("Graph");
        JMenuItem item = new JMenuItem("Close");
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FPGraphFrame.this.dispose();
            }
        };
        item.addActionListener(listener);
        menu.add(item);
        menuBar.add(menu);
        menu = new JMenu("View");
        final JCheckBoxMenuItem cbItem = new JCheckBoxMenuItem("Use weights");
        item = cbItem;
        listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FPGraphFrame.this.graph.weightsOn(cbItem.getState());
            }
        };
        this.weightsMenuItem = cbItem;
        item.addActionListener(listener);
        menu.add(item);
        item = new JMenuItem("Filter features");
        listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (FPGraphFrame.this.featurePicker == null) {
                    FPGraphFrame.this.featurePicker = new FeaturePicker("Features");
                    FPGraphFrame.this.featurePicker.pack();
                    FPGraphFrame.this.graph.setFeaturePicker(FPGraphFrame.this.featurePicker);
                }
                FPGraphFrame.this.featurePicker.show();
            }
        };
        item.addActionListener(listener);
        menu.add(item);
        item = new JMenuItem("Enable all classes");
        listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BitSet bitSet = new BitSet(FPGraphFrame.this.categoryPicker.numCategories());
                FPGraphFrame.this.categoryPicker.setCategoryMask(Misc.not(bitSet));
            }
        };
        item.addActionListener(listener);
        menu.add(item);
        item = new JMenuItem("Disable all classes");
        listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BitSet bitSet = new BitSet(FPGraphFrame.this.categoryPicker.numCategories());
                FPGraphFrame.this.categoryPicker.setCategoryMask(bitSet);
            }
        };
        item.addActionListener(listener);
        menu.add(item);
        menuBar.add(menu);
        HystericResizer hr = new HystericResizer();
        this.getRootPane().addComponentListener(hr);
        this.getRootPane().setJMenuBar(menuBar);
        scrollPane.setSize(new Dimension(600, 400));
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                System.err.println("FPGraphFrame hit");
            }
        });
    }

    public FeaturePointGraph getGraph() {
        return this.graph;
    }

    public void setCategoryMask(BitSet categoryMask) {
        this.graph.setCategoryMask(categoryMask);
        this.categoryPicker.setCategoryMask(categoryMask);
    }

    public void enableWeights(boolean weightsOn) {
        this.weightsMenuItem.setEnabled(weightsOn);
    }
}

