/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture;

import edu.berkeley.guir.lib.gesture.Classifier;
import edu.berkeley.guir.lib.gesture.Feature;
import edu.berkeley.guir.lib.gesture.FeatureVector;
import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.GestureCategory;
import edu.berkeley.guir.lib.gesture.GestureSet;
import edu.berkeley.guir.lib.gesture.PlotColumn;
import edu.berkeley.guir.lib.gesture.util.Misc;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.util.BitSet;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FPGraphFeature
extends JPanel {
    public static final Color[] colorArray = new Color[]{Color.red, Color.blue, Color.magenta, Color.orange, Color.green, Color.pink, Color.cyan};
    Classifier classifier;
    int featureNumber;
    boolean weightsOn = false;
    double[][] featureValues;
    double maxValue;
    double minValue;
    BitSet categoryMask;
    JLabel minLabel;
    JLabel maxLabel;
    PlotColumn[] plotColumns;

    public FPGraphFeature(Classifier c, int featureNum) {
        this(c, featureNum, Misc.not(new BitSet(c.getGestureSet().size())));
    }

    public FPGraphFeature(Classifier c, int featureNum, BitSet catMask) {
        if (c == null) {
            throw new IllegalArgumentException("Classifier c must be non-null");
        }
        this.classifier = c;
        this.featureNumber = featureNum;
        this.categoryMask = catMask;
        this.featureValues = new double[1][];
        this.initUI();
    }

    private void initUI() {
        GridBagLayout gb = new GridBagLayout();
        JPanel dataPanel = new JPanel(gb);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 3;
        constraints.weighty = 1.0;
        GestureSet gestureSet = this.classifier.getGestureSet();
        int numCategories = gestureSet.size();
        this.plotColumns = new PlotColumn[numCategories];
        int catNum = 0;
        while (catNum < numCategories) {
            this.plotColumns[catNum] = new PlotColumn();
            this.plotColumns[catNum].setBackground(Color.white);
            this.plotColumns[catNum].setForeground(colorArray[catNum % colorArray.length]);
            dataPanel.add((Component)this.plotColumns[catNum], constraints);
            ++catNum;
        }
        this.setLayout(new BorderLayout());
        this.setBackground(Color.white);
        this.add((Component)dataPanel, "Center");
        this.minLabel = new JLabel();
        this.maxLabel = new JLabel();
        this.minLabel.setBackground(Color.white);
        this.maxLabel.setBackground(Color.white);
        this.minLabel.setHorizontalAlignment(0);
        this.maxLabel.setHorizontalAlignment(0);
        this.add((Component)this.minLabel, "South");
        this.add((Component)this.maxLabel, "North");
        this.rebuildUI();
    }

    private void computeFeatureValues() {
        GestureSet gestureSet = this.classifier.getGestureSet();
        int numCategories = gestureSet.size();
        if (this.featureValues.length < numCategories) {
            this.featureValues = new double[numCategories][];
        }
        this.minValue = Double.POSITIVE_INFINITY;
        this.maxValue = Double.NEGATIVE_INFINITY;
        int catNum = 0;
        while (catNum < numCategories) {
            GestureCategory gc = (GestureCategory)gestureSet.getChild(catNum);
            int numExamples = gc.size();
            if (this.featureValues[catNum] == null || this.featureValues[catNum].length < numExamples) {
                this.featureValues[catNum] = new double[numExamples];
            }
            double weight = 1.0;
            if (this.weightsOn) {
                weight = this.classifier.weights[catNum][this.featureNumber + 1];
            }
            int exampleNum = 0;
            while (exampleNum < numExamples) {
                Gesture gesture = gc.gestureAt(exampleNum);
                Feature f = FeatureVector.singleFeature(gesture, this.featureNumber);
                double value = f.getValue();
                if (this.weightsOn) {
                    value *= weight;
                }
                this.featureValues[catNum][exampleNum] = value;
                if (value < this.minValue) {
                    this.minValue = value;
                }
                if (value > this.maxValue) {
                    this.maxValue = value;
                }
                ++exampleNum;
            }
            ++catNum;
        }
    }

    private void rebuildUI() {
        this.computeFeatureValues();
        int catNum = 0;
        while (catNum < this.classifier.getGestureSet().size()) {
            this.plotColumns[catNum].setVisible(this.categoryMask.get(catNum));
            this.plotColumns[catNum].setData(this.featureValues[catNum], this.minValue, this.maxValue);
            ++catNum;
        }
        this.minLabel.setText(Misc.toString(this.minValue, 3));
        this.maxLabel.setText(Misc.toString(this.maxValue, 3));
        this.invalidate();
        Window w = (Window)this.getTopLevelAncestor();
        if (w != null) {
            w.pack();
        }
    }

    public void setCategoryMask(BitSet catMask) {
        if (!catMask.equals(this.categoryMask)) {
            this.categoryMask = (BitSet)catMask.clone();
            this.rebuildUI();
        }
    }

    public void weightsOn(boolean on) {
        if (this.weightsOn != on) {
            this.weightsOn = on;
            this.rebuildUI();
        }
    }
}

