/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture;

import edu.berkeley.guir.lib.gesture.Classifier;
import edu.berkeley.guir.lib.gesture.FPGraphFrame;
import edu.berkeley.guir.lib.gesture.GestureContainer;
import edu.berkeley.guir.lib.gesture.GestureSet;
import edu.berkeley.guir.lib.gesture.ToolTipUpdater;
import edu.berkeley.guir.lib.gesture.util.AbstractCTableModel;
import edu.berkeley.guir.lib.gesture.util.CTable;
import edu.berkeley.guir.lib.gesture.util.Matrix;
import edu.berkeley.guir.lib.gesture.util.Misc;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.BitSet;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class DistanceMatrix
extends JFrame
implements Observer {
    Double[][] distance;
    double maxDistance = 0.0;
    Classifier classifier;
    GestureSet gestureSet;
    CTable table;
    double threshold;
    boolean markedOld = false;
    static /* synthetic */ Class class$0;

    public DistanceMatrix(Classifier classifier) {
        super("Distance Matrix");
        this.classifier = classifier;
        this.gestureSet = classifier.getGestureSet();
        this.gestureSet.addObserver(this);
        this.computeDistances();
        this.buildUI();
    }

    public DistanceMatrix(GestureSet gs, Double[][] distance) {
        this(gs, distance, Double.MAX_VALUE);
    }

    public DistanceMatrix(GestureSet gs, Double[][] distance, double maxDistance) {
        super("Distance Matrix");
        this.classifier = null;
        this.gestureSet = gs;
        this.gestureSet.addObserver(this);
        this.distance = distance;
        this.threshold = maxDistance;
        this.maxDistance = maxDistance;
        this.buildUI();
    }

    private void computeDistances() {
    }

    private void buildUI() {
        Container contents = this.getContentPane();
        contents.setLayout(new BorderLayout());
        AbstractCTableModel dataModel = new AbstractCTableModel(){

            public int getColumnCount() {
                return DistanceMatrix.this.distance.length;
            }

            public int getRowCount() {
                return DistanceMatrix.this.distance[0].length;
            }

            public Object getValueAt(int r, int c) {
                return DistanceMatrix.this.distance[r][c];
            }

            public Class getColumnClass(int c) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }

            public String getColumnName(int c) {
                return ((GestureContainer)DistanceMatrix.this.gestureSet.getChild(c)).getName();
            }

            public String getRowName(int row) {
                return this.getColumnName(row);
            }
        };
        this.table = new CTable(dataModel);
        new ColorRenderer(this.table);
        this.table.setRowSelectionAllowed(false);
        this.table.setColumnSelectionAllowed(false);
        this.table.setAutoResizeMode(0);
        if (this.classifier != null) {
            this.table.addMouseListener(new MyMouseListener());
        }
        this.table.addMouseMotionListener(new ToolTipUpdater(this.table));
        TableColumnModel tcm = this.table.getColumnModel();
        int i = 0;
        while (i < dataModel.getColumnCount()) {
            TableColumn column = tcm.getColumn(i);
            column.setWidth(column.getWidth() / 2);
            ++i;
        }
        JScrollPane scrollPane = new JScrollPane(this.table);
        contents.add((Component)scrollPane, "Center");
        int max = (int)Math.ceil(this.maxDistance);
        final JSlider slider = new JSlider(1, 0, max, max);
        slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                DistanceMatrix.this.threshold = slider.getValue();
                DistanceMatrix.this.table.repaint();
            }
        });
        JPanel sliderPanel = new JPanel(new BorderLayout());
        sliderPanel.add((Component)slider, "Center");
        sliderPanel.add((Component)new JLabel("Threshold"), "North");
        contents.add((Component)sliderPanel, "East");
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("Table");
        JMenuItem item = new JMenuItem("Dump distances");
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int oldSigFigs = Matrix.sigFigs;
                Matrix.sigFigs = 3;
                Matrix.prettyPrint(DistanceMatrix.this.distance);
                Matrix.sigFigs = oldSigFigs;
            }
        };
        item.addActionListener(listener);
        menu.add(item);
        item = new JMenuItem("Close");
        listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DistanceMatrix.this.dispose();
            }
        };
        item.addActionListener(listener);
        menu.addSeparator();
        menu.add(item);
        menuBar.add(menu);
        this.getRootPane().setJMenuBar(menuBar);
    }

    public void update(Observable o, Object arg) {
        if (!this.markedOld) {
            this.setTitle(String.valueOf(this.getTitle()) + " - OLD");
            this.markedOld = true;
        }
    }

    class ColorRenderer
    implements TableCellRenderer {
        Border headerBorder = BorderFactory.createEtchedBorder();
        TableCellRenderer stringRenderer;
        TableCellRenderer objectRenderer;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;
        static /* synthetic */ Class class$2;

        ColorRenderer(JTable table) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.stringRenderer = table.getDefaultRenderer(clazz);
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.objectRenderer = table.getDefaultRenderer(clazz2);
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("java.lang.Double");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            table.setDefaultRenderer(clazz3, this);
            Class<?> clazz4 = class$0;
            if (clazz4 == null) {
                try {
                    clazz4 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            table.setDefaultRenderer(clazz4, this);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String valString;
            if (value == null) {
                Component defaultComponent = this.objectRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                defaultComponent.setBackground(Color.white);
                return defaultComponent;
            }
            double x = 0.0;
            if (value instanceof String) {
                valString = (String)value;
            } else {
                x = (Double)value;
                valString = Misc.toString(x, 2);
            }
            Component defaultComponent = this.stringRenderer.getTableCellRendererComponent(table, valString, isSelected, hasFocus, row, column);
            if (column == row) {
                defaultComponent.setBackground(Color.yellow);
            } else if (x > DistanceMatrix.this.threshold) {
                defaultComponent.setBackground(Color.darkGray);
            } else {
                defaultComponent.setBackground(Color.white);
            }
            return defaultComponent;
        }
    }

    class MyMouseListener
    extends MouseAdapter {
        MyMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            Point p = e.getPoint();
            int row = DistanceMatrix.this.table.rowAtPoint(p);
            int column = DistanceMatrix.this.table.columnAtPoint(p);
            if (column >= 0) {
                FPGraphFrame fpgFrame = new FPGraphFrame(DistanceMatrix.this.classifier);
                BitSet categoryMask = new BitSet();
                categoryMask.set(row);
                categoryMask.set(column);
                fpgFrame.setCategoryMask(categoryMask);
                fpgFrame.pack();
                fpgFrame.show();
            }
        }
    }
}

