/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture;

import edu.berkeley.guir.lib.gesture.GestureContainer;
import edu.berkeley.guir.lib.gesture.GestureObject;
import edu.berkeley.guir.lib.gesture.Properties;
import edu.berkeley.guir.lib.gesture.util.TokenReader;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.Writer;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;

public class DefaultGestureObject
extends Observable
implements GestureObject,
Cloneable {
    protected String author = null;
    protected transient GestureContainer parent = null;
    protected Map properties = new HashMap();
    protected transient PropertyChangeSupport propChangeSupport = new PropertyChangeSupport(this);

    public void setAuthor(String a) {
        if (this.author != a && a != null && !a.equals(this.author)) {
            String oldValue = this.author;
            this.author = a == null ? null : a.intern();
            this.propChangeSupport.firePropertyChange("author", oldValue, this.author);
        }
    }

    public String getAuthor() {
        return this.author;
    }

    public void setParent(GestureContainer p) {
        if (p != this.parent) {
            GestureContainer oldValue = this.parent;
            this.parent = p;
            this.propChangeSupport.firePropertyChange("parent", oldValue, this.parent);
        }
    }

    public GestureContainer getParent() {
        return this.parent;
    }

    public void setEnabled(boolean on) {
        this.setProperty("enabled", new Boolean(on));
    }

    public boolean isEnabled() {
        return !this.hasProperty("enabled") || (Boolean)this.getProperty("enabled") != false;
    }

    public boolean hasProperty(String name) {
        return "author".equals(name) || "parent".equals(name) || this.properties.containsKey(name);
    }

    public void setProperty(String name, Object value) {
        if ("author".equals(name)) {
            this.setAuthor((String)value);
        } else if ("parent".equals(name)) {
            this.setParent((GestureContainer)value);
        } else {
            Object oldValue;
            boolean preExisting = this.hasProperty(name);
            if (preExisting) {
                oldValue = this.properties.get(name);
                if (oldValue == value) {
                    return;
                }
            } else {
                oldValue = null;
            }
            this.properties.put(name, value);
            this.propChangeSupport.firePropertyChange(name, oldValue, value);
        }
    }

    public void unsetProperty(String name) {
        if ("author".equals(name) || "enabled".equals(name) || "parent".equals(name)) {
            throw new IllegalArgumentException("Cannot remove predefined property '" + name + "'");
        }
        if (this.hasProperty(name)) {
            Object oldValue = this.getProperty(name);
            this.properties.remove(name);
            this.propChangeSupport.firePropertyChange(name, oldValue, null);
        }
    }

    public Object getProperty(String name) {
        if ("author".equals(name)) {
            return this.getAuthor();
        }
        if ("parent".equals(name)) {
            return this.getParent();
        }
        return this.properties.get(name);
    }

    public Object clone() {
        try {
            DefaultGestureObject result = (DefaultGestureObject)super.clone();
            result.properties = Properties.deepCopy(this.properties);
            result.propChangeSupport = new PropertyChangeSupport(result);
            result.parent = null;
            return result;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void readProperties(TokenReader reader) throws IOException, ParseException {
        this.properties = Properties.readProperties(reader);
    }

    public void writeProperties(Writer writer) throws IOException {
        Properties.writeProperties(writer, this.properties);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propChangeSupport.removePropertyChangeListener(propertyName, listener);
    }
}

