/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture;

import edu.berkeley.guir.lib.gesture.Classifier;
import edu.berkeley.guir.lib.gesture.Clique;
import edu.berkeley.guir.lib.gesture.GestureCategory;
import edu.berkeley.guir.lib.gesture.GestureSet;
import edu.berkeley.guir.lib.gesture.TrainingException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Vector;

public class CliqueList {
    Classifier classifier;
    Vector[] cliqueArray;
    double cliqueDistance;
    int biggestClique = 0;

    public CliqueList(GestureSet gs, double distance) throws TrainingException, InterruptedException {
        this(new Classifier(gs), distance);
    }

    public CliqueList(Classifier c, double distance) throws TrainingException, InterruptedException {
        if (c == null) {
            throw new NullPointerException("CliqueList must be given a non-null classifier");
        }
        this.classifier = c;
        this.cliqueDistance = distance;
        this.computeCliqueList();
    }

    private void computeCliqueList() throws TrainingException, InterruptedException {
        this.classifier.train();
        GestureSet gestureSet = this.classifier.getGestureSet();
        int numCategories = gestureSet.size();
        this.cliqueArray = new Vector[numCategories + 1];
        int i = 1;
        while (i < this.cliqueArray.length) {
            this.cliqueArray[i] = new Vector();
            ++i;
        }
        Iterator iter = gestureSet.iterator();
        while (iter.hasNext()) {
            GestureCategory gc = (GestureCategory)iter.next();
            Clique clique = new Clique();
            clique.add(gc);
            this.cliqueArray[1].addElement(clique);
        }
        int cliqueSize = 1;
        while (cliqueSize < numCategories) {
            Vector cliqueList = this.cliqueArray[cliqueSize];
            int numCliques = cliqueList.size();
            int cliqueIndex = 0;
            while (cliqueIndex < numCliques) {
                Clique clique = (Clique)cliqueList.elementAt(cliqueIndex);
                boolean newCliqueFound = false;
                Iterator catIter = gestureSet.iterator();
                while (catIter.hasNext()) {
                    GestureCategory gestureCategory = (GestureCategory)catIter.next();
                    if (clique.contains(gestureCategory) || !this.isClique(clique, gestureCategory)) continue;
                    Clique newClique = (Clique)clique.clone();
                    newClique.add(gestureCategory);
                    Vector v = this.cliqueArray[cliqueSize + 1];
                    if (!v.contains(newClique)) {
                        v.addElement(newClique);
                    }
                    newCliqueFound = true;
                }
                if (newCliqueFound) {
                    this.biggestClique = cliqueSize + 1;
                    cliqueList.removeElementAt(cliqueIndex);
                    --cliqueIndex;
                    --numCliques;
                }
                ++cliqueIndex;
            }
            ++cliqueSize;
        }
    }

    private boolean isClique(Clique clique, GestureCategory gestureCategory) {
        boolean closeEnough = true;
        double squaredDist = this.cliqueDistance * this.cliqueDistance;
        Iterator catIter = clique.iterator();
        while (catIter.hasNext() && closeEnough) {
            GestureCategory gc = (GestureCategory)catIter.next();
            double dist = this.classifier.categoryDistance(gc, gestureCategory);
            if (!(dist > squaredDist)) continue;
            closeEnough = false;
        }
        return closeEnough;
    }

    public void printCliques(PrintStream out) {
        this.printCliques(out, "");
    }

    public void printCliques(PrintStream out, String lineHeader) {
        int cliqueSize = 1;
        while (cliqueSize <= this.biggestClique) {
            Vector cliqueList = this.cliqueArray[cliqueSize];
            int numCliques = cliqueList.size();
            if (numCliques > 0) {
                out.print(String.valueOf(lineHeader) + cliqueSize + ": ");
                int cliqueIndex = 0;
                while (cliqueIndex < numCliques) {
                    Clique clique = (Clique)cliqueList.elementAt(cliqueIndex);
                    out.print("(");
                    Iterator catIter = clique.iterator();
                    while (catIter.hasNext()) {
                        GestureCategory gestureCategory = (GestureCategory)catIter.next();
                        out.print(gestureCategory.getName());
                        if (!catIter.hasNext()) continue;
                        out.print(", ");
                    }
                    out.print(") ");
                    ++cliqueIndex;
                }
                out.println();
            }
            ++cliqueSize;
        }
    }
}

