/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture;

import edu.berkeley.guir.lib.gesture.Feature;
import edu.berkeley.guir.lib.gesture.FeatureFactory;
import edu.berkeley.guir.lib.gesture.FeatureVector;
import edu.berkeley.guir.lib.gesture.Gesture;
import edu.berkeley.guir.lib.gesture.GestureCategory;
import edu.berkeley.guir.lib.gesture.GestureContainer;
import edu.berkeley.guir.lib.gesture.GestureObject;
import edu.berkeley.guir.lib.gesture.GestureSet;
import edu.berkeley.guir.lib.gesture.Properties;
import edu.berkeley.guir.lib.gesture.TimedPolygon;
import edu.berkeley.guir.lib.gesture.TrainingException;
import edu.berkeley.guir.lib.gesture.util.CollectionEvent;
import edu.berkeley.guir.lib.gesture.util.CollectionListener;
import edu.berkeley.guir.lib.gesture.util.Matrix;
import edu.berkeley.guir.lib.gesture.util.Misc;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Classifier {
    public static final String TRAINED_PROP = "trained";
    public static final String MISRECOGNIZED_PROP = "misrecognized";
    private static final Class[] DEFAULT_FEATURE_CLASSES;
    protected Class[] featureClasses = Classifier.getDefaultFeatureClasses();
    protected static final double EPSILON = 1.0E-6;
    protected GestureSet gestureSet;
    protected double[][] weights;
    protected double[][] meanFeatureValues;
    protected double[][] ccm;
    protected double[][] ccmInv;
    protected GestureCategory dotCategory = null;
    protected boolean trained = false;
    protected BitSet featuresUsed;
    protected List enabledCategories = null;
    protected CollectionListener myCollectionListener = new MyCollectionListener();
    protected PropertyChangeListener myPropChangeListener = new MyPropChangeListener();
    protected transient PropertyChangeSupport propChangeSupport = new PropertyChangeSupport(this);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;

    static {
        Properties.setPropertyPersistence(MISRECOGNIZED_PROP, false);
        Class[] classArray = new Class[11];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.gesture.features.InitAngleCosine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("edu.berkeley.guir.lib.gesture.features.InitAngleSine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("edu.berkeley.guir.lib.gesture.features.BoundsSize");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz3;
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("edu.berkeley.guir.lib.gesture.features.BoundsAngle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[3] = clazz4;
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("edu.berkeley.guir.lib.gesture.features.EndsDistance");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[4] = clazz5;
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("edu.berkeley.guir.lib.gesture.features.EndsAngleCosine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[5] = clazz6;
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("edu.berkeley.guir.lib.gesture.features.EndsAngleSine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[6] = clazz7;
        Class<?> clazz8 = class$7;
        if (clazz8 == null) {
            try {
                clazz8 = class$7 = Class.forName("edu.berkeley.guir.lib.gesture.features.TotalLength");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[7] = clazz8;
        Class<?> clazz9 = class$8;
        if (clazz9 == null) {
            try {
                clazz9 = class$8 = Class.forName("edu.berkeley.guir.lib.gesture.features.TotalAngle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[8] = clazz9;
        Class<?> clazz10 = class$9;
        if (clazz10 == null) {
            try {
                clazz10 = class$9 = Class.forName("edu.berkeley.guir.lib.gesture.features.TotalAbsAngle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[9] = clazz10;
        Class<?> clazz11 = class$10;
        if (clazz11 == null) {
            try {
                clazz11 = class$10 = Class.forName("edu.berkeley.guir.lib.gesture.features.Sharpness");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[10] = clazz11;
        DEFAULT_FEATURE_CLASSES = classArray;
    }

    public Classifier() {
        this(null);
    }

    public Classifier(GestureSet gs) {
        this.setGestureSet(gs);
    }

    public synchronized void setFeatureClasses(Class[] featureClasses) {
        if (this.featureClasses != featureClasses) {
            this.featureClasses = featureClasses;
            this.setTrained(false);
        }
    }

    public Class[] getFeatureClasses() {
        return this.featureClasses;
    }

    public static Class[] getDefaultFeatureClasses() {
        return DEFAULT_FEATURE_CLASSES;
    }

    public double[][] getWeights() {
        return this.weights;
    }

    public synchronized void setGestureSet(GestureSet gs) {
        if (this.gestureSet != gs) {
            if (this.gestureSet != null) {
                this.gestureSet.removeCollectionListener(this.myCollectionListener);
                this.gestureSet.removePropertyChangeListener(this.myPropChangeListener);
            }
            this.gestureSet = gs;
            if (this.gestureSet != null) {
                this.gestureSet.addCollectionListener(this.myCollectionListener);
                this.gestureSet.addPropertyChangeListener(this.myPropChangeListener);
            }
        }
    }

    public GestureSet getGestureSet() {
        return this.gestureSet;
    }

    public BitSet getFeaturesUsed() {
        return this.trained ? this.featuresUsed : null;
    }

    protected Feature getFeature(GestureCategory gc, int gIndex, int fIndex) {
        return this.getFeature(gc, gIndex, this.featureClasses[fIndex]);
    }

    protected Feature getFeature(GestureCategory gc, int gIndex, Class featureClass) {
        return FeatureFactory.getFeature(featureClass, gc.getChild(gIndex));
    }

    protected double[][] computeCovarianceMatrix(GestureCategory gestureCategory, double[] meanFeatureVector) {
        List enabledExamples = gestureCategory.getEnabledChildren();
        int numExamples = enabledExamples.size();
        int numFeatures = this.featureClasses.length;
        double[][] result = new double[numFeatures][numFeatures];
        if (meanFeatureVector == null) {
            meanFeatureVector = new double[numFeatures];
        }
        int featureNum = 0;
        while (featureNum < numFeatures) {
            Class featureClass = this.featureClasses[featureNum];
            double sum = 0.0;
            Iterator iter = enabledExamples.iterator();
            while (iter.hasNext()) {
                Feature feature = FeatureFactory.getFeature(featureClass, (GestureObject)iter.next());
                sum += feature.getValue();
            }
            meanFeatureVector[featureNum] = sum / (double)numExamples;
            ++featureNum;
        }
        int i = 0;
        while (i < numFeatures) {
            Class iFC = this.featureClasses[i];
            int j = i;
            while (j < numFeatures) {
                Class jFC = this.featureClasses[j];
                double sum = 0.0;
                Iterator iter = enabledExamples.iterator();
                while (iter.hasNext()) {
                    GestureObject example = (GestureObject)iter.next();
                    double fi = FeatureFactory.getFeature(iFC, example).getValue();
                    double fj = FeatureFactory.getFeature(jFC, example).getValue();
                    sum += (fi - meanFeatureVector[i]) * (fj - meanFeatureVector[j]);
                }
                result[i][j] = sum;
                ++j;
            }
            ++i;
        }
        return result;
    }

    protected void setTrained(boolean isTrained) {
        if (this.trained != isTrained) {
            this.trained = isTrained;
            this.propChangeSupport.firePropertyChange(TRAINED_PROP, new Boolean(!this.trained), new Boolean(this.trained));
        }
    }

    public boolean isTrained() {
        return this.trained;
    }

    protected void checkForInterrupt() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException("Training interrupted");
        }
    }

    public synchronized void train() throws TrainingException, InterruptedException {
        this.setTrained(false);
        this.dotCategory = null;
        this.weights = null;
        this.ccm = null;
        this.ccmInv = null;
        this.featuresUsed = null;
        this.enabledCategories = this.gestureSet.getEnabledCategories();
        int numCategories = this.enabledCategories.size();
        double[][][] covarMatrices = new double[numCategories][][];
        int numFeatures = this.featureClasses.length;
        this.meanFeatureValues = new double[numCategories][numFeatures];
        int gcNum = 0;
        Iterator iter = this.enabledCategories.iterator();
        while (iter.hasNext()) {
            GestureCategory gestureCategory = (GestureCategory)iter.next();
            covarMatrices[gcNum] = this.computeCovarianceMatrix(gestureCategory, this.meanFeatureValues[gcNum]);
            if (gestureCategory.isDot()) {
                if (this.dotCategory == null) {
                    this.dotCategory = gestureCategory;
                } else {
                    throw new TrainingException("Cannot discriminate the dot-like gestures " + gestureCategory.getName() + " and " + this.dotCategory.getName());
                }
            }
            ++gcNum;
        }
        this.checkForInterrupt();
        this.ccm = new double[numFeatures][numFeatures];
        double denominator = -numCategories;
        Iterator iter2 = this.enabledCategories.iterator();
        while (iter2.hasNext()) {
            GestureCategory gestureCategory = (GestureCategory)iter2.next();
            denominator += (double)gestureCategory.getEnabledChildren().size();
        }
        if (denominator <= 0.0) {
            throw new TrainingException("Too few examples for set " + this.gestureSet.getName());
        }
        int i = 0;
        while (i < numFeatures) {
            int j = i;
            while (j < numFeatures) {
                double sum = 0.0;
                gcNum = 0;
                Iterator iter3 = this.enabledCategories.iterator();
                while (iter3.hasNext()) {
                    GestureCategory gestureCategory = (GestureCategory)iter3.next();
                    sum += covarMatrices[gcNum][i][j];
                    ++gcNum;
                }
                this.ccm[i][j] = sum /= denominator;
                this.ccm[j][i] = sum;
                ++j;
            }
            ++i;
        }
        this.checkForInterrupt();
        this.ccmInv = new double[this.ccm.length][this.ccm.length];
        double det = Matrix.myInvert(this.ccm, this.ccmInv);
        if (Math.abs(det) >= 1.0E-6) {
            this.featuresUsed = new BitSet(numFeatures);
            int i2 = 0;
            while (i2 < numFeatures) {
                this.featuresUsed.set(i2);
                ++i2;
            }
        } else if (!this.fixClassifier(this.ccm, this.ccmInv)) {
            throw new TrainingException("Cannot invert common covariance matrix (determinant=" + Double.toString(det) + ")");
        }
        this.checkForInterrupt();
        this.weights = new double[this.enabledCategories.size()][numFeatures + 1];
        gcNum = 0;
        Iterator iter4 = this.enabledCategories.iterator();
        while (iter4.hasNext()) {
            GestureCategory gestureCategory = (GestureCategory)iter4.next();
            int j = 0;
            while (j < numFeatures) {
                double sum = 0.0;
                int i3 = 0;
                while (i3 < numFeatures) {
                    double mfv = this.meanFeatureValues[gcNum][i3];
                    double temp = this.ccmInv[i3][j];
                    sum += temp * mfv;
                    ++i3;
                }
                this.weights[gcNum][j + 1] = sum;
                ++j;
            }
            double sum = 0.0;
            int i4 = 0;
            while (i4 < numFeatures) {
                sum += this.weights[gcNum][i4 + 1] * this.meanFeatureValues[gcNum][i4];
                ++i4;
            }
            this.weights[gcNum][0] = -0.5 * sum;
            ++gcNum;
        }
        this.checkForInterrupt();
        this.setTrained(true);
    }

    protected boolean fixClassifier(double[][] ccm, double[][] ccmInv) {
        double det;
        double[][] r;
        double[][] m;
        int numFeatures = this.featureClasses.length;
        this.featuresUsed = new BitSet(numFeatures);
        int i = 0;
        while (i < numFeatures) {
            this.featuresUsed.set(i);
            m = Matrix.slice(ccm, this.featuresUsed, this.featuresUsed);
            r = new double[m.length][m.length];
            det = Matrix.myInvert(m, r);
            if (Math.abs(det) <= 1.0E-6) {
                this.featuresUsed.clear(i);
            }
            ++i;
        }
        m = Matrix.slice(ccm, this.featuresUsed, this.featuresUsed);
        det = Matrix.myInvert(m, r = new double[m.length][m.length]);
        if (Math.abs(det) <= 1.0E-6) {
            return false;
        }
        Matrix.deSlice(r, 0.0, this.featuresUsed, this.featuresUsed, ccmInv);
        return true;
    }

    public synchronized Result classify(Gesture gesture) throws TrainingException, InterruptedException {
        if (!this.trained) {
            this.train();
        }
        return this.classifyWithoutTraining(gesture);
    }

    public synchronized Result classifyWithoutTraining(Gesture gesture) {
        if (this.gestureSet == null || this.gestureSet.size() == 0) {
            return null;
        }
        List enabledCategories = this.gestureSet.getEnabledCategories();
        if (gesture.size() == 1) {
            if (this.dotCategory == null) {
                return new Result(null, 1.0, 0.0);
            }
            Iterator iter = enabledCategories.iterator();
            while (iter.hasNext()) {
                GestureCategory gestureCategory = (GestureCategory)iter.next();
                if (gestureCategory != this.dotCategory) continue;
                return new Result(gestureCategory, 1.0, 0.0);
            }
            return new Result(null, 1.0, 0.0);
        }
        int numCategories = enabledCategories.size();
        double[] disc = new double[numCategories];
        int catIndex = 0;
        while (catIndex < numCategories) {
            double sum = this.weights[catIndex][0];
            int featureNum = 0;
            while (featureNum < this.featureClasses.length) {
                Feature feature = FeatureFactory.getFeature(this.featureClasses[featureNum], gesture);
                sum += this.weights[catIndex][featureNum + 1] * feature.getValue();
                ++featureNum;
            }
            disc[catIndex] = sum;
            ++catIndex;
        }
        int bestGC = -1;
        int i = 0;
        GestureCategory bestCategory = null;
        Iterator iter = enabledCategories.iterator();
        while (iter.hasNext()) {
            GestureCategory category = (GestureCategory)iter.next();
            if (!category.isDot() && (bestCategory == null || disc[i] > disc[bestGC])) {
                bestGC = i;
                bestCategory = category;
            }
            ++i;
        }
        double denom = 0.0;
        i = 0;
        while (i < numCategories) {
            double d = disc[i] - disc[bestGC];
            if (d > -7.0) {
                denom += Math.exp(d);
            }
            ++i;
        }
        double distToMean = this.distanceToCategory(gesture, bestGC);
        return new Result(bestCategory, 1.0 / denom, distToMean);
    }

    public List testRecognition(GestureContainer container) throws InterruptedException, TrainingException {
        return this.testRecognition(container.iterator());
    }

    public List testRecognition(Iterator iter) throws InterruptedException, TrainingException {
        return this.testRecognition(iter, true);
    }

    public List testRecognition(Iterator iter, boolean onlyEnabled) throws InterruptedException, TrainingException {
        ArrayList misrecognizedGestures = new ArrayList();
        int i = 0;
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof GestureObject && (!onlyEnabled || ((GestureObject)obj).isEnabled())) {
                if (obj instanceof Gesture) {
                    Gesture gesture = (Gesture)obj;
                    if (this.testRecognition(gesture)) {
                        misrecognizedGestures.add(obj);
                    }
                } else if (obj instanceof GestureContainer) {
                    GestureContainer container = (GestureContainer)obj;
                    misrecognizedGestures.addAll(this.testRecognition(container.iterator()));
                }
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            ++i;
        }
        return misrecognizedGestures;
    }

    public boolean testRecognition(Gesture gesture) throws InterruptedException, TrainingException {
        boolean isMisrecognized;
        GestureCategory category = (GestureCategory)gesture.getParent();
        if (category == null) {
            throw new IllegalArgumentException("Gesture '" + gesture + "' does not have a parent");
        }
        Result result = this.classify(gesture);
        if (result == null) {
            throw new TrainingException("Cannot classify without a training set");
        }
        if (result.category == null || !Misc.areEqualOrNull(result.category.getName(), category.getName())) {
            isMisrecognized = true;
            gesture.setProperty(MISRECOGNIZED_PROP, result);
        } else {
            isMisrecognized = false;
            gesture.unsetProperty(MISRECOGNIZED_PROP);
        }
        return isMisrecognized;
    }

    public double categoryDistance(GestureCategory categoryA, GestureCategory categoryB) {
        if (!this.trained) {
            throw new IllegalStateException("Cannot call categoryDistance when classifier isn't trained.");
        }
        Classifier classifier = this;
        synchronized (classifier) {
            return this.categoryDistance(this.enabledCategories.indexOf(categoryA), this.enabledCategories.indexOf(categoryB));
        }
    }

    public double categoryDistance(int categoryA, int categoryB) {
        if (!this.trained) {
            throw new IllegalStateException("Cannot call categoryDistance when classifier isn't trained.");
        }
        if (categoryA == categoryB) {
            return 0.0;
        }
        Classifier classifier = this;
        synchronized (classifier) {
            return Classifier.MahalanobisDistance(this.meanFeatureValues[categoryA], this.meanFeatureValues[categoryB], this.ccmInv);
        }
    }

    public double distanceToCategory(Gesture gesture, GestureCategory category) {
        return this.distanceToCategory(gesture, this.enabledCategories.indexOf(category));
    }

    public synchronized double distanceToCategory(Gesture gesture, int catIndex) {
        return this.MahalanobisDistance(FeatureFactory.getValues(this.featureClasses, gesture), this.meanFeatureValues[catIndex]);
    }

    public double[] getNormalizedDistancesByFeature(Gesture gesture, String categoryName) {
        Iterator iter = this.enabledCategories.iterator();
        while (iter.hasNext()) {
            GestureCategory category = (GestureCategory)iter.next();
            if (!category.getName().equals(categoryName)) continue;
            return this.getNormalizedDistancesByFeature(gesture, category);
        }
        return null;
    }

    public double[] getNormalizedDistancesByFeature(Gesture gesture, GestureCategory gc) {
        return this.getNormalizedDistancesByFeature(gesture, this.enabledCategories.indexOf(gc));
    }

    public double[] getNormalizedDistancesByFeature(Gesture gesture, int categoryIndex) {
        double[] catFeatureVals = this.meanFeatureValues[categoryIndex];
        double[] gFeatureVals = FeatureFactory.getValues(this.featureClasses, gesture);
        int numFeatures = this.featureClasses.length;
        double[] delta = new double[numFeatures];
        int i = 0;
        while (i < numFeatures) {
            delta[i] = gFeatureVals[i] - catFeatureVals[i];
            ++i;
        }
        double[] dist = new double[numFeatures];
        int featureNum = 0;
        while (featureNum < numFeatures) {
            dist[featureNum] = delta[featureNum] * this.weights[categoryIndex][featureNum + 1];
            ++featureNum;
        }
        return dist;
    }

    public double[] getDistancesByFeature(int catA, int catB) {
        int numFeatures = this.featureClasses.length;
        double[] delta = new double[numFeatures];
        int i = 0;
        while (i < numFeatures) {
            delta[i] = this.meanFeatureValues[catA][i] - this.meanFeatureValues[catB][i];
            ++i;
        }
        return delta;
    }

    public synchronized List getTrainingCategories() {
        return Collections.unmodifiableList(this.enabledCategories);
    }

    public double MahalanobisDistance(double[] v, double[] u) {
        return Classifier.MahalanobisDistance(v, u, this.ccmInv);
    }

    public static double MahalanobisDistance(double[] v, double[] u, double[][] sigma) {
        double[] space = new double[v.length];
        int i = 0;
        while (i < v.length) {
            space[i] = v[i] - u[i];
            ++i;
        }
        double result = Matrix.QuadraticForm(space, sigma);
        return result;
    }

    public int findPrincipleComponent(double[] featureVals) {
        int numFeatures = featureVals.length;
        double[] v = new double[numFeatures];
        double max = 0.0;
        int maxIndex = -1;
        int i = 0;
        while (i < numFeatures) {
            if (i != 0) {
                v[i - 1] = 0.0;
            }
            v[i] = featureVals[i];
            double dist = Matrix.QuadraticForm(v, this.ccmInv);
            if (dist > max) {
                max = dist;
                maxIndex = i;
            }
            ++i;
        }
        return maxIndex;
    }

    public FeatureDirection findPrincipleFeature(int catA, int catB) {
        int numFeatures = this.featureClasses.length;
        double maxDist = 0.0;
        int maxDistIndex = -1;
        int direction = 0;
        int i = 0;
        while (i < numFeatures) {
            double delta = this.meanFeatureValues[catA][i] - this.meanFeatureValues[catB][i];
            double abs = Math.abs(delta);
            if (abs > maxDist) {
                maxDist = abs;
                maxDistIndex = i;
                direction = Misc.sign(delta);
            }
            ++i;
        }
        FeatureDirection result = new FeatureDirection();
        result.featureClass = this.featureClasses[maxDistIndex];
        result.a = (GestureCategory)this.enabledCategories.get(catA);
        result.b = (GestureCategory)this.enabledCategories.get(catB);
        result.direction = direction;
        return result;
    }

    public TimedPolygon getIdealGesturePoints(String gestureName) {
        return this.getGestureSet().getCategory(gestureName).gestureAt(0).getPoints();
    }

    public void dumpMFV(PrintStream out) {
        int width = FeatureVector.defaultSize();
        int gcNum = 0;
        while (gcNum < this.gestureSet.size()) {
            out.print("V " + width);
            int j = 0;
            while (j < width) {
                out.print(" " + this.meanFeatureValues[gcNum][j]);
                ++j;
            }
            out.println();
            ++gcNum;
        }
    }

    public void dump(PrintStream out) {
        int width = FeatureVector.defaultSize();
        int gcNum = 0;
        while (gcNum < this.gestureSet.size()) {
            out.print("V " + width);
            int j = 0;
            while (j < width) {
                out.print(" " + this.meanFeatureValues[gcNum][j]);
                ++j;
            }
            out.println();
            out.print("V " + width);
            j = 0;
            while (j < width) {
                out.print(" " + this.weights[gcNum][j + 1]);
                ++j;
            }
            out.println();
            ++gcNum;
        }
        out.print("V " + this.gestureSet.size());
        gcNum = 0;
        while (gcNum < this.gestureSet.size()) {
            out.print(" " + this.weights[gcNum][0]);
            ++gcNum;
        }
        out.println();
        out.print("V " + this.gestureSet.size());
        gcNum = 0;
        while (gcNum < this.gestureSet.size()) {
            GestureCategory gc = (GestureCategory)this.gestureSet.getChild(gcNum);
            out.print(" " + (gc.isDot() ? 1 : 0));
            ++gcNum;
        }
        out.println();
        out.println("M " + width + " " + width);
        int i = 0;
        while (i < width) {
            int j = 0;
            while (j < width) {
                out.print(" " + this.ccmInv[i][j]);
                ++j;
            }
            out.println();
            ++i;
        }
        Gesture g = (Gesture)((GestureContainer)this.gestureSet.getChild(0)).getChild(0);
        g.dump(out);
    }

    public void dumpRelativeVariance(PrintStream out) {
        int nFeatures = FeatureVector.defaultSize();
        int nClasses = this.gestureSet.size();
        out.print("Relative variance: ");
        int i = 0;
        while (i < nFeatures) {
            double sum = 0.0;
            int j = 0;
            while (j < nClasses) {
                sum += this.meanFeatureValues[j][i];
                ++j;
            }
            double avg = sum / (double)nClasses;
            out.print(String.valueOf(Misc.toString(this.ccm[i][i] / avg, 6)) + " ");
            ++i;
        }
        out.println();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public class Result {
        public GestureCategory category;
        public double accuracy;
        public double distToMean;

        public Result(GestureCategory cat, double acc, double dist) {
            this.category = cat;
            this.accuracy = acc;
            this.distToMean = dist;
        }
    }

    public class FeatureDirection {
        public GestureObject a;
        public GestureObject b;
        public Class featureClass;
        public int direction;
    }

    protected class MyCollectionListener
    implements CollectionListener {
        protected MyCollectionListener() {
        }

        public void elementChanged(CollectionEvent e) {
            Classifier.this.setTrained(false);
        }

        public void elementAdded(CollectionEvent e) {
            Classifier.this.setTrained(false);
        }

        public void elementRemoved(CollectionEvent e) {
            Classifier.this.setTrained(false);
        }
    }

    protected class MyPropChangeListener
    implements PropertyChangeListener {
        protected MyPropChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            PropertyChangeEvent realEvent = Properties.getRootEvent(e);
            if (realEvent.getPropertyName() == "children" || realEvent.getPropertyName() == "enabled") {
                Classifier.this.setTrained(false);
            }
        }
    }
}

