/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture;

import edu.berkeley.guir.lib.gesture.GestureCategoryDisplay;
import edu.berkeley.guir.lib.gesture.GestureCategoryThumbnail;
import edu.berkeley.guir.lib.gesture.GestureContainer;
import edu.berkeley.guir.lib.gesture.GestureSet;
import edu.berkeley.guir.lib.gesture.GestureSetDisplay;
import edu.berkeley.guir.lib.gesture.ToolTipUpdater;
import edu.berkeley.guir.lib.gesture.util.AbstractCTableModel;
import edu.berkeley.guir.lib.gesture.util.CTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ClassificationMatrix
extends JFrame
implements Observer {
    Vector[][] examples;
    Double[][] percentages;
    String[] rowNames;
    String[] colNames;
    GestureSet exampleSet;
    GestureSetDisplay exampleSetDisplay = null;
    GestureSet targetSet;
    CTable table;
    boolean markedOld = false;
    static /* synthetic */ Class class$0;

    ClassificationMatrix(Vector[][] exampleMatrix, GestureSet example, GestureSet target) {
        super("Classification Matrix");
        this.init(exampleMatrix, example, target);
    }

    ClassificationMatrix(Vector[][] exampleMatrix, GestureSetDisplay exampleDisplay, GestureSet target) {
        super("Classification Matrix");
        this.exampleSetDisplay = exampleDisplay;
        this.init(exampleMatrix, exampleDisplay.getGestureSet(), target);
    }

    ClassificationMatrix(Vector[][] exampleMatrix, GestureSetDisplay gsd) {
        this(exampleMatrix, gsd, gsd.getGestureSet());
    }

    private void init(Vector[][] exampleMatrix, GestureSet example, GestureSet target) {
        this.examples = exampleMatrix;
        this.exampleSet = example;
        this.targetSet = target;
        this.exampleSet.addObserver(this);
        this.targetSet.addObserver(this);
        this.computePercentages();
        this.buildUI();
    }

    private void computePercentages() {
        int numRows = this.examples.length;
        int numCols = this.examples[0].length;
        Double[][] temp = new Double[numRows][numCols];
        boolean[] interestingRow = new boolean[numRows];
        boolean[] interestingColumn = new boolean[numCols];
        int numInterestingRows = 0;
        int numInterestingColumns = 0;
        double[] numExamples = new double[numRows];
        int row = 0;
        while (row < numRows) {
            numExamples[row] = 0.0;
            int column = 0;
            while (column < numCols) {
                int count;
                if (this.examples[row][column] == null) {
                    count = 0;
                } else {
                    count = this.examples[row][column].size();
                    int n = row;
                    numExamples[n] = numExamples[n] + (double)count;
                }
                temp[row][column] = new Double(count);
                if (this.entryIsInteresting(row, column, count)) {
                    if (!interestingRow[row]) {
                        interestingRow[row] = true;
                        ++numInterestingRows;
                    }
                    if (!interestingColumn[column]) {
                        interestingColumn[column] = true;
                        ++numInterestingColumns;
                    }
                }
                ++column;
            }
            ++row;
        }
        int destRow = 0;
        this.percentages = new Double[numInterestingRows][numInterestingColumns];
        this.rowNames = new String[numInterestingRows];
        this.colNames = new String[numInterestingColumns];
        int sourceRow = 0;
        while (sourceRow < numRows) {
            if (interestingRow[sourceRow]) {
                this.rowNames[destRow] = ((GestureContainer)this.exampleSet.getChild(sourceRow)).getName();
                int destColumn = 0;
                int sourceColumn = 0;
                while (sourceColumn < numCols) {
                    if (interestingColumn[sourceColumn]) {
                        this.colNames[destColumn] = ((GestureContainer)this.targetSet.getChild(sourceColumn)).getName();
                        Double current = temp[sourceRow][sourceColumn];
                        this.percentages[destRow][destColumn] = this.entryIsInteresting(sourceRow, sourceColumn, current) ? new Double(current / numExamples[sourceRow]) : null;
                        ++destColumn;
                    }
                    ++sourceColumn;
                }
                ++destRow;
            }
            ++sourceRow;
        }
    }

    private void buildUI() {
        Container contents = this.getContentPane();
        contents.setLayout(new BorderLayout());
        AbstractCTableModel dataModel = new AbstractCTableModel(){

            public int getColumnCount() {
                return ClassificationMatrix.this.percentages[0].length;
            }

            public int getRowCount() {
                return ClassificationMatrix.this.percentages.length;
            }

            public Object getValueAt(int r, int c) {
                return ClassificationMatrix.this.percentages[r][c];
            }

            public Class getColumnClass(int c) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }

            public String getColumnName(int c) {
                return ClassificationMatrix.this.colNames[c];
            }

            public String getRowName(int r) {
                return ClassificationMatrix.this.rowNames[r];
            }
        };
        this.table = new CTable(dataModel);
        new ColorRenderer(this.table);
        this.table.setRowSelectionAllowed(false);
        this.table.setColumnSelectionAllowed(false);
        this.table.setAutoResizeMode(0);
        this.table.addMouseMotionListener(new ToolTipUpdater(this.table));
        if (this.exampleSetDisplay != null) {
            this.table.addMouseListener(new MyMouseListener());
            TableColumnModel tcm = this.table.getColumnModel();
            int i = 0;
            while (i < dataModel.getColumnCount()) {
                TableColumn column = tcm.getColumn(i);
                column.setWidth(column.getWidth() / 2);
                ++i;
            }
        }
        JScrollPane scrollPane = new JScrollPane(this.table);
        contents.add((Component)scrollPane, "Center");
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("Table");
        JMenuItem item = new JMenuItem("Close");
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassificationMatrix.this.dispose();
            }
        };
        item.addActionListener(listener);
        menu.add(item);
        menuBar.add(menu);
        this.getRootPane().setJMenuBar(menuBar);
    }

    boolean entryIsInteresting(int row, int column, double value) {
        return ((GestureContainer)this.exampleSet.getChild(row)).getName().equals(((GestureContainer)this.targetSet.getChild(column)).getName()) && value != 1.0 || value != 0.0;
    }

    public void update(Observable o, Object arg) {
        if (!this.markedOld) {
            this.setTitle(String.valueOf(this.getTitle()) + " - OLD");
            this.markedOld = true;
        }
    }

    class ColorRenderer
    implements TableCellRenderer {
        TableCellRenderer stringRenderer;
        TableCellRenderer objectRenderer;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;
        static /* synthetic */ Class class$2;

        ColorRenderer(JTable table) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.stringRenderer = table.getDefaultRenderer(clazz);
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.objectRenderer = table.getDefaultRenderer(clazz2);
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("java.lang.Double");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            table.setDefaultRenderer(clazz3, this);
            Class<?> clazz4 = class$0;
            if (clazz4 == null) {
                try {
                    clazz4 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            table.setDefaultRenderer(clazz4, this);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            TableCellRenderer renderer;
            double x;
            if (value == null) {
                Component defaultComponent = this.objectRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                defaultComponent.setBackground(Color.white);
                return defaultComponent;
            }
            if (value instanceof String) {
                x = 0.0;
                renderer = this.stringRenderer;
            } else {
                x = (Double)value;
                value = new Long(Math.round(x * 100.0));
                renderer = this.objectRenderer;
            }
            Component defaultComponent = renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            boolean diagonal = ClassificationMatrix.this.rowNames[row].equals(ClassificationMatrix.this.colNames[column]);
            if (diagonal && x < 1.0) {
                defaultComponent.setBackground(Color.yellow);
            } else if (!diagonal && x > 0.0) {
                defaultComponent.setBackground(Color.red);
            } else {
                defaultComponent.setBackground(Color.white);
            }
            return defaultComponent;
        }
    }

    class MyMouseListener
    extends MouseAdapter {
        MyMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            Point p = e.getPoint();
            int row = ClassificationMatrix.this.table.rowAtPoint(p);
            int column = ClassificationMatrix.this.table.columnAtPoint(p);
            if (column >= 0 && ClassificationMatrix.this.examples[row][column] != null) {
                GestureCategoryThumbnail gct = ClassificationMatrix.this.exampleSetDisplay.getGestureCategoryThumbnail(row);
                gct.createCategoryFrame();
                GestureCategoryDisplay gcd = gct.getCategoryFrame().getGestureCategoryDisplay();
                String inName = ClassificationMatrix.this.table.getModel().getColumnName(row);
                String outName = ClassificationMatrix.this.table.getModel().getColumnName(column);
                gcd.narrow(ClassificationMatrix.this.examples[row][column], String.valueOf(inName) + " classified as " + outName);
                gct.showCategoryFrame();
            } else {
                System.err.println("No examples there");
            }
        }
    }
}

