/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture;

import edu.berkeley.guir.lib.gesture.GestureContainer;
import edu.berkeley.guir.lib.gesture.GestureSet;
import edu.berkeley.guir.lib.gesture.util.Misc;
import edu.berkeley.guir.lib.gesture.util.SolidIcon;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.BitSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.border.Border;
import javax.swing.event.EventListenerList;

public class CategoryPicker
extends Box
implements ItemSelectable {
    static final Dimension iconSize = new Dimension(20, 20);
    JCheckBox[] checkBoxes;
    protected EventListenerList itemListenerList = new EventListenerList();
    int numSelected;
    GestureSet gestureSet;
    Color[] colorScheme;
    BitSet categoryMask;
    static /* synthetic */ Class class$0;

    public CategoryPicker(GestureSet gs, Color[] colorScheme) {
        super(1);
        this.gestureSet = gs;
        this.colorScheme = colorScheme;
        this.categoryMask = Misc.not(new BitSet(this.gestureSet == null ? 0 : this.gestureSet.size()));
        this.buildUI();
    }

    public CategoryPicker(GestureSet gs) {
        this(gs, null);
    }

    void buildUI() {
        int numRows = this.gestureSet.size();
        this.checkBoxes = new JCheckBox[numRows];
        Border raisedBorder = BorderFactory.createRaisedBevelBorder();
        Border loweredBorder = BorderFactory.createLoweredBevelBorder();
        int i = 0;
        while (i < numRows) {
            Color iconColor = this.colorScheme == null ? Color.black : this.colorScheme[i % this.colorScheme.length];
            this.checkBoxes[i] = new JCheckBox(((GestureContainer)this.gestureSet.getChild(i)).getName(), true);
            this.checkBoxes[i].setIcon(new SolidIcon(Color.black, iconSize, raisedBorder));
            this.checkBoxes[i].setSelectedIcon(new SolidIcon(iconColor, iconSize, loweredBorder));
            this.checkBoxes[i].addItemListener(new CheckBoxListener(i));
            this.add(this.checkBoxes[i]);
            ++i;
        }
        this.numSelected = numRows;
    }

    public void setCategorySelected(int categoryNum, boolean on) {
        this.checkBoxes[categoryNum].setSelected(on);
    }

    public boolean isCategorySelected(int categoryNum) {
        return this.checkBoxes[categoryNum].isSelected();
    }

    public int getNumSelected() {
        return this.numSelected;
    }

    public void addItemListener(ItemListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.awt.event.ItemListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.itemListenerList.add(clazz, l);
    }

    public void removeItemListener(ItemListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.awt.event.ItemListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.itemListenerList.remove(clazz, l);
    }

    protected void fireItemChange(int type, int categoryNum, int selectState) {
        ItemEvent event = null;
        Object[] listeners = this.itemListenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            Object object = listeners[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("java.awt.event.ItemListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                if (event == null) {
                    event = new ItemEvent(this, type, new Integer(categoryNum), selectState);
                }
                ((ItemListener)listeners[i + 1]).itemStateChanged(event);
            }
            i -= 2;
        }
    }

    public Object[] getSelectedObjects() {
        Object[] result = new Object[this.numSelected];
        int ri = 0;
        int i = 0;
        while (i < this.checkBoxes.length) {
            if (this.checkBoxes[i].isSelected()) {
                result[ri++] = new Integer(i);
            }
            ++i;
        }
        return result;
    }

    public BitSet getCategoryMask() {
        return this.categoryMask;
    }

    public void setCategoryMask(BitSet mask) {
        if (mask != this.categoryMask) {
            this.categoryMask = mask;
            this.updateCheckboxes();
        }
    }

    public int numCategories() {
        return this.checkBoxes.length;
    }

    void updateCheckboxes() {
        int numBoxes = this.checkBoxes.length;
        int i = 0;
        while (i < numBoxes) {
            JCheckBox cb = this.checkBoxes[i];
            if (this.categoryMask.get(i)) {
                if (!cb.isSelected()) {
                    cb.setSelected(true);
                }
                if (this.colorScheme != null) {
                    SolidIcon icon = (SolidIcon)cb.getSelectedIcon();
                    icon.setColor(this.colorScheme[i % this.colorScheme.length]);
                }
            } else if (cb.isSelected()) {
                cb.setSelected(false);
            }
            cb.repaint();
            ++i;
        }
    }

    public class CheckBoxListener
    implements ItemListener {
        int cbNum;

        CheckBoxListener(int n) {
            this.cbNum = n;
        }

        public void itemStateChanged(ItemEvent e) {
            CategoryPicker.this.numSelected = e.getStateChange() == 1 ? ++CategoryPicker.this.numSelected : --CategoryPicker.this.numSelected;
            int stateChange = e.getStateChange();
            if (CategoryPicker.this.categoryMask != null) {
                switch (stateChange) {
                    case 1: {
                        CategoryPicker.this.categoryMask.set(this.cbNum);
                        break;
                    }
                    case 2: {
                        CategoryPicker.this.categoryMask.clear(this.cbNum);
                        break;
                    }
                    default: {
                        System.err.println("gdt: error: Bogosity in CategoryPicker$CheckBoxListener");
                    }
                }
            }
            CategoryPicker.this.updateCheckboxes();
            CategoryPicker.this.fireItemChange(701, this.cbNum, stateChange);
        }
    }
}

