/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.gesture;

import edu.berkeley.guir.lib.gesture.DefaultGestureObject;
import edu.berkeley.guir.lib.gesture.GestureContainer;
import edu.berkeley.guir.lib.gesture.GestureObject;
import edu.berkeley.guir.lib.gesture.Properties;
import edu.berkeley.guir.lib.gesture.util.CollectionAdapter;
import edu.berkeley.guir.lib.gesture.util.CollectionEvent;
import edu.berkeley.guir.lib.gesture.util.CollectionListener;
import edu.berkeley.guir.lib.gesture.util.Misc;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.EventListenerList;

public abstract class AbstractGestureContainer
extends DefaultGestureObject
implements GestureContainer,
Cloneable {
    protected transient EventListenerList listenerList = new EventListenerList();
    protected String name = null;
    protected CollectionListener collectionListener = new MyCollectionListener();
    protected PropertyChangeListener propChangeListener = new MyPropChangeListener();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Properties.setPropertyPersistence("children", false);
    }

    public void setName(String n) {
        if (this.name != n && n != null && !n.equals(this.name)) {
            String oldValue = this.name;
            this.name = n == null ? null : n.intern();
            this.propChangeSupport.firePropertyChange("name", oldValue, this.name);
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean hasProperty(String prop) {
        return "name".equals(prop) || super.hasProperty(prop);
    }

    public void setPropertyOnTree(String propName, Object value) {
        this.setProperty(propName, value);
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            GestureObject child = (GestureObject)iter.next();
            if (child instanceof GestureContainer) {
                ((GestureContainer)child).setPropertyOnTree(propName, value);
                continue;
            }
            child.setProperty(propName, value);
        }
    }

    public void setProperty(String propName, Object value) {
        if ("name".equals(propName)) {
            this.setName((String)value);
        } else {
            super.setProperty(propName, value);
        }
    }

    public Object getProperty(String propName) {
        if ("name".equals(propName)) {
            return this.getName();
        }
        return super.getProperty(propName);
    }

    public void addCollectionListener(CollectionListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.gesture.util.CollectionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, l);
    }

    public void removeCollectionListener(CollectionListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.gesture.util.CollectionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.remove(clazz, l);
    }

    protected void fireCollectionEvent(int type, GestureObject element, int startIndex) {
        GestureObject[] obj = new GestureObject[]{element};
        this.fireCollectionEvent(type, obj, startIndex);
    }

    protected void fireCollectionEvent(int type, GestureObject[] elements, int startIndex) {
        CollectionEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            Object object = listeners[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("edu.berkeley.guir.lib.gesture.util.CollectionListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                if (event == null) {
                    event = new CollectionEvent((Object)this, type, elements, startIndex);
                }
                switch (type) {
                    case 0: {
                        ((CollectionListener)listeners[i + 1]).elementAdded(event);
                        break;
                    }
                    case 1: {
                        ((CollectionListener)listeners[i + 1]).elementRemoved(event);
                        break;
                    }
                    case 2: {
                        ((CollectionListener)listeners[i + 1]).elementChanged(event);
                    }
                }
            }
            i -= 2;
        }
    }

    public Object clone() {
        AbstractGestureContainer result = (AbstractGestureContainer)super.clone();
        result.listenerList = new EventListenerList();
        result.collectionListener = new MyCollectionListener();
        return result;
    }

    protected void fixParents() {
        int i = 0;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            GestureObject child = (GestureObject)iter.next();
            child.setParent(this);
            ++i;
        }
    }

    public boolean isChildType(Class type) {
        Class[] validTypes = this.getChildTypes();
        boolean result = false;
        int i = 0;
        while (i < validTypes.length && !result) {
            if (validTypes[i].isAssignableFrom(type)) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    public GestureObject getChild(String name) {
        GestureObject result = null;
        Iterator iter = this.iterator();
        while (iter.hasNext() && result == null) {
            String childName;
            GestureObject child = (GestureObject)iter.next();
            if (!(child instanceof GestureContainer) || ((childName = ((GestureContainer)child).getName()) == null || !childName.equals(name)) && name != childName) continue;
            result = child;
        }
        return result;
    }

    public String getUniqueName(String startingName) {
        String result = startingName;
        int i = 1;
        while (this.getChild(result) != null) {
            result = String.valueOf(startingName) + " " + i;
            ++i;
        }
        return result;
    }

    protected abstract List getChildren();

    public void add(GestureObject obj) {
        if (this.isChildType(obj.getClass())) {
            List members = this.getChildren();
            if (!members.contains(obj)) {
                members.add(obj);
                obj.setParent(this);
                if (obj instanceof GestureContainer) {
                    ((GestureContainer)obj).addCollectionListener(this.collectionListener);
                }
                obj.addPropertyChangeListener(this.propChangeListener);
                this.fireCollectionEvent(0, obj, -1);
                this.propChangeSupport.firePropertyChange("children", null, obj);
            }
        } else {
            throw new IllegalArgumentException("Objects of type " + obj.getClass().getName() + " cannot be added to " + this + " [" + this.getClass().getName() + "].");
        }
    }

    public GestureObject getChild(int i) {
        return (GestureObject)this.getChildren().get(i);
    }

    public void remove(GestureObject obj) {
        if (obj != null) {
            if (obj instanceof GestureContainer) {
                ((GestureContainer)obj).removeCollectionListener(this.collectionListener);
            }
            List members = this.getChildren();
            int index = members.indexOf(obj);
            members.remove(index);
            obj.setParent(null);
            this.fireCollectionEvent(1, obj, index);
            this.propChangeSupport.firePropertyChange("children", obj, null);
        }
    }

    public int size() {
        return this.getChildren().size();
    }

    public boolean contains(GestureObject obj) {
        return this.getChildren().contains(obj);
    }

    public int indexOf(GestureObject obj) {
        return this.getChildren().indexOf(obj);
    }

    public Iterator iterator() {
        return this.getChildren().iterator();
    }

    public List getEnabledChildren() {
        return (List)Misc.accept(this.getChildren(), new Misc.Acceptor(){

            public boolean accept(Object obj) {
                GestureObject g = (GestureObject)obj;
                return g.isEnabled();
            }
        });
    }

    public static GestureContainer findAncestorOfClass(GestureObject obj, Class type) {
        if (obj == null) {
            return null;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("edu.berkeley.guir.lib.gesture.GestureContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Argument 'type' must be a subclass of GestureContainer");
        }
        if (type.isInstance(obj)) {
            return (GestureContainer)obj;
        }
        GestureContainer result = obj.getParent();
        while (!type.isInstance(result)) {
            result = result.getParent();
        }
        return result;
    }

    public static List getChildList(GestureContainer container) {
        if (container instanceof AbstractGestureContainer) {
            return Collections.unmodifiableList(((AbstractGestureContainer)container).getChildren());
        }
        return Collections.unmodifiableList(Misc.mapcar(container.iterator(), Misc.IDENTITY_OPERATOR));
    }

    protected class MyCollectionListener
    extends CollectionAdapter {
        protected MyCollectionListener() {
        }

        public void elementChanged(CollectionEvent e) {
            GestureObject source = (GestureObject)e.getSource();
            AbstractGestureContainer.this.fireCollectionEvent(2, source, AbstractGestureContainer.this.indexOf(source));
        }
    }

    protected class MyPropChangeListener
    implements PropertyChangeListener {
        protected MyPropChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            PropertyChangeEvent newE = new PropertyChangeEvent(AbstractGestureContainer.this, "child changed", null, e);
            newE.setPropagationId(e.getPropagationId());
            AbstractGestureContainer.this.propChangeSupport.firePropertyChange(newE);
        }
    }
}

