/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.debugging.introspect;

import edu.berkeley.guir.lib.debugging.introspect.DefaultIntrospectHandler;
import edu.berkeley.guir.lib.debugging.introspect.IntrospectLib;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class PrintIntrospectHandler
extends DefaultIntrospectHandler {
    private static final String SPACES = "                                                                                                       ";
    private PrintWriter wtr;

    public PrintIntrospectHandler() {
        this(System.out);
    }

    public PrintIntrospectHandler(Writer out) {
        this.wtr = new PrintWriter(out, true);
    }

    public PrintIntrospectHandler(OutputStream ostream) {
        this.wtr = new PrintWriter(ostream, true);
    }

    protected void output(int depth, Field f, String strVal) {
        if (f == null) {
            this.wtr.println(strVal);
        } else {
            this.wtr.println(String.valueOf(SPACES.substring(0, 3 * depth)) + IntrospectLib.getModString(f.getModifiers()) + IntrospectLib.getTypeString(f.getType()) + " " + f.getName() + "=" + strVal);
        }
    }

    public boolean acceptField(int depth, Field f, Object obj) {
        int val = f.getModifiers();
        return !Modifier.isFinal(val) || !Modifier.isStatic(val);
    }

    public boolean shouldRecurse(int depth, Field f, Object obj) {
        return !obj.getClass().getName().startsWith("java");
    }
}

