/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.debugging.introspect;

import edu.berkeley.guir.lib.debugging.Debug;
import edu.berkeley.guir.lib.debugging.introspect.DefaultIntrospectHandler;
import edu.berkeley.guir.lib.debugging.introspect.Introspect;
import edu.berkeley.guir.lib.debugging.introspect.IntrospectLib;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Stack;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class JTreeIntrospectHandler
extends DefaultIntrospectHandler {
    JTree tree;
    Stack stackTreeNodes = new Stack();
    int lastDepth = 0;
    DefaultMutableTreeNode topNode;
    DefaultMutableTreeNode currentNode;
    DefaultMutableTreeNode lastNode;
    JFrame currentFrame;
    Object root;

    protected String toString(Object obj) {
        if (obj == null) {
            return "<I>null</I>";
        }
        return super.toString(obj);
    }

    public JTree getJTree() {
        this.tree = new JTree(this.topNode);
        this.tree.addTreeSelectionListener(new InternalTreeSelectionListener());
        this.tree.addTreeWillExpandListener(new InternalTreeWillExpandListener());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        return this.tree;
    }

    private DefaultMutableTreeNode getTopNode() {
        return this.topNode;
    }

    public void displayJTree() {
        String[] strInfo = Debug.getCurrentClassAndMethod();
        JTree tree = this.getJTree();
        JFrame frame = new JFrame(this.root.getClass() + " - called in " + strInfo[1] + "." + strInfo[2] + "()");
        JScrollPane treeView = new JScrollPane(tree);
        frame.getContentPane().add(treeView);
        frame.pack();
        frame.setVisible(true);
        this.currentFrame = frame;
    }

    private void getCurrentTreeNode(int depth) {
        if (depth > this.lastDepth) {
            if (this.currentNode == null) {
                this.currentNode = this.lastNode;
            } else {
                this.stackTreeNodes.push(this.currentNode);
                this.currentNode.add(this.lastNode);
                this.currentNode = this.lastNode;
            }
        } else if (depth < this.lastDepth) {
            try {
                int i = depth;
                while (i < this.lastDepth) {
                    this.currentNode = (DefaultMutableTreeNode)this.stackTreeNodes.pop();
                    ++i;
                }
            }
            catch (Exception e) {
                System.err.println("oops, empty stack");
            }
        }
        this.lastDepth = depth;
    }

    private void addNode(int depth, DebugInfo d) {
        if (depth == 0) {
            this.root = d.obj;
            this.topNode = new DefaultMutableTreeNode(d);
            this.currentNode = null;
            this.lastNode = this.topNode;
            this.lastDepth = 0;
            return;
        }
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(d);
        this.getCurrentTreeNode(depth);
        this.currentNode.add(newNode);
        this.lastNode = newNode;
    }

    protected void output(int depth, Field f, String str) {
        this.addNode(depth, new DebugInfo(f, str, null));
    }

    public void onRoot(Object obj) {
        this.onObject(0, null, obj);
    }

    public void onObject(int depth, Field f, Object obj) {
        this.addNode(depth, new DebugInfo(f, obj.toString(), obj));
        this.addNode(depth + 1, new DebugInfo("", obj));
    }

    public boolean shouldRecurse(int depth, int mods, Class type, Object obj) {
        return depth <= 0;
    }

    class InternalTreeSelectionListener
    implements TreeSelectionListener {
        InternalTreeSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent evt) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)JTreeIntrospectHandler.this.tree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            DebugInfo d = (DebugInfo)node.getUserObject();
            if (d.obj != null) {
                Debug.displayObjectTree(d.obj);
            }
        }
    }

    class InternalTreeWillExpandListener
    implements TreeWillExpandListener {
        InternalTreeWillExpandListener() {
        }

        public void treeWillExpand(TreeExpansionEvent e) {
            TreePath p = e.getPath();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)p.getLastPathComponent();
            DebugInfo dinf = (DebugInfo)node.getUserObject();
            node.removeAllChildren();
            JTreeIntrospectHandler h = new JTreeIntrospectHandler();
            Introspect.parseObject(dinf.obj, h);
            DefaultMutableTreeNode newTopNode = h.getTopNode();
            Enumeration<TreeNode> en = newTopNode.children();
            while (en.hasMoreElements()) {
                node.add((MutableTreeNode)en.nextElement());
            }
        }

        public void treeWillCollapse(TreeExpansionEvent e) {
            TreePath p = e.getPath();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)p.getLastPathComponent();
            DebugInfo dinf = (DebugInfo)node.getUserObject();
            node.removeAllChildren();
            node.add(new DefaultMutableTreeNode());
        }
    }

    class DebugInfo {
        String strName;
        Object obj;

        public DebugInfo(String newStrName, Object newObj) {
            this.strName = newStrName;
            this.obj = newObj;
        }

        public DebugInfo(int mods, String type, String name, String val, Object newObj) {
            this.strName = "<html><font color=\"#0000ff\">" + IntrospectLib.getModString(mods) + "</font><font color=\"#009900\">" + type + "</font> " + "<b>" + name + "</b> = " + val + "</html>";
            this.obj = newObj;
        }

        public DebugInfo(Field f, String val, Object newObj) {
            this.strName = f != null ? "<html><font color=\"#0000ff\">" + IntrospectLib.getModString(f.getModifiers()) + "</font><font color=\"#009900\">" + IntrospectLib.getTypeString(f.getType()) + "</font> " + "<b>" + f.getName() + "</b> = " + val + "</html>" : "<html><font color=\"#009900\">" + newObj.getClass() + "</font> " + " = " + val + "</html>";
            this.obj = newObj;
        }

        public String toString() {
            return this.strName;
        }
    }
}

